/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.gui.actions.AbstractMarkupItemAction;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class ReplaceFirstMarkupItemAction
extends AbstractMarkupItemAction {
    private static final String MENU_GROUP = "A_VT_Apply_Edit";

    public ReplaceFirstMarkupItemAction(VTController controller, boolean addToToolbar) {
        super(controller, "Apply (Replace First Only)");
        Icon replacedIcon = VTPlugin.REPLACED_ICON;
        ImageIcon warningIcon = ResourceManager.loadImage((String)"images/warning_obj.png");
        warningIcon = ResourceManager.getScaledIcon((Icon)warningIcon, (int)12, (int)12);
        MultiIcon multiIcon = new MultiIcon(replacedIcon, false);
        int refreshIconWidth = replacedIcon.getIconWidth();
        int refreshIconHeight = replacedIcon.getIconHeight();
        int warningIconWidth = warningIcon.getIconWidth();
        int warningIconHeight = warningIcon.getIconHeight();
        int x = refreshIconWidth - warningIconWidth;
        int y = refreshIconHeight - warningIconHeight;
        TranslateIcon translateIcon = new TranslateIcon((Icon)warningIcon, x, y);
        multiIcon.addIcon((Icon)translateIcon);
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData((Icon)multiIcon, MENU_GROUP));
        }
        MenuData menuData = new MenuData(new String[]{"Apply (Replace First Only)"}, replacedIcon, MENU_GROUP);
        menuData.setMenuSubGroup("2");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Replace_First_Markup_Item"));
    }

    @Override
    public ToolOptions getApplyOptions() {
        ToolOptions options = this.controller.getOptions();
        ToolOptions vtOptions = options.copy();
        vtOptions.setEnum("Apply Markup Options.Data Match Data Type", (Enum)VTMatchApplyChoices.ReplaceDataChoices.REPLACE_FIRST_DATA_ONLY);
        return vtOptions;
    }

    @Override
    public VTMarkupItemApplyActionType getActionType() {
        return VTMarkupItemApplyActionType.REPLACE_FIRST_ONLY;
    }
}

