/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InstructionBlockFlow;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class InstructionBlock
implements Iterable<Instruction> {
    private boolean isStartOfFlow = false;
    private Address startAddr;
    private Address maxAddress;
    private Address flowFrom;
    private Address lastInstructionAddress;
    private Address fallthroughAddress;
    private LinkedHashMap<Address, Instruction> instructionMap = new LinkedHashMap();
    private List<Address> flowAddresses = new ArrayList<Address>();
    private List<InstructionBlockFlow> blockFlows;
    private InstructionError instructionError;
    private int instructionsAddedCount;

    public InstructionBlock(Address startAddr) {
        this.startAddr = startAddr;
    }

    public void setStartOfFlow(boolean isStart) {
        this.isStartOfFlow = isStart;
    }

    public boolean isFlowStart() {
        return this.isStartOfFlow;
    }

    public Address getStartAddress() {
        return this.startAddr;
    }

    public Address getMaxAddress() {
        return this.maxAddress != null ? this.maxAddress : this.startAddr;
    }

    public Instruction getInstructionAt(Address address) {
        return this.instructionMap.get(address);
    }

    public Instruction findFirstIntersectingInstruction(Address min, Address max) {
        MemBuffer intersectInstr = null;
        for (Instruction instr : this.instructionMap.values()) {
            Address instrMax;
            Address instrMin = instr.getMinAddress();
            if (instrMin.compareTo(max) > 0 || (instrMax = instr.getMaxAddress()).compareTo(min) < 0 || intersectInstr != null && intersectInstr.getAddress().compareTo(instrMin) < 0) continue;
            intersectInstr = instr;
        }
        return intersectInstr;
    }

    public String toString() {
        return "[ " + this.startAddr + (String)(this.maxAddress != null ? "-" + this.maxAddress : ": <empty>") + "]";
    }

    public void addInstruction(Instruction instruction) {
        Address instructionMinAddr = instruction.getMinAddress();
        if (this.maxAddress == null) {
            if (!instructionMinAddr.equals(this.startAddr)) {
                throw new IllegalArgumentException("First instruction to block had address " + instructionMinAddr + ", expected address " + this.startAddr);
            }
        } else if (!this.maxAddress.isSuccessor(instructionMinAddr)) {
            throw new IllegalArgumentException("Newly added instruction at address " + instructionMinAddr + " is not the immediate succesor to address " + this.maxAddress);
        }
        this.instructionMap.put(instructionMinAddr, instruction);
        if (!instruction.isInDelaySlot()) {
            this.lastInstructionAddress = instruction.getMinAddress();
        }
        this.maxAddress = instruction.getMaxAddress();
    }

    public void addBlockFlow(InstructionBlockFlow blockFlow) {
        if (this.blockFlows == null) {
            this.blockFlows = new ArrayList<InstructionBlockFlow>();
        }
        this.blockFlows.add(blockFlow);
    }

    public void addBranchFlow(Address destinationAddress) {
        this.flowAddresses.add(destinationAddress);
    }

    public void setFallThrough(Address fallthroughAddress) {
        this.fallthroughAddress = fallthroughAddress;
    }

    public List<Address> getBranchFlows() {
        return this.flowAddresses;
    }

    public List<InstructionBlockFlow> getBlockFlows() {
        return this.blockFlows;
    }

    public Address getFallThrough() {
        return this.fallthroughAddress;
    }

    public void setInstructionError(InstructionError.InstructionErrorType type, Address intendedInstructionAddress, Address conflictAddress, Address flowFromAddress, String message) {
        if (type == InstructionError.InstructionErrorType.PARSE) {
            throw new IllegalArgumentException("use setParseConflict for PARSE conflicts");
        }
        this.instructionError = new InstructionError(this, type, intendedInstructionAddress, conflictAddress, flowFromAddress, message);
    }

    public void setInstructionMemoryError(Address instrAddr, Address flowFromAddr, String errorMsg) {
        this.setInstructionError(InstructionError.InstructionErrorType.MEMORY, instrAddr, instrAddr, flowFromAddr, errorMsg);
    }

    public void setInconsistentPrototypeConflict(Address instrAddr, Address flowFromAddr) {
        this.setInstructionError(InstructionError.InstructionErrorType.INSTRUCTION_CONFLICT, instrAddr, instrAddr, flowFromAddr, "Multiple flows produced inconsistent instruction prototype at " + instrAddr + " - possibly due to inconsistent context");
    }

    public void setCodeUnitConflict(Address codeUnitAddr, Address newInstrAddr, Address flowFromAddr, boolean isInstruction, boolean isOffcut) {
        InstructionError.InstructionErrorType errorType = isInstruction ? (isOffcut ? InstructionError.InstructionErrorType.OFFCUT_INSTRUCTION : InstructionError.InstructionErrorType.INSTRUCTION_CONFLICT) : InstructionError.InstructionErrorType.DATA_CONFLICT;
        this.setInstructionError(errorType, newInstrAddr, codeUnitAddr, flowFromAddr, "Failed to disassemble at " + newInstrAddr + " due to conflicting " + (isInstruction ? "instruction" : "data") + " at " + codeUnitAddr);
    }

    public void setParseConflict(Address conflictAddress, RegisterValue contextValue, Address flowFromAddress, String message) {
        this.instructionError = new InstructionError(this, contextValue, conflictAddress, flowFromAddress, message);
    }

    public void clearConflict() {
        this.instructionError = null;
    }

    public InstructionError getInstructionConflict() {
        return this.instructionError;
    }

    @Override
    public Iterator<Instruction> iterator() {
        return this.instructionMap.values().iterator();
    }

    public Address getLastInstructionAddress() {
        return this.lastInstructionAddress;
    }

    public boolean isEmpty() {
        return this.instructionMap.isEmpty();
    }

    public int getInstructionCount() {
        return this.instructionMap.size();
    }

    public int getInstructionsAddedCount() {
        return this.instructionsAddedCount;
    }

    public void setInstructionsAddedCount(int count) {
        this.instructionsAddedCount = count;
    }

    public Address getFlowFromAddress() {
        return this.flowFrom;
    }

    public void setFlowFromAddress(Address flowFrom) {
        this.flowFrom = flowFrom;
    }

    public boolean hasInstructionError() {
        return this.instructionError != null;
    }
}

