/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class RenameGlobalVariableTask
extends RenameTask {
    private Address address;
    private Program program;
    private SymbolTable symboltable;
    private Symbol symbol;

    public RenameGlobalVariableTask(PluginTool tool, String old, Address addr, Program prog) {
        super(tool, old);
        this.address = addr;
        this.program = prog;
        this.symboltable = this.program.getSymbolTable();
        this.symbol = null;
    }

    @Override
    public void commit() throws DuplicateNameException, InvalidInputException {
        if (this.symbol != null) {
            this.symbol.setName(this.newName, SourceType.USER_DEFINED);
        } else {
            this.symboltable.createLabel(this.address, this.newName, SourceType.USER_DEFINED);
        }
    }

    @Override
    public String getTransactionName() {
        return "Rename Global Variable";
    }

    @Override
    public boolean isValid(String newNm) {
        this.newName = newNm;
        Symbol dupsym = this.symboltable.getGlobalSymbol(this.newName, this.address);
        if (dupsym != null) {
            this.errorMsg = "Duplicate symbol name";
            return false;
        }
        this.symbol = this.symboltable.getPrimarySymbol(this.address);
        return true;
    }
}

