/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

public final class Permission {
    public static final int NONE = 0;
    public static final int READ = 1;
    public static final int SET_PROPERTY = 2;
    public static final int ADD_NODE = 4;
    public static final int REMOVE_NODE = 8;
    public static final int REMOVE_PROPERTY = 16;
    public static final int ALL = 31;

    public static int calculatePermissions(int privs, int parentPrivs, boolean isAllow, boolean protectsPolicy) {
        int perm = 0;
        if (protectsPolicy) {
            if ((parentPrivs & 0x20) == 32) {
                perm |= 1;
            }
            if ((parentPrivs & 0x40) == 64) {
                perm |= 4;
                perm |= 2;
                perm |= 8;
                perm |= 0x10;
            }
        } else {
            if ((privs & 1) == 1) {
                perm |= 1;
            }
            if ((privs & 2) == 2) {
                perm |= 2;
                perm |= 0x10;
            }
            if ((parentPrivs & 4) == 4) {
                perm |= 4;
            }
            if (isAllow) {
                if ((parentPrivs & 8) == 8 && (privs & 0x10) == 16) {
                    perm |= 8;
                }
            } else if ((parentPrivs & 8) == 8 || (privs & 0x10) == 16) {
                perm |= 8;
            }
        }
        return perm;
    }

    public static int diff(int permissions, int otherPermissions) {
        return permissions & ~otherPermissions;
    }
}

