/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.BaseNonStreamValue;
import org.apache.jackrabbit.rmi.value.ISO8601;
import org.apache.jackrabbit.rmi.value.StatefulValue;

public class DateValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 7158448867450810873L;
    private final Calendar value;

    protected DateValue(Calendar value) {
        this.value = value;
    }

    protected DateValue(String value) throws ValueFormatException {
        this(ISO8601.parse(value));
    }

    public int getType() {
        return 5;
    }

    public double getDouble() {
        return this.value.getTimeInMillis();
    }

    public String getString() {
        return ISO8601.format(this.value);
    }

    public long getLong() {
        return this.value.getTimeInMillis();
    }

    public Calendar getDate() {
        return (Calendar)this.value.clone();
    }
}

