/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype.compact;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.util.ISO9075;

public class CompactNodeTypeDefWriter {
    private static final String INDENT = "  ";
    private final NamespaceResolver resolver;
    private final NamePathResolver npResolver;
    private final ValueFactory valueFactory;
    private Writer out;
    private Writer nsWriter;
    private final HashSet usedNamespaces = new HashSet();

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, NamePathResolver npResolver, ValueFactory valueFactory) {
        this(out, r, npResolver, valueFactory, false);
    }

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, NamePathResolver npResolver, ValueFactory valueFactory, boolean includeNS) {
        this.resolver = r;
        this.npResolver = npResolver;
        this.valueFactory = valueFactory;
        if (includeNS) {
            this.out = new StringWriter();
            this.nsWriter = out;
        } else {
            this.out = out;
            this.nsWriter = null;
        }
    }

    public static void write(List l, NamespaceResolver r, NamePathResolver npResolver, ValueFactory valueFactory, Writer out) throws IOException {
        CompactNodeTypeDefWriter w = new CompactNodeTypeDefWriter(out, r, npResolver, valueFactory, true);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            QNodeTypeDefinition def = (QNodeTypeDefinition)iter.next();
            w.write(def);
        }
        w.close();
    }

    public void write(QNodeTypeDefinition ntd) throws IOException {
        this.writeName(ntd);
        this.writeSupertypes(ntd);
        this.writeOptions(ntd);
        this.writePropDefs(ntd);
        this.writeNodeDefs(ntd);
        this.out.write("\n\n");
    }

    public void close() throws IOException {
        if (this.nsWriter != null) {
            this.nsWriter.write("\n");
            this.out.close();
            this.nsWriter.write(((StringWriter)this.out).getBuffer().toString());
            this.out = this.nsWriter;
            this.nsWriter = null;
        }
        this.out.flush();
        this.out = null;
    }

    private void writeName(QNodeTypeDefinition ntd) throws IOException {
        this.out.write("[");
        this.out.write(this.resolve(ntd.getName()));
        this.out.write("]");
    }

    private void writeSupertypes(QNodeTypeDefinition ntd) throws IOException {
        Name[] sta = ntd.getSupertypes();
        String delim = " > ";
        for (int i = 0; i < sta.length; ++i) {
            this.out.write(delim);
            this.out.write(this.resolve(sta[i]));
            delim = ", ";
        }
    }

    private void writeOptions(QNodeTypeDefinition ntd) throws IOException {
        if (ntd.hasOrderableChildNodes()) {
            this.out.write("\n  ");
            this.out.write("orderable");
            if (ntd.isMixin()) {
                this.out.write(" mixin");
            }
        } else if (ntd.isMixin()) {
            this.out.write("\n  ");
            this.out.write("mixin");
        }
    }

    private void writePropDefs(QNodeTypeDefinition ntd) throws IOException {
        QPropertyDefinition[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            QPropertyDefinition pd = pda[i];
            this.writePropDef(ntd, pd);
        }
    }

    private void writeNodeDefs(QNodeTypeDefinition ntd) throws IOException {
        QNodeDefinition[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            QNodeDefinition nd = nda[i];
            this.writeNodeDef(ntd, nd);
        }
    }

    private void writePropDef(QNodeTypeDefinition ntd, QPropertyDefinition pd) throws IOException {
        this.out.write("\n  - ");
        Name name = pd.getName();
        if (name.equals(NameConstants.ANY_NAME)) {
            this.out.write(42);
        } else {
            this.writeItemDefName(name);
        }
        this.out.write(" (");
        this.out.write(PropertyType.nameFromValue((int)pd.getRequiredType()).toLowerCase());
        this.out.write(")");
        this.writeDefaultValues(pd.getDefaultValues());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(pd.getName()) ? " primary" : "");
        if (pd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (pd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (pd.isProtected()) {
            this.out.write(" protected");
        }
        if (pd.isMultiple()) {
            this.out.write(" multiple");
        }
        if (pd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)pd.getOnParentVersion()).toLowerCase());
        }
        this.writeValueConstraints(pd.getValueConstraints(), pd.getRequiredType());
    }

    private void writeDefaultValues(QValue[] dva) throws IOException {
        if (dva != null && dva.length > 0) {
            String delim = " = '";
            for (int i = 0; i < dva.length; ++i) {
                this.out.write(delim);
                try {
                    Value v = ValueFormat.getJCRValue(dva[i], this.npResolver, this.valueFactory);
                    this.out.write(this.escape(v.getString()));
                }
                catch (RepositoryException e) {
                    this.out.write(this.escape(dva[i].toString()));
                }
                this.out.write("'");
                delim = ", '";
            }
        }
    }

    private void writeValueConstraints(String[] vca, int type) throws IOException {
        if (vca != null && vca.length > 0) {
            String vc = this.convertConstraint(vca[0], type);
            this.out.write(" < '");
            this.out.write(this.escape(vc));
            this.out.write("'");
            for (int i = 1; i < vca.length; ++i) {
                vc = this.convertConstraint(vca[i], type);
                this.out.write(", '");
                this.out.write(this.escape(vc));
                this.out.write("'");
            }
        }
    }

    private String convertConstraint(String vc, int type) {
        if (type == 9 || type == 7 || type == 8) {
            if (type == 9) {
                type = 7;
            }
            try {
                QValue qv = QValueFactoryImpl.getInstance().create(vc, type);
                vc = ValueFormat.getJCRValue(qv, this.npResolver, this.valueFactory).getString();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return vc;
    }

    private void writeNodeDef(QNodeTypeDefinition ntd, QNodeDefinition nd) throws IOException {
        this.out.write("\n  + ");
        Name name = nd.getName();
        if (name.equals(NameConstants.ANY_NAME)) {
            this.out.write(42);
        } else {
            this.writeItemDefName(name);
        }
        this.writeRequiredTypes(nd.getRequiredPrimaryTypes());
        this.writeDefaultType(nd.getDefaultPrimaryType());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(nd.getName()) ? " primary" : "");
        if (nd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (nd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (nd.isProtected()) {
            this.out.write(" protected");
        }
        if (nd.allowsSameNameSiblings()) {
            this.out.write(" multiple");
        }
        if (nd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)nd.getOnParentVersion()).toLowerCase());
        }
    }

    private void writeItemDefName(Name name) throws IOException {
        this.out.write(this.resolve(name));
    }

    private void writeRequiredTypes(Name[] reqTypes) throws IOException {
        if (reqTypes != null && reqTypes.length > 0) {
            String delim = " (";
            for (int i = 0; i < reqTypes.length; ++i) {
                this.out.write(delim);
                this.out.write(this.resolve(reqTypes[i]));
                delim = ", ";
            }
            this.out.write(")");
        }
    }

    private void writeDefaultType(Name defType) throws IOException {
        if (defType != null && !defType.getLocalName().equals("*")) {
            this.out.write(" = ");
            this.out.write(this.resolve(defType));
        }
    }

    private String resolve(Name name) throws IOException {
        if (name == null) {
            return "";
        }
        try {
            String prefix = this.resolver.getPrefix(name.getNamespaceURI());
            if (prefix != null && !prefix.equals("")) {
                if (this.nsWriter != null && !this.usedNamespaces.contains(prefix)) {
                    this.usedNamespaces.add(prefix);
                    this.nsWriter.write("<'");
                    this.nsWriter.write(prefix);
                    this.nsWriter.write("'='");
                    this.nsWriter.write(this.escape(name.getNamespaceURI()));
                    this.nsWriter.write("'>\n");
                }
                prefix = prefix + ":";
            }
            String encLocalName = ISO9075.encode(name.getLocalName());
            String resolvedName = prefix + encLocalName;
            if (resolvedName.indexOf(45) >= 0 || resolvedName.indexOf(43) >= 0) {
                return "'" + resolvedName + "'";
            }
            return resolvedName;
        }
        catch (NamespaceException e) {
            return name.toString();
        }
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
                continue;
            }
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++i;
        }
        return sb.toString();
    }
}

