/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.concurrent.GradleThread;

public class ThreadFactoryImpl
implements ThreadFactory {
    private final AtomicLong counter = new AtomicLong();
    private final String displayName;

    public ThreadFactoryImpl(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(new ManagedThreadRunnable(r));
        long count = this.counter.incrementAndGet();
        if (count == 1L) {
            thread.setName(this.displayName);
        } else {
            thread.setName(this.displayName + " Thread " + count);
        }
        return thread;
    }

    private static class ManagedThreadRunnable
    implements Runnable {
        private final Runnable delegate;

        private ManagedThreadRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            GradleThread.setManaged();
            this.delegate.run();
        }
    }
}

