/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferDeviceAddressInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFER;

    public VkBufferDeviceAddressInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferDeviceAddressInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferDeviceAddressInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferDeviceAddressInfo.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkBufferDeviceAddressInfo.nbuffer(this.address());
    }

    public VkBufferDeviceAddressInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBufferDeviceAddressInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressInfo pNext(@NativeType(value="void const *") long value) {
        VkBufferDeviceAddressInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferDeviceAddressInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferDeviceAddressInfo set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferDeviceAddressInfo set(VkBufferDeviceAddressInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferDeviceAddressInfo malloc() {
        return (VkBufferDeviceAddressInfo)VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferDeviceAddressInfo calloc() {
        return (VkBufferDeviceAddressInfo)VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferDeviceAddressInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferDeviceAddressInfo)VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferDeviceAddressInfo create(long address) {
        return (VkBufferDeviceAddressInfo)VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, (long)address);
    }

    @Nullable
    public static VkBufferDeviceAddressInfo createSafe(long address) {
        return address == 0L ? null : (VkBufferDeviceAddressInfo)VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferDeviceAddressInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferDeviceAddressInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferDeviceAddressInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferDeviceAddressInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferDeviceAddressInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBufferDeviceAddressInfo mallocStack() {
        return VkBufferDeviceAddressInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferDeviceAddressInfo callocStack() {
        return VkBufferDeviceAddressInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferDeviceAddressInfo mallocStack(MemoryStack stack) {
        return (VkBufferDeviceAddressInfo)VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferDeviceAddressInfo callocStack(MemoryStack stack) {
        return (VkBufferDeviceAddressInfo)VkBufferDeviceAddressInfo.wrap(VkBufferDeviceAddressInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferDeviceAddressInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferDeviceAddressInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nbuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nbuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFER, value);
    }

    static {
        Struct.Layout layout = VkBufferDeviceAddressInfo.__struct((Struct.Member[])new Struct.Member[]{VkBufferDeviceAddressInfo.__member((int)4), VkBufferDeviceAddressInfo.__member((int)POINTER_SIZE), VkBufferDeviceAddressInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBufferDeviceAddressInfo, Buffer>
    implements NativeResource {
        private static final VkBufferDeviceAddressInfo ELEMENT_FACTORY = VkBufferDeviceAddressInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBufferDeviceAddressInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferDeviceAddressInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferDeviceAddressInfo.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkBufferDeviceAddressInfo.nbuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferDeviceAddressInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferDeviceAddressInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferDeviceAddressInfo.nbuffer(this.address(), value);
            return this;
        }
    }
}

