
/* : : generated by proto : : */
/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*          Copyright (c) 1982-2012 AT&T Intellectual Property          *
*          Copyright (c) 2020-2021 Contributors to ksh 93u+m           *
*                      and is licensed under the                       *
*                 Eclipse Public License, Version 1.0                  *
*                    by AT&T Intellectual Property                     *
*                                                                      *
*                A copy of the License is available at                 *
*          http://www.eclipse.org/org/documents/epl-v10.html           *
*         (with md5 checksum b35adb5213ca9657e911e9befb180842)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                  David Korn <dgk@research.att.com>                   *
*                                                                      *
***********************************************************************/
                  
#ifndef NV_DEFAULT
#if !defined(__PROTO__)
#include <prototyped.h>
#endif
#if !defined(__LINKAGE__)
#define __LINKAGE__		/* 2004-08-11 transition */
#endif

/*
 * David Korn
 * AT&T Labs
 *
 * Interface definitions of structures for name-value pairs
 * These structures are used for named variables, functions and aliases
 *
 */


#include	<ast.h>
#include	<cdt.h>
#include	<option.h>
#include	<hash.h>

typedef struct Namval Namval_t;
typedef struct Namfun Namfun_t;
typedef struct Namdisc Namdisc_t;
typedef struct Nambfun Nambfun_t;
typedef struct Namarray Namarr_t;
typedef struct Namdecl Namdecl_t;

/*
 * This defines the template for nodes that have their own assignment
 * and or lookup functions
 */
struct Namdisc
{
	size_t	dsize;
	void	(*putval) __PROTO__((Namval_t*, const char*, int, Namfun_t*));
	char	*(*getval) __PROTO__((Namval_t*, Namfun_t*));
	Sfdouble_t	(*getnum) __PROTO__((Namval_t*, Namfun_t*));
	char	*(*setdisc) __PROTO__((Namval_t*, const char*, Namval_t*, Namfun_t*));
	Namval_t *(*createf) __PROTO__((Namval_t*, const char*, int, Namfun_t*));
	Namfun_t *(*clonef) __PROTO__((Namval_t*, Namval_t*, int, Namfun_t*));
	char	*(*namef) __PROTO__((Namval_t*, Namfun_t*));
	Namval_t *(*nextf) __PROTO__((Namval_t*, Dt_t*, Namfun_t*));
	Namval_t *(*typef) __PROTO__((Namval_t*, Namfun_t*));
	int	(*readf) __PROTO__((Namval_t*, Sfio_t*, int, Namfun_t*));
	int	(*writef) __PROTO__((Namval_t*, Sfio_t*, int, Namfun_t*));
};

struct Namfun
{
	const Namdisc_t	*disc;
	char		nofree;
	unsigned int	subshell;
	uint32_t	dsize;
	Namfun_t	*next;
	char		*last;
	Namval_t	*type;
};

struct Nambfun
{
	Namfun_t        fun;
	int		num;
	const char	**bnames;
	Namval_t	*bltins[1];
};

/* This is an array template header */
struct Namarray
{
	Namfun_t	hdr;
	long		nelem;				/* number of elements */
	__V_	*(*fun) __PROTO__((Namval_t*,const char*,int));	/* associative arrays */
	__V_		*fixed;			/* for fixed sized arrays */
	Dt_t		*table;			/* for subscripts */
	__V_		*scope;			/* non-zero when scoped */
};

/* The context pointer for declaration command */
struct Namdecl
{
	Namval_t	*tp;			/* point to type */
	const char	*optstring;
	__V_		*optinfof;
};

/* attributes of name-value node attribute flags */

#define NV_DEFAULT 0
/* This defines the attributes for an attributed name-value pair node */
struct Namval
{
	Dtlink_t	nvlink;		/* space for cdt links */
	char		*nvname;	/* pointer to name of the node */
#if _ast_sizeof_pointer == 8
#   if _ast_intswap > 0
	unsigned short	nvflag; 	/* attributes */
	unsigned short	pad1;
#   else
	unsigned short	pad1;
	unsigned short	nvflag; 	/* attributes */
#   endif
	uint32_t  	nvsize;		/* size or base */
#else
	unsigned short	nvflag; 	/* attributes */
	unsigned short 	nvsize;		/* size or base */
#endif
#ifdef _NV_PRIVATE
	_NV_PRIVATE
#else
	Namfun_t	*nvfun;
	char		*nvalue;
	char		*nvprivate;
#endif /* _NV_PRIVATE */
};

#define NV_CLASS	".sh.type"
#define NV_DATA		"_"	/* special class or instance variable */
#define NV_MINSZ	(sizeof(struct Namval)-sizeof(Dtlink_t)-sizeof(char*))
#define nv_namptr(p,n)	((Namval_t*)((char*)(p)+(n)*NV_MINSZ-sizeof(Dtlink_t)))

/* The following attributes are for internal use */
#define NV_NOFREE	0x200	/* don't free the space when releasing value */
#define NV_ARRAY	0x400	/* node is an array */
#define NV_REF		0x4000	/* reference bit */
#define NV_TABLE	0x800	/* node is a dictionary table */
#define NV_IMPORT	0x1000	/* value imported from environment */
#define NV_MINIMAL	NV_IMPORT	/* node does not contain all fields */

#define NV_INTEGER	0x2	/* integer attribute */
/* The following attributes are valid only when NV_INTEGER is off */
#define NV_LTOU		0x4	/* convert to uppercase */
#define NV_UTOL		0x8	/* convert to lowercase */
#define NV_ZFILL	0x10	/* right justify and fill with leading zeros */
#define NV_RJUST	0x20	/* right justify and blank fill */
#define NV_LJUST	0x40	/* left justify and blank fill */
#define NV_BINARY	0x100	/* fixed size data buffer */
#define NV_RAW		NV_LJUST	/* used only with NV_BINARY */
#define NV_HOST		(NV_RJUST|NV_LJUST)	/* map to host filename */

/* The following attributes do not effect the value */
#define NV_RDONLY	0x1	/* readonly bit */
#define NV_EXPORT	0x2000	/* export bit */
#define NV_TAGGED	0x8000	/* user define tag bit */

/* The following are used with NV_INTEGER */
#define NV_SHORT	(NV_RJUST)	/* when integers are not long */
#define NV_LONG		(NV_UTOL)	/* for long long and long double */
#define NV_UNSIGN	(NV_LTOU)	/* for unsigned quantities */
#define NV_DOUBLE	(NV_INTEGER|NV_ZFILL)	/* for floating point */
#define NV_EXPNOTE	(NV_LJUST)	/* for scientific notation */
#define NV_HEXFLOAT	(NV_LTOU)	/* for C99 base16 float notation */
#define NV_FLTSIZEZERO	-1		/* a float with size of 0 being <0 */

/* options for nv_open */

#define NV_APPEND	0x10000		/* append value */
#define NV_MOVE		0x8000000	/* for use with nv_clone */
#define NV_ADD		8
					/* add node if not found */
#define NV_ASSIGN	NV_NOFREE	/* assignment is possible */
#define NV_NOASSIGN	0		/* backward compatibility */
#define NV_NOARRAY	0x200000	/* array name not possible */
#define NV_IARRAY	0x400000	/* for indexed array */
#define NV_NOREF	NV_REF		/* don't follow reference */
#define NV_IDENT	0x80		/* name must be identifier */
#define NV_VARNAME	0x20000		/* name must be ?(.)id*(.id) */
#define NV_NOADD	0x40000		/* do not add node */ 	
#define NV_NOSCOPE	0x80000		/* look only in current scope */
#define NV_NOFAIL	0x100000	/* return 0 on failure, no msg */
#define NV_NODISC	NV_IDENT	/* ignore disciplines */

#define NV_FUNCT	NV_IDENT	/* option for nv_create */
#define NV_BLTINOPT	NV_ZFILL	/* mark builtins in libcmd */

#define NV_PUBLIC	(~(NV_NOSCOPE|NV_ASSIGN|NV_IDENT|NV_VARNAME|NV_NOADD))

/* numeric types */
#define NV_INT16P	(NV_LJUST|NV_SHORT|NV_INTEGER)
#define NV_INT16	(NV_SHORT|NV_INTEGER)
#define NV_UINT16	(NV_UNSIGN|NV_SHORT|NV_INTEGER)
#define NV_UINT16P	(NV_LJUSTNV_UNSIGN|NV_SHORT|NV_INTEGER)
#define NV_INT32	(NV_INTEGER)
#define NV_UNT32	(NV_UNSIGN|NV_INTEGER)
#define NV_INT64	(NV_LONG|NV_INTEGER)
#define NV_UINT64	(NV_UNSIGN|NV_LONG|NV_INTEGER)
#define NV_FLOAT	(NV_SHORT|NV_DOUBLE)
#define NV_LDOUBLE	(NV_LONG|NV_DOUBLE)

/* name-value pair macros */
#define nv_isattr(np,f)		((np)->nvflag & (f))
#define nv_onattr(n,f)		((n)->nvflag |= (f))
#define nv_offattr(n,f)		((n)->nvflag &= ~(f))
#define nv_isarray(np)		(nv_isattr((np),NV_ARRAY))

/* The following are operations for associative arrays */
#define NV_AINIT	1	/* initialize */
#define NV_AFREE	2	/* free array */
#define NV_ANEXT	3	/* advance to next subscript */
#define NV_ANAME	4	/* return subscript name */
#define NV_ADELETE	5	/* delete current subscript */
#define NV_AADD		6	/* add subscript if not found */
#define NV_ACURRENT	7	/* return current subscript Namval_t* */
#define NV_ASETSUB	8	/* set current subscript */

/* The following are for nv_disc */
#define NV_FIRST	1
#define NV_LAST		2
#define NV_POP		3
#define NV_CLONE	4

/* The following are operations for nv_putsub() */
#define ARRAY_BITS	22
#define ARRAY_ADD	(1L<<ARRAY_BITS)	/* add subscript if not found */
#define	ARRAY_SCAN	(2L<<ARRAY_BITS)	/* For ${array[@]} */
#define ARRAY_UNDEF	(4L<<ARRAY_BITS)	/* For ${array} */


/* These are disciplines provided by the library for use with nv_discfun */
#define NV_DCADD	0	/* used to add named disciplines */
#define NV_DCRESTRICT	1	/* variable that are restricted in rsh */

#if defined(__EXPORT__) && defined(_DLL)
#undef __MANGLE__
#define __MANGLE__ __LINKAGE__ __EXPORT__
#endif /* _DLL */
/* prototype for array interface */
extern __MANGLE__ Namarr_t	*nv_arrayptr __PROTO__((Namval_t*));
extern __MANGLE__ Namarr_t	*nv_setarray __PROTO__((Namval_t*,__V_*(*)(Namval_t*,const char*,int)));
extern __MANGLE__ int	nv_arraynsub __PROTO__((Namarr_t*));
extern __MANGLE__ __V_	*nv_associative __PROTO__((Namval_t*,const char*,int));
extern __MANGLE__ int	nv_aindex __PROTO__((Namval_t*));
extern __MANGLE__ int	nv_nextsub __PROTO__((Namval_t*));
extern __MANGLE__ char	*nv_getsub __PROTO__((Namval_t*));
extern __MANGLE__ Namval_t	*nv_putsub __PROTO__((Namval_t*, char*, long));
extern __MANGLE__ Namval_t	*nv_opensub __PROTO__((Namval_t*));

/* name-value pair function prototypes */
extern __MANGLE__ int		nv_adddisc __PROTO__((Namval_t*, const char**, Namval_t**));
extern __MANGLE__ int		nv_clone __PROTO__((Namval_t*, Namval_t*, int));
extern __MANGLE__ void 		nv_close __PROTO__((Namval_t*));
extern __MANGLE__ __V_		*nv_context __PROTO__((Namval_t*));
extern __MANGLE__ Namval_t		*nv_create __PROTO__((const char*, Dt_t*, int,Namfun_t*));
extern __MANGLE__ void		nv_delete __PROTO__((Namval_t*, Dt_t*, int));
extern __MANGLE__ Dt_t		*nv_dict __PROTO__((Namval_t*));
extern __MANGLE__ Sfdouble_t	nv_getn __PROTO__((Namval_t*, Namfun_t*));
extern __MANGLE__ Sfdouble_t	nv_getnum __PROTO__((Namval_t*));
extern __MANGLE__ char 		*nv_getv __PROTO__((Namval_t*, Namfun_t*));
extern __MANGLE__ char 		*nv_getval __PROTO__((Namval_t*));
extern __MANGLE__ Namfun_t		*nv_hasdisc __PROTO__((Namval_t*, const Namdisc_t*));
extern __MANGLE__ int		nv_isnull __PROTO__((Namval_t*));
extern __MANGLE__ Namfun_t		*nv_isvtree __PROTO__((Namval_t*));
extern __MANGLE__ Namval_t		*nv_lastdict __PROTO__((void));
extern __MANGLE__ Namval_t		*nv_mkinttype __PROTO__((char*, size_t, int, const char*, Namdisc_t*));
extern __MANGLE__ void 		nv_newattr __PROTO__((Namval_t*,unsigned,int));
extern __MANGLE__ void 		nv_newtype __PROTO__((Namval_t*));
extern __MANGLE__ Namval_t		*nv_open __PROTO__((const char*,Dt_t*,int));
extern __MANGLE__ void 		nv_putval __PROTO__((Namval_t*,const char*,int));
extern __MANGLE__ void 		nv_putv __PROTO__((Namval_t*,const char*,int,Namfun_t*));
extern __MANGLE__ int		nv_rename __PROTO__((Namval_t*,int));
extern __MANGLE__ void		nv_rehash __PROTO__((Namval_t*,__V_*));
extern __MANGLE__ int		nv_scan __PROTO__((Dt_t*,void(*)(Namval_t*,__V_*),__V_*,int,int));
extern __MANGLE__ char 		*nv_setdisc __PROTO__((Namval_t*,const char*,Namval_t*,Namfun_t*));
extern __MANGLE__ void		nv_setref __PROTO__((Namval_t*, Dt_t*,int));
extern __MANGLE__ int		nv_settype __PROTO__((Namval_t*, Namval_t*, int));
extern __MANGLE__ void 		nv_setvec __PROTO__((Namval_t*,int,int,char*[]));
extern __MANGLE__ void		nv_setvtree __PROTO__((Namval_t*));
extern __MANGLE__ int 		nv_setsize __PROTO__((Namval_t*,int));
extern __MANGLE__ Namfun_t		*nv_disc __PROTO__((Namval_t*,Namfun_t*,int));
extern __MANGLE__ void 		nv_unset __PROTO__((Namval_t*));	 /* obsolete */
extern __MANGLE__ void 		_nv_unset __PROTO__((Namval_t*,int));
extern __MANGLE__ Namval_t		*nv_search __PROTO__((const char *, Dt_t*, int));
extern __MANGLE__ char		*nv_name __PROTO__((Namval_t*));
extern __MANGLE__ Namval_t		*nv_type __PROTO__((Namval_t*));
extern __MANGLE__ void		nv_addtype __PROTO__((Namval_t*,const char*, Optdisc_t*, size_t));
extern __MANGLE__ const Namdisc_t	*nv_discfun __PROTO__((int));

#ifdef _DLL
#undef __MANGLE__
#define __MANGLE__ __LINKAGE__
#endif /* _DLL */

#define nv_unset(np)		_nv_unset(np,0)
#define nv_size(np)		nv_setsize((np),-1)
#define nv_stack(np,nf)		nv_disc(np,nf,0)

#endif /* NV_DEFAULT */
