/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ping.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryPing
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String hostname;
    private String timeout;
    public String defaultTimeOut = "3000";
    private String nbrPackets;
    private String Windows_CHAR = "-n";
    private String NIX_CHAR = "-c";
    public String classicPing = "classicPing";
    public int iclassicPing = 0;
    public String systemPing = "systemPing";
    public int isystemPing = 1;
    public String bothPings = "bothPings";
    public int ibothPings = 2;
    public String pingtype;
    public int ipingtype;

    public JobEntryPing(String n) {
        super(n, "");
        this.pingtype = this.classicPing;
        this.hostname = null;
        this.nbrPackets = "2";
        this.timeout = this.defaultTimeOut;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.PING);
    }

    public JobEntryPing() {
        this("");
    }

    public JobEntryPing(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryPing je = (JobEntryPing)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nbr_packets", (String)this.nbrPackets));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nbrpaquets", (String)this.nbrPackets));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"pingtype", (String)this.pingtype));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.hostname = XMLHandler.getTagValue((Node)entrynode, (String)"hostname");
            this.nbrPackets = XMLHandler.getTagValue((Node)entrynode, (String)"nbr_packets");
            String nbrPaquets = XMLHandler.getTagValue((Node)entrynode, (String)"nbrpaquets");
            if (this.nbrPackets == null && nbrPaquets != null) {
                this.nbrPackets = nbrPaquets;
            }
            this.timeout = XMLHandler.getTagValue((Node)entrynode, (String)"timeout");
            this.pingtype = XMLHandler.getTagValue((Node)entrynode, (String)"pingtype");
            if (Const.isEmpty((String)this.pingtype)) {
                this.pingtype = this.classicPing;
                this.ipingtype = this.iclassicPing;
            } else {
                this.ipingtype = this.pingtype.equals(this.systemPing) ? this.isystemPing : (this.pingtype.equals(this.bothPings) ? this.ibothPings : this.iclassicPing);
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'ping' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.hostname = rep.getJobEntryAttributeString(id_jobentry, "hostname");
            this.nbrPackets = rep.getJobEntryAttributeString(id_jobentry, "nbr_packets");
            String nbrPaquets = rep.getJobEntryAttributeString(id_jobentry, "nbrpaquets");
            if (this.nbrPackets == null && nbrPaquets != null) {
                this.nbrPackets = nbrPaquets;
            }
            this.timeout = rep.getJobEntryAttributeString(id_jobentry, "timeout");
            this.pingtype = rep.getJobEntryAttributeString(id_jobentry, "pingtype");
            if (Const.isEmpty((String)this.pingtype)) {
                this.pingtype = this.classicPing;
                this.ipingtype = this.iclassicPing;
            } else {
                this.ipingtype = this.pingtype.equals(this.systemPing) ? this.isystemPing : (this.pingtype.equals(this.bothPings) ? this.ibothPings : this.iclassicPing);
            }
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'ping' exists from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "hostname", this.hostname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nbr_packets", this.nbrPackets);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nbrpaquets", this.nbrPackets);
            rep.saveJobEntryAttribute(id_job, this.getID(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "pingtype", this.pingtype);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ping' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getNbrPackets() {
        return this.nbrPackets;
    }

    public String getRealNbrPackets() {
        return this.environmentSubstitute(this.getNbrPackets());
    }

    public void setNbrPackets(String nbrPackets) {
        this.nbrPackets = nbrPackets;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRealHostname() {
        return this.environmentSubstitute(this.getHostname());
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public String getRealTimeOut() {
        return this.environmentSubstitute(this.getTimeOut());
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String hostname = this.getRealHostname();
        int timeoutInt = Const.toInt((String)this.getRealTimeOut(), (int)300);
        int packets = Const.toInt((String)this.getRealNbrPackets(), (int)2);
        boolean status = false;
        if (Const.isEmpty((String)hostname)) {
            log.logError(this.toString(), Messages.getString("JobPing.SpecifyHost.Label"), new Object[0]);
            return result;
        }
        try {
            if (this.ipingtype == this.isystemPing || this.ipingtype == this.ibothPings) {
                status = this.systemPing(hostname, timeoutInt, log);
                if (status) {
                    if (log.isDetailed()) {
                        log.logDetailed(Messages.getString("JobPing.SystemPing"), Messages.getString("JobPing.OK.Label", hostname), new Object[0]);
                    }
                } else {
                    log.logError(Messages.getString("JobPing.SystemPing"), Messages.getString("JobPing.NOK.Label", hostname), new Object[0]);
                }
            }
            if (this.ipingtype == this.iclassicPing || this.ipingtype == this.ibothPings && !status) {
                status = this.classicPing(hostname, packets, log);
                if (status) {
                    if (log.isDetailed()) {
                        log.logDetailed(Messages.getString("JobPing.ClassicPing"), Messages.getString("JobPing.OK.Label", hostname), new Object[0]);
                    }
                } else {
                    log.logError(Messages.getString("JobPing.ClassicPing"), Messages.getString("JobPing.NOK.Label", hostname), new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            log.logError(this.toString(), Messages.getString("JobPing.Error.Label") + ex.getMessage(), new Object[0]);
        }
        if (status) {
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobPing.OK.Label", hostname), new Object[0]);
            }
            result.setNrErrors(0L);
            result.setResult(true);
        } else {
            log.logError(this.toString(), Messages.getString("JobPing.NOK.Label", hostname), new Object[0]);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    private boolean systemPing(String hostname, int timeout, LogWriter log) {
        boolean retval = false;
        InetAddress address = null;
        try {
            address = InetAddress.getByName(hostname);
            if (address == null) {
                log.logError(this.toString(), Messages.getString("JobPing.CanNotGetAddress", hostname), new Object[0]);
                return retval;
            }
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobPing.HostName", address.getHostName()), new Object[0]);
                log.logDetailed(this.toString(), Messages.getString("JobPing.HostAddress", address.getHostAddress()), new Object[0]);
            }
            retval = address.isReachable(timeout);
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("JobPing.ErrorSystemPing", hostname, e.getMessage()), new Object[0]);
        }
        return retval;
    }

    private boolean classicPing(String hostname, int nrpackets, LogWriter log) {
        boolean retval = false;
        try {
            String lignePing = "";
            String CmdPing = "ping ";
            CmdPing = Const.isWindows() ? CmdPing + hostname + " " + this.Windows_CHAR + " " + nrpackets : CmdPing + hostname + " " + this.NIX_CHAR + " " + nrpackets;
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobPing.NbrPackets.Label", "" + nrpackets), new Object[0]);
                log.logDetailed(this.toString(), Messages.getString("JobPing.ExecClassicPing.Label", CmdPing), new Object[0]);
            }
            Process processPing = Runtime.getRuntime().exec(CmdPing);
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobPing.Gettingresponse.Label", hostname), new Object[0]);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(processPing.getInputStream()));
            while ((lignePing = br.readLine()) != null) {
                if (!log.isDetailed()) continue;
                log.logDetailed(this.toString(), lignePing, new Object[0]);
            }
            if (processPing.exitValue() == 0) {
                retval = true;
            }
        }
        catch (IOException ex) {
            log.logError(this.toString(), Messages.getString("JobPing.Error.Label") + ex.getMessage(), new Object[0]);
        }
        return retval;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.hostname)) {
            String realServername = jobMeta.environmentSubstitute(this.hostname);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "hostname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

