/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.swiftpm.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.provider.Provider;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.language.ComponentWithTargetMachines;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.nativeplatform.Linkage;
import org.gradle.swiftpm.Package;
import org.gradle.swiftpm.internal.AbstractProduct;
import org.gradle.swiftpm.internal.BranchDependency;
import org.gradle.swiftpm.internal.DefaultExecutableProduct;
import org.gradle.swiftpm.internal.DefaultLibraryProduct;
import org.gradle.swiftpm.internal.DefaultPackage;
import org.gradle.swiftpm.internal.DefaultTarget;
import org.gradle.swiftpm.internal.SwiftPmTarget;
import org.gradle.swiftpm.internal.VersionDependency;
import org.gradle.swiftpm.tasks.GenerateSwiftPackageManagerManifest;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.internal.VcsResolver;

public class SwiftPackageManagerExportPlugin
implements Plugin<Project> {
    private final VcsResolver vcsResolver;
    private final VersionSelectorScheme versionSelectorScheme;
    private final ProjectDependencyPublicationResolver publicationResolver;
    private final VersionParser versionParser;

    @Inject
    public SwiftPackageManagerExportPlugin(VcsResolver vcsResolver, VersionSelectorScheme versionSelectorScheme, ProjectDependencyPublicationResolver publicationResolver, VersionParser versionParser) {
        this.vcsResolver = vcsResolver;
        this.versionSelectorScheme = versionSelectorScheme;
        this.publicationResolver = publicationResolver;
        this.versionParser = versionParser;
    }

    public void apply(Project project) {
        final GenerateSwiftPackageManagerManifest manifestTask = (GenerateSwiftPackageManagerManifest)project.getTasks().create("generateSwiftPmManifest", GenerateSwiftPackageManagerManifest.class);
        manifestTask.getManifestFile().set((Object)project.getLayout().getProjectDirectory().file("Package.swift"));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Provider products = project.getProviders().provider((Callable)new MemoizingCallable(new PackageFactory(project)));
                manifestTask.getPackage().set(products);
            }
        });
    }

    private class PackageFactory
    implements Callable<Package> {
        private final Project project;

        PackageFactory(Project project) {
            this.project = project;
        }

        @Override
        public Package call() {
            LinkedHashSet<AbstractProduct> products = new LinkedHashSet<AbstractProduct>();
            ArrayList<DefaultTarget> targets = new ArrayList<DefaultTarget>();
            ArrayList<org.gradle.swiftpm.internal.Dependency> dependencies = new ArrayList<org.gradle.swiftpm.internal.Dependency>();
            SwiftVersion swiftLanguageVersion = null;
            for (Project p : this.project.getAllprojects()) {
                DefaultExecutableProduct product;
                DefaultTarget target;
                for (ComponentWithTargetMachines application : p.getComponents().withType(CppApplication.class)) {
                    target = new DefaultTarget((String)application.getBaseName().get(), p.getProjectDir(), (Iterable<File>)application.getCppSource());
                    this.collectDependencies(application.getImplementationDependencies(), dependencies, target);
                    product = new DefaultExecutableProduct(p.getName(), target);
                    products.add(product);
                    targets.add(target);
                }
                for (ComponentWithTargetMachines library : p.getComponents().withType(CppLibrary.class)) {
                    target = new DefaultTarget((String)library.getBaseName().get(), p.getProjectDir(), (Iterable<File>)library.getCppSource());
                    this.collectDependencies(library.getImplementationDependencies(), dependencies, target);
                    Set headerDirs = library.getPublicHeaderDirs().getFiles();
                    if (!headerDirs.isEmpty()) {
                        target.setPublicHeaderDir((File)headerDirs.iterator().next());
                    }
                    targets.add(target);
                    if (((Set)library.getLinkage().get()).contains(Linkage.SHARED)) {
                        products.add(new DefaultLibraryProduct(p.getName(), target, Linkage.SHARED));
                    }
                    if (!((Set)library.getLinkage().get()).contains(Linkage.STATIC)) continue;
                    products.add(new DefaultLibraryProduct(p.getName() + "Static", target, Linkage.STATIC));
                }
                for (ComponentWithTargetMachines application : p.getComponents().withType(SwiftApplication.class)) {
                    target = new DefaultTarget((String)application.getModule().get(), p.getProjectDir(), (Iterable<File>)application.getSwiftSource());
                    swiftLanguageVersion = this.max(swiftLanguageVersion, (SwiftVersion)application.getSourceCompatibility().getOrNull());
                    this.collectDependencies(application.getImplementationDependencies(), dependencies, target);
                    product = new DefaultExecutableProduct(p.getName(), target);
                    products.add(product);
                    targets.add(target);
                }
                for (ComponentWithTargetMachines library : p.getComponents().withType(SwiftLibrary.class)) {
                    target = new DefaultTarget((String)library.getModule().get(), p.getProjectDir(), (Iterable<File>)library.getSwiftSource());
                    swiftLanguageVersion = this.max(swiftLanguageVersion, (SwiftVersion)library.getSourceCompatibility().getOrNull());
                    this.collectDependencies(library.getImplementationDependencies(), dependencies, target);
                    targets.add(target);
                    if (((Set)library.getLinkage().get()).contains(Linkage.SHARED)) {
                        products.add(new DefaultLibraryProduct(p.getName(), target, Linkage.SHARED));
                    }
                    if (!((Set)library.getLinkage().get()).contains(Linkage.STATIC)) continue;
                    products.add(new DefaultLibraryProduct(p.getName() + "Static", target, Linkage.STATIC));
                }
            }
            return new DefaultPackage(products, targets, dependencies, swiftLanguageVersion);
        }

        private SwiftVersion max(SwiftVersion v1, SwiftVersion v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            if (v1.compareTo((Enum)v2) > 0) {
                return v1;
            }
            return v2;
        }

        private void collectDependencies(Configuration configuration, Collection<org.gradle.swiftpm.internal.Dependency> dependencies, DefaultTarget target) {
            for (Dependency dependency : configuration.getAllDependencies()) {
                if (dependency instanceof ProjectDependency) {
                    ProjectDependency projectDependency = (ProjectDependency)dependency;
                    SwiftPmTarget identifier = (SwiftPmTarget)SwiftPackageManagerExportPlugin.this.publicationResolver.resolve(SwiftPmTarget.class, projectDependency);
                    target.getRequiredTargets().add(identifier.getTargetName());
                    continue;
                }
                if (dependency instanceof ExternalModuleDependency) {
                    ExternalModuleDependency externalDependency = (ExternalModuleDependency)dependency;
                    ModuleComponentSelector depSelector = DefaultModuleComponentSelector.newSelector((ModuleVersionSelector)externalDependency);
                    VersionControlSpec vcsSpec = SwiftPackageManagerExportPlugin.this.vcsResolver.locateVcsFor(depSelector);
                    if (vcsSpec == null || !(vcsSpec instanceof GitVersionControlSpec)) {
                        throw new InvalidUserDataException(String.format("Cannot determine the Git URL for dependency on %s:%s.", dependency.getGroup(), dependency.getName()));
                    }
                    GitVersionControlSpec gitSpec = (GitVersionControlSpec)vcsSpec;
                    dependencies.add(this.toSwiftPmDependency(externalDependency, gitSpec));
                    target.getRequiredProducts().add(externalDependency.getName());
                    continue;
                }
                throw new InvalidUserDataException(String.format("Cannot map a dependency of type %s (%s)", dependency.getClass().getSimpleName(), dependency));
            }
        }

        private org.gradle.swiftpm.internal.Dependency toSwiftPmDependency(ExternalModuleDependency externalDependency, GitVersionControlSpec gitSpec) {
            if (externalDependency.getVersionConstraint().getBranch() != null) {
                if (externalDependency.getVersion() != null) {
                    throw new InvalidUserDataException(String.format("Cannot map a dependency on %s:%s that defines both a branch (%s) and a version constraint (%s).", externalDependency.getGroup(), externalDependency.getName(), externalDependency.getVersionConstraint().getBranch(), externalDependency.getVersion()));
                }
                return new BranchDependency(gitSpec.getUrl(), externalDependency.getVersionConstraint().getBranch());
            }
            String versionSelectorString = externalDependency.getVersion();
            VersionSelector versionSelector = SwiftPackageManagerExportPlugin.this.versionSelectorScheme.parseSelector(versionSelectorString);
            if (versionSelector instanceof LatestVersionSelector) {
                LatestVersionSelector latestVersionSelector = (LatestVersionSelector)versionSelector;
                if (latestVersionSelector.getSelectorStatus().equals("integration")) {
                    return new BranchDependency(gitSpec.getUrl(), "master");
                }
            } else {
                SubVersionSelector subVersionSelector;
                String prefix;
                if (versionSelector instanceof ExactVersionSelector) {
                    return new VersionDependency(gitSpec.getUrl(), versionSelector.getSelector());
                }
                if (versionSelector instanceof VersionRangeSelector) {
                    VersionRangeSelector versionRangeSelector = (VersionRangeSelector)versionSelector;
                    if (versionRangeSelector.isLowerInclusive()) {
                        return new VersionDependency(gitSpec.getUrl(), versionRangeSelector.getLowerBound(), versionRangeSelector.getUpperBound(), versionRangeSelector.isUpperInclusive());
                    }
                } else if (versionSelector instanceof SubVersionSelector && (prefix = (subVersionSelector = (SubVersionSelector)versionSelector).getPrefix()).endsWith(".")) {
                    String versionString = prefix.substring(0, prefix.length() - 1);
                    Version version = SwiftPackageManagerExportPlugin.this.versionParser.transform(versionString);
                    if (version.getNumericParts().length == 1) {
                        Long part1 = version.getNumericParts()[0];
                        return new VersionDependency(gitSpec.getUrl(), part1 + ".0.0");
                    }
                    if (version.getNumericParts().length == 2) {
                        Long part1 = version.getNumericParts()[0];
                        Long part2 = version.getNumericParts()[1];
                        return new VersionDependency(gitSpec.getUrl(), part1 + "." + part2 + ".0", part1 + "." + (part2 + 1L) + ".0", false);
                    }
                }
            }
            throw new InvalidUserDataException(String.format("Cannot map a dependency on %s:%s with version constraint (%s).", externalDependency.getGroup(), externalDependency.getName(), externalDependency.getVersion()));
        }
    }

    private static class MemoizingCallable
    implements Callable<Package> {
        private Package result;
        private Callable<Package> delegate;

        MemoizingCallable(Callable<Package> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Package call() throws Exception {
            if (this.result == null) {
                this.result = this.delegate.call();
                this.delegate = null;
            }
            return this.result;
        }
    }
}

