/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.ReadLine;
import net.i2p.sam.SAMBridge;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMDatagramSession;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMInvalidDirectionException;
import net.i2p.sam.SAMMessageSess;
import net.i2p.sam.SAMRawReceiver;
import net.i2p.sam.SAMRawSession;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.sam.SAMStreamSession;
import net.i2p.sam.SAMUtils;

class SAMv1Handler
extends SAMHandler
implements SAMRawReceiver,
SAMDatagramReceiver,
SAMStreamReceiver {
    protected SAMMessageSess rawSession;
    protected SAMMessageSess datagramSession;
    protected SAMStreamSession streamSession;
    protected final long _id = __id.incrementAndGet();
    private static final AtomicLong __id = new AtomicLong();
    private static final int FIRST_READ_TIMEOUT = 60000;
    protected static final String SESSION_ERROR = "SESSION STATUS RESULT=I2P_ERROR";

    protected final SAMMessageSess getRawSession() {
        return this.rawSession;
    }

    protected final SAMMessageSess getDatagramSession() {
        return this.datagramSession;
    }

    protected final SAMStreamSession getStreamSession() {
        return this.streamSession;
    }

    public SAMv1Handler(SocketChannel s, int verMajor, int verMinor, SAMBridge parent) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties(), parent);
    }

    public SAMv1Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps, SAMBridge parent) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps, parent);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM version 1 handler instantiated");
        }
        if (!this.verifVersion()) {
            throw new SAMException("BUG! Wrong protocol version!");
        }
    }

    public boolean verifVersion() {
        return this.verMajor == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        String msg = null;
        String domain = null;
        String opcode = null;
        boolean canContinue = false;
        StringBuilder buf = new StringBuilder(128);
        this.thread.setName("SAMv1Handler " + this._id);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM handling started");
        }
        try {
            boolean gotFirstLine = false;
            while (true) {
                Properties props;
                if (this.shouldStop()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Stop request found");
                    }
                    break;
                }
                SocketChannel clientSocketChannel = this.getClientSocket();
                if (clientSocketChannel == null) {
                    this._log.info("Connection closed by client");
                    break;
                }
                if (clientSocketChannel.socket() == null) {
                    this._log.info("Connection closed by client");
                    break;
                }
                buf.setLength(0);
                try {
                    Socket sock = clientSocketChannel.socket();
                    ReadLine.readLine(sock, buf, gotFirstLine ? 0 : 60000);
                    sock.setSoTimeout(0);
                }
                catch (SocketTimeoutException ste) {
                    this.writeString(SESSION_ERROR, "command timeout, bye");
                    break;
                }
                msg = buf.toString();
                if (this._log.shouldLog(10)) {
                    this._log.debug("New message received: [" + msg + ']');
                }
                if ((domain = (String)(props = SAMUtils.parseParams(msg)).remove("\"\"COMMAND\"\"")) == null) {
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Ignoring newline");
                    continue;
                }
                opcode = (String)props.remove("\"\"OPCODE\"\"");
                if (opcode == null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Error in message format");
                    }
                    break;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                }
                gotFirstLine = true;
                if (domain.equals("STREAM")) {
                    canContinue = this.execStreamMessage(opcode, props);
                } else if (domain.equals("DATAGRAM")) {
                    canContinue = this.execDatagramMessage(opcode, props);
                } else if (domain.equals("RAW")) {
                    canContinue = this.execRawMessage(opcode, props);
                } else if (domain.equals("SESSION")) {
                    if (this.i2cpProps != null) {
                        props.putAll((Map<?, ?>)this.i2cpProps);
                    }
                    canContinue = this.execSessionMessage(opcode, props);
                } else if (domain.equals("DEST")) {
                    canContinue = this.execDestMessage(opcode, props);
                } else {
                    if (!domain.equals("NAMING")) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Unrecognized message domain: \"" + domain + "\"");
                        }
                        break;
                    }
                    canContinue = this.execNamingMessage(opcode, props);
                }
                if (!canContinue) break;
            }
        }
        catch (IOException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Caught IOException for message [" + msg + "]", e);
            }
        }
        catch (SAMException e) {
            this._log.error("Unexpected exception for message [" + msg + "]", e);
        }
        catch (RuntimeException e) {
            this._log.error("Unexpected exception for message [" + msg + "]", e);
        }
        finally {
            block51: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Stopping handler");
                }
                try {
                    this.closeClientSocket();
                }
                catch (IOException e) {
                    if (!this._log.shouldWarn()) break block51;
                    this._log.warn("Error closing socket", e);
                }
            }
            if (this.rawSession != null) {
                this.rawSession.close();
            }
            if (this.datagramSession != null) {
                this.datagramSession.close();
            }
            if (this.streamSession != null) {
                this.streamSession.close();
            }
        }
    }

    protected boolean execSessionMessage(String opcode, Properties props) {
        String dest = "BUG!";
        try {
            if (opcode.equals("CREATE")) {
                if (this.rawSession != null || this.datagramSession != null || this.streamSession != null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Trying to create a session, but one still exists");
                    }
                    return this.writeString(SESSION_ERROR, "Session already exists");
                }
                if (props.isEmpty()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("No parameters specified in SESSION CREATE message");
                    }
                    return this.writeString(SESSION_ERROR, "No parameters for SESSION CREATE");
                }
                dest = (String)props.remove("DESTINATION");
                if (dest == null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("SESSION DESTINATION parameter not specified");
                    }
                    return this.writeString(SESSION_ERROR, "DESTINATION not specified");
                }
                String destKeystream = null;
                if (dest.equals("TRANSIENT")) {
                    this._log.debug("TRANSIENT destination requested");
                    ByteArrayOutputStream priv = new ByteArrayOutputStream(640);
                    SAMUtils.genRandomKey(priv, null);
                    destKeystream = Base64.encode(priv.toByteArray());
                } else {
                    destKeystream = this.bridge.getKeystream(dest);
                    if (destKeystream == null) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Custom destination specified [" + dest + "] but it isn't known, creating a new one");
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(640);
                        SAMUtils.genRandomKey(baos, null);
                        destKeystream = Base64.encode(baos.toByteArray());
                        this.bridge.addKeystream(dest, destKeystream);
                    } else if (this._log.shouldLog(10)) {
                        this._log.debug("Custom destination specified [" + dest + "] and it is already known");
                    }
                }
                String style = (String)props.remove("STYLE");
                if (style == null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("SESSION STYLE parameter not specified");
                    }
                    return this.writeString(SESSION_ERROR, "No SESSION STYLE specified");
                }
                props.setProperty("i2cp.messageReliability", "none");
                if (style.equals("RAW")) {
                    this.rawSession = new SAMRawSession(destKeystream, props, (SAMRawReceiver)this);
                    this.rawSession.start();
                } else if (style.equals("DATAGRAM")) {
                    this.datagramSession = new SAMDatagramSession(destKeystream, props, (SAMDatagramReceiver)this);
                    this.datagramSession.start();
                } else if (style.equals("STREAM")) {
                    String dir = (String)props.remove("DIRECTION");
                    if (dir == null) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("No DIRECTION parameter in STREAM session, defaulting to BOTH");
                        }
                        dir = "BOTH";
                    } else if (!(dir.equals("CREATE") || dir.equals("RECEIVE") || dir.equals("BOTH"))) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Unknown DIRECTION parameter value: [" + dir + "]");
                        }
                        return this.writeString(SESSION_ERROR, "Unknown DIRECTION parameter");
                    }
                    this.streamSession = this.newSAMStreamSession(destKeystream, dir, props);
                    this.streamSession.start();
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Unrecognized SESSION STYLE: \"" + style + "\"");
                    }
                    return this.writeString(SESSION_ERROR, "Unrecognized SESSION STYLE");
                }
                return this.writeString("SESSION STATUS RESULT=OK DESTINATION=" + dest + "\n");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Unrecognized SESSION message opcode: \"" + opcode + "\"");
            }
            return this.writeString(SESSION_ERROR, "Unrecognized opcode");
        }
        catch (DataFormatException e) {
            this._log.error("Invalid SAM destination specified", e);
            return this.writeString("SESSION STATUS RESULT=INVALID_KEY", e.getMessage());
        }
        catch (I2PSessionException e) {
            this._log.error("Failed to start SAM session", e);
            return this.writeString(SESSION_ERROR, e.getMessage());
        }
        catch (SAMException e) {
            this._log.error("Failed to start SAM session", e);
            return this.writeString(SESSION_ERROR, e.getMessage());
        }
        catch (IOException e) {
            this._log.error("Failed to start SAM session", e);
            return this.writeString(SESSION_ERROR, e.getMessage());
        }
    }

    private SAMStreamSession newSAMStreamSession(String destKeystream, String direction, Properties props) throws IOException, DataFormatException, SAMException {
        return new SAMStreamSession(destKeystream, direction, props, (SAMStreamReceiver)this);
    }

    protected boolean execDestMessage(String opcode, Properties props) {
        if (opcode.equals("GENERATE")) {
            SigType sigType;
            String sigTypeStr = props.getProperty("SIGNATURE_TYPE");
            if (sigTypeStr != null) {
                sigType = SigType.parseSigType(sigTypeStr);
                if (sigType == null) {
                    this.writeString("DEST REPLY RESULT=I2P_ERROR MESSAGE=\"SIGNATURE_TYPE " + sigTypeStr + " unsupported\"\n");
                    return false;
                }
            } else {
                sigType = SigType.DSA_SHA1;
            }
            ByteArrayOutputStream priv = new ByteArrayOutputStream(663);
            ByteArrayOutputStream pub = new ByteArrayOutputStream(387);
            SAMUtils.genRandomKey(priv, pub, sigType);
            return this.writeString("DEST REPLY PUB=" + Base64.encode(pub.toByteArray()) + " PRIV=" + Base64.encode(priv.toByteArray()) + "\n");
        }
        this.writeString("DEST REPLY RESULT=I2P_ERROR MESSAGE=\"DEST GENERATE required\"");
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized DEST message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execNamingMessage(String opcode, Properties props) {
        block12: {
            Destination dest;
            String name;
            block11: {
                block13: {
                    block14: {
                        if (!opcode.equals("LOOKUP")) break block12;
                        name = props.getProperty("NAME");
                        if (name == null) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("Name to resolve not specified in NAMING message");
                            }
                            return this.writeString("NAMING REPLY RESULT=KEY_NOT_FOUND NAME=\"\" MESSAGE=\"Must specify NAME\"\n");
                        }
                        dest = null;
                        if (!name.equals("ME")) break block13;
                        if (this.rawSession == null) break block14;
                        dest = this.rawSession.getDestination();
                        break block11;
                    }
                    if (this.streamSession != null) {
                        dest = this.streamSession.getDestination();
                        break block11;
                    } else if (this.datagramSession != null) {
                        dest = this.datagramSession.getDestination();
                        break block11;
                    } else {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Lookup for SESSION destination, but session is null");
                        }
                        return false;
                    }
                }
                try {
                    dest = SAMUtils.getDest(name);
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
            if (dest == null) {
                return this.writeString("NAMING REPLY RESULT=KEY_NOT_FOUND NAME=" + name + "\n");
            }
            return this.writeString("NAMING REPLY RESULT=OK NAME=" + name + " VALUE=" + dest.toBase64() + "\n");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized NAMING message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    protected boolean execDatagramMessage(String opcode, Properties props) {
        if (this.datagramSession == null) {
            this._log.error("DATAGRAM message received, but no DATAGRAM session exists");
            return false;
        }
        return this.execDgOrRawMessage(false, opcode, props);
    }

    protected boolean execRawMessage(String opcode, Properties props) {
        if (this.rawSession == null) {
            this._log.error("RAW message received, but no RAW session exists");
            return false;
        }
        return this.execDgOrRawMessage(true, opcode, props);
    }

    private boolean execDgOrRawMessage(boolean isRaw, String opcode, Properties props) {
        if (opcode.equals("SEND")) {
            int proto;
            int toPort;
            int fromPort;
            int size;
            String dest;
            block36: {
                String s;
                block35: {
                    boolean ok;
                    if (props.isEmpty()) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("No parameters specified in SEND message");
                        }
                        return false;
                    }
                    dest = props.getProperty("DESTINATION");
                    if (dest == null) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Destination not specified in SEND message");
                        }
                        return false;
                    }
                    String strsize = props.getProperty("SIZE");
                    if (strsize == null) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Size not specified in SEND message");
                        }
                        return false;
                    }
                    try {
                        size = Integer.parseInt(strsize);
                    }
                    catch (NumberFormatException e) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Invalid SEND size specified: " + strsize);
                        }
                        return false;
                    }
                    boolean bl = ok = isRaw ? this.checkSize(size) : this.checkDatagramSize(size);
                    if (!ok) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Specified size (" + size + ") is out of protocol limits");
                        }
                        return false;
                    }
                    fromPort = 0;
                    toPort = 0;
                    if (isRaw) {
                        proto = 18;
                        s = props.getProperty("PROTOCOL");
                        if (s != null) {
                            try {
                                proto = Integer.parseInt(s);
                            }
                            catch (NumberFormatException e) {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Invalid SEND protocol specified: " + s);
                                }
                            }
                        }
                    } else {
                        proto = 17;
                    }
                    if ((s = props.getProperty("FROM_PORT")) != null) {
                        try {
                            fromPort = Integer.parseInt(s);
                        }
                        catch (NumberFormatException e) {
                            if (!this._log.shouldLog(30)) break block35;
                            this._log.warn("Invalid SEND port specified: " + s);
                        }
                    }
                }
                if ((s = props.getProperty("TO_PORT")) != null) {
                    try {
                        toPort = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        if (!this._log.shouldLog(30)) break block36;
                        this._log.warn("Invalid SEND port specified: " + s);
                    }
                }
            }
            try {
                SAMMessageSess sess;
                DataInputStream in = new DataInputStream(this.getClientSocket().socket().getInputStream());
                byte[] data = new byte[size];
                in.readFully(data);
                SAMMessageSess sAMMessageSess = sess = isRaw ? this.rawSession : this.datagramSession;
                if (!sess.sendBytes(dest, data, proto, fromPort, toPort) && this._log.shouldWarn()) {
                    this._log.warn((isRaw ? "SEND RAW to " : "SEND DATAGRAM to ") + dest + " size " + size + " failed");
                }
                return true;
            }
            catch (EOFException e) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Too few bytes with SEND message (expected: " + size, e);
                }
                return false;
            }
            catch (IOException e) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Caught IOException while parsing SEND message", e);
                }
                return false;
            }
            catch (DataFormatException e) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Invalid key specified with SEND message", e);
                }
                return false;
            }
            catch (I2PSessionException e) {
                this._log.error("Session error with SEND message", e);
                return false;
            }
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Unrecognized message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    protected boolean execStreamMessage(String opcode, Properties props) {
        if (this.streamSession == null) {
            this._log.error("STREAM message received, but no STREAM session exists");
            return false;
        }
        if (opcode.equals("SEND")) {
            return this.execStreamSend(props);
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("CLOSE")) {
            return this.execStreamClose(props);
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Unrecognized STREAM message opcode: \"" + opcode + "\"");
        }
        return false;
    }

    protected boolean execStreamSend(Properties props) {
        int size;
        int id;
        if (props.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No parameters specified in STREAM SEND message");
            }
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ID not specified in STREAM SEND message");
            }
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM SEND ID specified: " + strid);
            }
            return false;
        }
        String strsize = props.getProperty("SIZE");
        if (strsize == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Size not specified in STREAM SEND message");
            }
            return false;
        }
        try {
            size = Integer.parseInt(strsize);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM SEND size specified: " + strsize);
            }
            return false;
        }
        if (!this.checkSize(size)) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Specified size (" + size + ") is out of protocol limits");
            }
            return false;
        }
        try {
            if (!this.streamSession.sendBytes(id, this.getClientSocket().socket().getInputStream(), size)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("STREAM SEND [" + size + "] failed");
                }
                boolean rv = this.writeString("STREAM CLOSED RESULT=CANT_REACH_PEER ID=" + id + " MESSAGE=\"Send of " + size + " bytes failed\"\n");
                this.streamSession.closeConnection(id);
                return rv;
            }
            return true;
        }
        catch (EOFException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Too few bytes with STREAM SEND message (expected: " + size);
            }
            return false;
        }
        catch (IOException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Caught IOException while parsing STREAM SEND message", e);
            }
            return false;
        }
    }

    protected boolean execStreamConnect(Properties props) {
        int id;
        if (props.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No parameters specified in STREAM CONNECT message");
            }
            return false;
        }
        String strid = (String)props.remove("ID");
        if (strid == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ID not specified in STREAM SEND message");
            }
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM CONNECT ID specified: " + strid);
            }
            return false;
        }
        if (id < 1) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM CONNECT ID specified: " + strid);
            }
            return false;
        }
        String dest = (String)props.remove("DESTINATION");
        if (dest == null) {
            this._log.debug("Destination not specified in RAW SEND message");
            return false;
        }
        try {
            try {
                if (!this.streamSession.connect(id, dest, props)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("STREAM connection failed");
                    }
                    return false;
                }
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid destination in STREAM CONNECT message");
                }
                this.notifyStreamOutgoingConnection(id, "INVALID_KEY", null);
            }
            catch (SAMInvalidDirectionException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "INVALID_DIRECTION", null);
            }
            catch (ConnectException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "CONNECTION_REFUSED", null);
            }
            catch (NoRouteToHostException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "CANT_REACH_PEER", null);
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "TIMEOUT", null);
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamOutgoingConnection(id, "I2P_ERROR", null);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected boolean execStreamClose(Properties props) {
        int id;
        if (props.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No parameters specified in STREAM CLOSE message");
            }
            return false;
        }
        String strid = props.getProperty("ID");
        if (strid == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ID not specified in STREAM CLOSE message");
            }
            return false;
        }
        try {
            id = Integer.parseInt(strid);
        }
        catch (NumberFormatException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid STREAM CLOSE ID specified: " + strid);
            }
            return false;
        }
        boolean closed = this.streamSession.closeConnection(id);
        if (!closed && this._log.shouldLog(30)) {
            this._log.warn("Stream unable to be closed, but this is non fatal");
        }
        return true;
    }

    private boolean checkSize(int size) {
        return size >= 1 && size <= 32768;
    }

    private boolean checkDatagramSize(int size) {
        return size >= 1 && size <= 31744;
    }

    @Override
    public void receiveRawBytes(byte[] data, int proto, int fromPort, int toPort) throws IOException {
        if (this.rawSession == null) {
            this._log.error("BUG! Received raw bytes, but session is null!");
            return;
        }
        ByteArrayOutputStream msg = new ByteArrayOutputStream(64 + data.length);
        String msgText = "RAW RECEIVED SIZE=" + data.length;
        msg.write(DataHelper.getASCII(msgText));
        if (this.verMajor == 3 && this.verMinor >= 2 || this.verMajor > 3) {
            msgText = " PROTOCOL=" + proto + " FROM_PORT=" + fromPort + " TO_PORT=" + toPort;
            msg.write(DataHelper.getASCII(msgText));
        }
        msg.write(10);
        msg.write(data);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending to client: " + msgText);
        }
        this.writeBytes(ByteBuffer.wrap(msg.toByteArray()));
    }

    @Override
    public void stopRawReceiving() {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("stopRawReceiving() invoked");
            }
            if (this.rawSession == null) {
                this._log.error("BUG! Got raw receiving stop, but session is null!");
                return;
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error closing socket", e);
            }
        }
    }

    @Override
    public void receiveDatagramBytes(Destination sender, byte[] data, int proto, int fromPort, int toPort) throws IOException {
        if (this.datagramSession == null) {
            this._log.error("BUG! Received datagram bytes, but session is null!");
            return;
        }
        ByteArrayOutputStream msg = new ByteArrayOutputStream(100 + data.length);
        String msgText = "DATAGRAM RECEIVED DESTINATION=" + sender.toBase64() + " SIZE=" + data.length;
        msg.write(DataHelper.getASCII(msgText));
        if (this.verMajor == 3 && this.verMinor >= 2 || this.verMajor > 3) {
            msgText = " FROM_PORT=" + fromPort + " TO_PORT=" + toPort;
            msg.write(DataHelper.getASCII(msgText));
        }
        msg.write(10);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending to client: " + msgText);
        }
        msg.write(data);
        msg.flush();
        this.writeBytes(ByteBuffer.wrap(msg.toByteArray()));
    }

    @Override
    public void stopDatagramReceiving() {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("stopDatagramReceiving() invoked");
            }
            if (this.datagramSession == null) {
                this._log.error("BUG! Got datagram receiving stop, but session is null!");
                return;
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error closing socket", e);
            }
        }
    }

    @Override
    public void streamSendAnswer(int id, String result, String bufferState) throws IOException {
        if (this.streamSession == null) {
            this._log.error("BUG! Want to answer to stream SEND, but session is null!");
            return;
        }
        if (!this.writeString("STREAM SEND ID=" + id + " RESULT=" + result + " STATE=" + bufferState + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    @Override
    public void notifyStreamSendBufferFree(int id) throws IOException {
        if (this.streamSession == null) {
            this._log.error("BUG! Stream outgoing buffer is free, but session is null!");
            return;
        }
        if (!this.writeString("STREAM READY_TO_SEND ID=" + id + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    @Override
    public void notifyStreamIncomingConnection(int id, Destination d) throws IOException {
        if (this.streamSession == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            return;
        }
        if (!this.writeString("STREAM CONNECTED DESTINATION=" + d.toBase64() + " ID=" + id + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    @Override
    public void notifyStreamOutgoingConnection(int id, String result, String msg) throws IOException {
        if (this.streamSession == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            return;
        }
        String msgString = SAMv1Handler.createMessageString(msg);
        if (!this.writeString("STREAM STATUS RESULT=" + result + " ID=" + id + msgString + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    protected static String createMessageString(String msg) {
        String rv;
        if (msg != null) {
            msg = msg.replace("\n", " ");
            if (!(msg = msg.replace("\r", " ")).startsWith("\"") && ((msg = msg.replace("\"", "")).contains(" ") || msg.contains("\t"))) {
                msg = '\"' + msg + '\"';
            }
            rv = " MESSAGE=" + msg;
        } else {
            rv = "";
        }
        return rv;
    }

    protected boolean writeString(String s, String msg) {
        return this.writeString(s + SAMv1Handler.createMessageString(msg) + '\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveStreamBytes(int id, ByteBuffer data) throws IOException {
        Object writeLock;
        if (this.streamSession == null) {
            this._log.error("Received stream bytes, but session is null!");
            return;
        }
        String msgText = "STREAM RECEIVED ID=" + id + " SIZE=" + data.remaining() + "\n";
        if (this._log.shouldLog(10)) {
            this._log.debug("sending to client: " + msgText);
        }
        ByteBuffer prefix = ByteBuffer.wrap(DataHelper.getASCII(msgText));
        Object object = writeLock = this.getWriteLock();
        synchronized (object) {
            while (prefix.hasRemaining()) {
                this.socket.write(prefix);
            }
            while (data.hasRemaining()) {
                this.socket.write(data);
            }
            this.socket.socket().getOutputStream().flush();
        }
    }

    @Override
    public void notifyStreamDisconnection(int id, String result, String msg) throws IOException {
        if (this.streamSession == null) {
            this._log.error("BUG! Received stream disconnection, but session is null!");
            return;
        }
        String msgString = SAMv1Handler.createMessageString(msg);
        if (!this.writeString("STREAM CLOSED ID=" + id + " RESULT=" + result + msgString + '\n')) {
            throw new IOException("Error notifying disconnection to SAM client");
        }
    }

    @Override
    public void stopStreamReceiving() {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("stopStreamReceiving() invoked", new Exception("stopped"));
            }
            if (this.streamSession == null) {
                this._log.error("BUG! Got stream receiving stop, but session is null!");
                return;
            }
            try {
                this.closeClientSocket();
            }
            catch (IOException e) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error closing socket", e);
            }
        }
    }
}

