/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.kademlia;

import java.util.ArrayList;
import net.i2p.I2PAppContext;
import net.i2p.data.SimpleDataStructure;
import net.i2p.kademlia.KBucket;
import net.i2p.kademlia.KBucketTrimmer;

public class RandomTrimmer<T extends SimpleDataStructure>
implements KBucketTrimmer<T> {
    protected final I2PAppContext _ctx;
    private final int _max;

    public RandomTrimmer(I2PAppContext ctx, int max) {
        this._ctx = ctx;
        this._max = max;
    }

    @Override
    public boolean trim(KBucket<T> kbucket, T toAdd) {
        ArrayList<T> e = new ArrayList<T>(kbucket.getEntries());
        int sz = e.size();
        if (sz < this._max) {
            return true;
        }
        SimpleDataStructure toRemove = (SimpleDataStructure)e.get(this._ctx.random().nextInt(sz));
        kbucket.remove(toRemove);
        return true;
    }
}

