/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.crypto.HMACGenerator;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.router.transport.udp.I2PHMac;

class SSUHMACGenerator
extends HMACGenerator {
    private final LinkedBlockingQueue<I2PHMac> _available = new LinkedBlockingQueue(32);

    @Override
    public void calculate(SessionKey key, byte[] data, int offset, int length, byte[] target, int targetOffset) {
        if (key == null || key.getData() == null || data == null) {
            throw new NullPointerException("Null arguments for HMAC");
        }
        I2PHMac mac = this.acquire();
        mac.init(key.getData());
        mac.update(data, offset, length);
        mac.doFinal(target, targetOffset);
        this.release(mac);
    }

    @Override
    public boolean verify(SessionKey key, byte[] curData, int curOffset, int curLength, byte[] origMAC, int origMACOffset, int origMACLength) {
        if (key == null || key.getData() == null || curData == null) {
            throw new NullPointerException("Null arguments for HMAC");
        }
        I2PHMac mac = this.acquire();
        mac.init(key.getData());
        mac.update(curData, curOffset, curLength);
        byte[] rv = this.acquireTmp();
        mac.doFinal(rv, 0);
        this.release(mac);
        boolean eq = DataHelper.eqCT(rv, 0, origMAC, origMACOffset, origMACLength);
        this.releaseTmp(rv);
        return eq;
    }

    private I2PHMac acquire() {
        I2PHMac rv = this._available.poll();
        if (rv != null) {
            return rv;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return new I2PHMac(md, 32);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new UnsupportedOperationException("MD5");
        }
    }

    private void release(I2PHMac mac) {
        this._available.offer(mac);
    }

    public void clearCache() {
        this._available.clear();
    }
}

