"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../../renderers/canvas");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
var line_1 = require("./line");
function renderCircle(ctx, circle, fill, stroke) {
    if (!fill && !stroke) {
        return;
    }
    renderArc(ctx, __assign(__assign({}, circle), { startAngle: 0, endAngle: Math.PI * 2 }), fill, stroke);
}
exports.renderCircle = renderCircle;
function renderArc(ctx, arc, fill, stroke) {
    if (!fill && !stroke) {
        return;
    }
    canvas_1.withContext(ctx, function (ctx) {
        var x = arc.x, y = arc.y, radius = arc.radius, startAngle = arc.startAngle, endAngle = arc.endAngle;
        ctx.translate(x, y);
        ctx.beginPath();
        ctx.arc(0, 0, radius, startAngle, endAngle, false);
        if (fill) {
            ctx.fillStyle = color_library_wrappers_1.RGBtoString(fill.color);
            ctx.fill();
        }
        if (stroke && stroke.width > line_1.MIN_STROKE_WIDTH) {
            ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
            ctx.lineWidth = stroke.width;
            if (stroke.dash) {
                ctx.setLineDash(stroke.dash);
            }
            ctx.stroke();
        }
    });
}
exports.renderArc = renderArc;
//# sourceMappingURL=arc.js.map