/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.value.StringValue;

public class StringField
extends AnalyticsField
implements StringValue.CastingStringValue {
    private BinaryDocValues docValues;
    String value;
    boolean exists = false;

    public StringField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getBinary((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.exists = this.docValues.advanceExact(doc);
        if (this.exists) {
            this.value = this.docValues.binaryValue().utf8ToString();
        }
    }

    @Override
    public String getString() {
        return this.exists ? this.value : null;
    }

    @Override
    public Object getObject() {
        return this.exists ? this.value : null;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public ExpressionComparator<String> getObjectComparator(String expression) {
        return new ExpressionComparator<String>(expression);
    }
}

