/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRXmlUtils {
    private static final Log log = LogFactory.getLog((Class)JRXmlUtils.class);

    public static Document parse(InputSource is) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder().parse(is);
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
    }

    public static Document parse(String uri) throws JRException {
        return JRXmlUtils.parse(new InputSource(uri));
    }

    public static Document parse(File file) throws JRException {
        try {
            return JRXmlUtils.createDocumentBuilder().parse(file);
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
    }

    public static Document parse(InputStream is) throws JRException {
        return JRXmlUtils.parse(new InputSource(is));
    }

    public static Document parse(URL url) throws JRException {
        InputStream is = null;
        try {
            is = url.openStream();
            Document document = JRXmlUtils.createDocumentBuilder().parse(is);
            return document;
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xmlf document", e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing stream of URL " + url), (Throwable)e);
                }
            }
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws JRException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRException("Failed to create a document builder factory", e);
        }
    }

    public static Document createDocument(Node sourceNode) throws JRException {
        Document doc = JRXmlUtils.createDocumentBuilder().newDocument();
        Node source = sourceNode.getNodeType() == 9 ? ((Document)sourceNode).getDocumentElement() : sourceNode;
        Node node = doc.importNode(source, true);
        doc.appendChild(node);
        return doc;
    }
}

