/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class BceProtocolDecoder
extends BaseProtocolDecoder {
    private static final int DATA_TYPE = 7;
    public static final int MSG_ASYNC_STACK = 165;
    public static final int MSG_STACK_COFIRM = 25;
    public static final int MSG_TIME_TRIGGERED = 160;
    public static final int MSG_OUTPUT_CONTROL = 65;
    public static final int MSG_OUTPUT_CONTROL_ACK = 193;

    public BceProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeMask1(ByteBuf buf, int mask, Position position) {
        if (BitUtil.check(mask, 0)) {
            position.setValid(true);
            position.setLongitude(buf.readFloatLE());
            position.setLatitude(buf.readFloatLE());
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            short status = buf.readUnsignedByte();
            position.set("sat", BitUtil.to(status, 4));
            position.set("hdop", BitUtil.from(status, 4));
            position.setCourse(buf.readUnsignedByte() * 2);
            position.setAltitude(buf.readUnsignedShortLE());
            position.set("odometer", buf.readUnsignedIntLE());
        }
        if (BitUtil.check(mask, 1)) {
            position.set("input", buf.readUnsignedShortLE());
        }
        for (int i = 1; i <= 8; ++i) {
            if (!BitUtil.check(mask, i + 1)) continue;
            position.set("adc" + i, buf.readUnsignedShortLE());
        }
        if (BitUtil.check(mask, 10)) {
            buf.skipBytes(4);
        }
        if (BitUtil.check(mask, 11)) {
            buf.skipBytes(4);
        }
        if (BitUtil.check(mask, 12)) {
            position.set("fuel1", buf.readUnsignedShort());
        }
        if (BitUtil.check(mask, 13)) {
            position.set("fuel2", buf.readUnsignedShort());
        }
        if (BitUtil.check(mask, 14)) {
            int mcc = buf.readUnsignedShortLE();
            short mnc = buf.readUnsignedByte();
            int lac = buf.readUnsignedShortLE();
            int cid = buf.readUnsignedShortLE();
            buf.readUnsignedByte();
            short rssi = -buf.readUnsignedByte();
            position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid, rssi)));
        }
    }

    private void decodeMask2(ByteBuf buf, int mask, Position position) {
        if (BitUtil.check(mask, 0)) {
            buf.readUnsignedShortLE();
        }
        if (BitUtil.check(mask, 1)) {
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask, 2)) {
            position.set("fuelUsed", (double)buf.readUnsignedIntLE() * 0.5);
        }
        if (BitUtil.check(mask, 3)) {
            position.set("fuel", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 4)) {
            position.set("rpm", (double)buf.readUnsignedShortLE() * 0.125);
        }
        if (BitUtil.check(mask, 5)) {
            position.set("hours", buf.readUnsignedIntLE());
        }
        if (BitUtil.check(mask, 6)) {
            position.set("odometer", buf.readUnsignedIntLE());
        }
        if (BitUtil.check(mask, 7)) {
            position.set("coolantTemp", buf.readByte() - 40);
        }
        if (BitUtil.check(mask, 8)) {
            position.set("fuel2", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 9)) {
            position.set("engineLoad", buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 10)) {
            position.set("serviceOdometer", buf.readUnsignedShortLE());
        }
        if (BitUtil.check(mask, 11)) {
            buf.skipBytes(8);
        }
        if (BitUtil.check(mask, 12)) {
            buf.readUnsignedShortLE();
        }
        if (BitUtil.check(mask, 13)) {
            buf.skipBytes(8);
        }
        if (BitUtil.check(mask, 14)) {
            position.set("fuelConsumption", buf.readUnsignedShortLE());
        }
    }

    private void decodeMask3(ByteBuf buf, int mask, Position position) {
        if (BitUtil.check(mask, 0)) {
            buf.readUnsignedShortLE();
        }
        if (BitUtil.check(mask, 1)) {
            position.set("fuelConsumption", buf.readUnsignedIntLE());
        }
        if (BitUtil.check(mask, 2)) {
            position.set("axleWeight", buf.readUnsignedMediumLE());
        }
        if (BitUtil.check(mask, 3)) {
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask, 4)) {
            buf.skipBytes(20);
        }
        if (BitUtil.check(mask, 5)) {
            buf.readUnsignedShortLE();
        }
        if (BitUtil.check(mask, 6)) {
            position.set("driverUniqueId", String.valueOf(buf.readLongLE()));
        }
        if (BitUtil.check(mask, 7)) {
            position.set("temp1", (double)buf.readUnsignedShortLE() * 0.1 - 273.0);
        }
        if (BitUtil.check(mask, 8)) {
            buf.readUnsignedShortLE();
        }
        if (BitUtil.check(mask, 9)) {
            position.set("fuel1", buf.readUnsignedShortLE());
            position.set("fuelTemp1", Integer.valueOf(buf.readByte()));
            position.set("fuel2", buf.readUnsignedShortLE());
            position.set("fuelTemp2", Integer.valueOf(buf.readByte()));
        }
        if (BitUtil.check(mask, 10)) {
            position.set("fuel3", buf.readUnsignedShortLE());
            position.set("fuelTemp3", Integer.valueOf(buf.readByte()));
            position.set("fuel4", buf.readUnsignedShortLE());
            position.set("fuelTemp4", Integer.valueOf(buf.readByte()));
        }
        if (BitUtil.check(mask, 11)) {
            buf.skipBytes(21);
        }
        if (BitUtil.check(mask, 12)) {
            buf.skipBytes(20);
        }
        if (BitUtil.check(mask, 13)) {
            buf.skipBytes(9);
        }
        if (BitUtil.check(mask, 14)) {
            buf.skipBytes(21);
        }
    }

    private void decodeMask4(ByteBuf buf, int mask, Position position) {
        if (BitUtil.check(mask, 0)) {
            buf.readUnsignedIntLE();
        }
        if (BitUtil.check(mask, 1)) {
            buf.skipBytes(30);
        }
        if (BitUtil.check(mask, 2)) {
            buf.readUnsignedIntLE();
        }
        if (BitUtil.check(mask, 3)) {
            buf.skipBytes(10);
        }
        if (BitUtil.check(mask, 4)) {
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask, 5)) {
            buf.readUnsignedShortLE();
        }
        if (BitUtil.check(mask, 6)) {
            position.set("maxAcceleration", (double)buf.readUnsignedByte() * 0.02);
            position.set("maxBraking", (double)buf.readUnsignedByte() * 0.02);
            position.set("maxCornering", (double)buf.readUnsignedByte() * 0.02);
        }
        if (BitUtil.check(mask, 7)) {
            buf.skipBytes(16);
        }
        if (BitUtil.check(mask, 8)) {
            for (int i = 1; i <= 4; ++i) {
                int temperature = buf.readUnsignedShortLE();
                if (temperature > 0) {
                    position.set("temp" + i, (double)temperature * 0.1 - 273.0);
                }
                buf.skipBytes(8);
            }
        }
        if (BitUtil.check(mask, 9)) {
            position.set("driver1", buf.readCharSequence(16, StandardCharsets.US_ASCII).toString().trim());
            position.set("driver2", buf.readCharSequence(16, StandardCharsets.US_ASCII).toString().trim());
        }
        if (BitUtil.check(mask, 10)) {
            position.set("odometer", buf.readUnsignedIntLE());
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        String imei = String.format("%015d", buf.readLongLE());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.readableBytes() > 1) {
            int dataEnd = buf.readUnsignedShortLE() + buf.readerIndex();
            short type = buf.readUnsignedByte();
            if (type != 165 && type != 160) {
                return null;
            }
            int confirmKey = buf.readUnsignedByte() & 0x7F;
            while (buf.readerIndex() < dataEnd) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                int structEnd = buf.readUnsignedByte() + buf.readerIndex();
                long time = buf.readUnsignedIntLE();
                if ((time & 0xFL) == 7L) {
                    int mask;
                    time = time >> 4 << 1;
                    position.setTime(new Date((time += 1199145600L) * 1000L));
                    LinkedList<Integer> masks = new LinkedList<Integer>();
                    do {
                        mask = buf.readUnsignedShortLE();
                        masks.add(mask);
                    } while (BitUtil.check(mask, 15));
                    mask = (Integer)masks.get(0);
                    this.decodeMask1(buf, mask, position);
                    if (masks.size() >= 2) {
                        mask = (Integer)masks.get(1);
                        this.decodeMask2(buf, mask, position);
                    }
                    if (masks.size() >= 3) {
                        mask = (Integer)masks.get(2);
                        this.decodeMask3(buf, mask, position);
                    }
                    if (masks.size() >= 4) {
                        mask = (Integer)masks.get(3);
                        this.decodeMask4(buf, mask, position);
                    }
                }
                buf.readerIndex(structEnd);
                if (position.getValid()) {
                    positions.add(position);
                    continue;
                }
                if (position.getAttributes().isEmpty()) continue;
                this.getLastLocation(position, null);
                positions.add(position);
            }
            if (type != 165 || channel == null) continue;
            ByteBuf response = Unpooled.buffer((int)13);
            response.writeLongLE(Long.parseLong(imei));
            response.writeShortLE(2);
            response.writeByte(25);
            response.writeByte(confirmKey);
            int checksum = 0;
            for (int i = 0; i < response.writerIndex(); ++i) {
                checksum += response.getUnsignedByte(i);
            }
            response.writeByte(checksum);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return positions;
    }
}

