/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.traccar.BaseFrameDecoder;
import org.traccar.BasePipelineFactory;
import org.traccar.protocol.NavtelecomProtocolDecoder;

public class NavtelecomFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.getByte(buf.readerIndex()) == 64) {
            int length = buf.getUnsignedShortLE(12) + 12 + 2 + 2;
            if (buf.readableBytes() >= length) {
                return buf.readRetainedSlice(length);
            }
        } else {
            NavtelecomProtocolDecoder protocolDecoder = BasePipelineFactory.getHandler(ctx.pipeline(), NavtelecomProtocolDecoder.class);
            if (protocolDecoder == null) {
                throw new RuntimeException("Decoder not found");
            }
            String type = buf.getCharSequence(buf.readerIndex(), 2, StandardCharsets.US_ASCII).toString();
            BitSet bits = protocolDecoder.getBits();
            if (type.equals("~A")) {
                int count = buf.getUnsignedByte(buf.readerIndex() + 2);
                int length = 4;
                for (int i = 0; i < count; ++i) {
                    for (int j = 0; j < bits.length(); ++j) {
                        if (!bits.get(j)) continue;
                        length += NavtelecomProtocolDecoder.getItemLength(j + 1);
                    }
                }
                if (buf.readableBytes() >= length) {
                    return buf.readRetainedSlice(length);
                }
            } else {
                throw new UnsupportedOperationException("Unsupported message type: " + type);
            }
        }
        return null;
    }
}

