/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ProjectSettings;
import ca.sqlpower.architect.SourceObjectIntegrityWatcher;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.enterprise.client.Group;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectPreEventListener;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.util.RunnableDispatcher;
import ca.sqlpower.util.SessionNotFoundException;
import ca.sqlpower.util.WorkspaceContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ArchitectProject
extends AbstractSPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(UserDefinedSQLType.class, SQLObjectRoot.class, ProfileManager.class, ProjectSettings.class, User.class, Group.class)));
    private ArchitectSession session;
    private final SQLObjectRoot rootObject;
    private ProfileManager profileManager;
    private ProjectSettings projectSettings;
    private List<User> users = new ArrayList<User>();
    private List<Group> groups = new ArrayList<Group>();
    private final List<UserDefinedSQLType> sqlTypes = new ArrayList<UserDefinedSQLType>();
    private String etlProcessDescription;
    private SourceObjectIntegrityWatcher currentWatcher;

    public ArchitectProject() throws SQLObjectException {
        this(new SQLObjectRoot(), null);
        SQLDatabase targetDatabase = new SQLDatabase();
        targetDatabase.setPlayPenDatabase(true);
        this.rootObject.addChild((SPObject)targetDatabase, 0);
    }

    public ArchitectProject(SQLObjectRoot root) throws SQLObjectException {
        this(root, null);
    }

    @Constructor
    public ArchitectProject(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="rootObject") SQLObjectRoot rootObject, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="profileManager") ProfileManager profileManager) throws SQLObjectException {
        this.rootObject = rootObject;
        rootObject.setParent((SPObject)this);
        this.projectSettings = new ProjectSettings();
        this.projectSettings.setParent((SPObject)this);
        if (profileManager != null) {
            this.setProfileManager(profileManager);
        }
        this.setName("Architect Project");
    }

    @Transient
    @Mutator
    public void setSession(ArchitectSession session) {
        if (this.session != null) {
            this.rootObject.removeSQLObjectPreEventListener((SQLObjectPreEventListener)this.currentWatcher);
            this.currentWatcher = null;
        }
        this.session = session;
        if (this.session != null) {
            this.currentWatcher = new SourceObjectIntegrityWatcher(session);
            this.rootObject.addSQLObjectPreEventListener((SQLObjectPreEventListener)this.currentWatcher);
        }
    }

    @NonProperty
    public SQLObjectRoot getRootObject() {
        return this.rootObject;
    }

    @NonProperty
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @NonProperty
    public SQLDatabase getDatabase(JDBCDataSource ds) {
        try {
            for (SQLDatabase obj : this.getRootObject().getChildren(SQLDatabase.class)) {
                if (!obj.getDataSource().equals((Object)ds)) continue;
                return obj;
            }
            SQLDatabase db = new SQLDatabase(ds);
            this.getRootObject().addChild((SQLObject)db);
            return db;
        }
        catch (SQLObjectException e) {
            throw new RuntimeException(e);
        }
    }

    @Transient
    @Accessor
    public SQLDatabase getTargetDatabase() {
        for (SQLDatabase db : this.rootObject.getChildren(SQLDatabase.class)) {
            if (!db.isPlayPenDatabase()) continue;
            return db;
        }
        throw new IllegalStateException("No target database!");
    }

    @NonProperty
    public void setSourceDatabaseList(List<SQLDatabase> databases) throws SQLObjectException {
        SQLObjectRoot root = this.getRootObject();
        SQLDatabase targetDB = this.getTargetDatabase();
        try {
            root.begin("Setting source database list");
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                root.removeChild((SPObject)root.getChild(i));
            }
            if (targetDB != null) {
                root.addChild((SQLObject)targetDB);
            }
            for (SQLDatabase db : databases) {
                root.addChild((SQLObject)db);
            }
            root.commit();
        }
        catch (IllegalArgumentException e) {
            root.rollback("Could not remove child: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            root.rollback("Could not remove child: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @NonProperty
    public void setProfileManager(ProfileManager manager) {
        ProfileManager oldManager = this.profileManager;
        this.profileManager = manager;
        if (oldManager != null) {
            this.fireChildRemoved(ProfileManager.class, oldManager, 0);
        }
        this.fireChildAdded(ProfileManager.class, manager, 0);
        this.profileManager.setParent((SPObject)this);
    }

    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof User) {
            return this.removeUser((User)child);
        }
        if (child instanceof Group) {
            return this.removeGroup((Group)child);
        }
        if (child instanceof UserDefinedSQLType) {
            return this.removeSQLType((UserDefinedSQLType)child);
        }
        return false;
    }

    public boolean removeUser(User child) {
        int index = this.users.indexOf(child);
        boolean removed = this.users.remove(child);
        if (removed) {
            this.fireChildRemoved(User.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    public boolean removeGroup(Group child) {
        int index = this.users.indexOf(child);
        boolean removed = this.groups.remove(child);
        if (removed) {
            this.fireChildRemoved(Group.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    public boolean removeSQLType(UserDefinedSQLType child) {
        int index = this.sqlTypes.indexOf(child);
        boolean removed = this.sqlTypes.remove(child);
        if (removed) {
            this.fireChildRemoved(UserDefinedSQLType.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    @Transient
    @Accessor
    public ArchitectSession getSession() throws SessionNotFoundException {
        if (this.session != null) {
            return this.session;
        }
        throw new SessionNotFoundException("The project has not been given a session yet. This should only happen during the construction of the project.");
    }

    @Transient
    @Accessor
    public WorkspaceContainer getWorkspaceContainer() {
        return this.getSession();
    }

    @Transient
    @Accessor
    public RunnableDispatcher getRunnableDispatcher() {
        return this.getSession();
    }

    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @NonProperty
    public List<SPObject> getChildren() {
        ArrayList<Object> allChildren = new ArrayList<Object>();
        allChildren.addAll(this.sqlTypes);
        allChildren.add(this.rootObject);
        if (this.profileManager != null) {
            allChildren.add(this.profileManager);
        }
        allChildren.add((Object)this.projectSettings);
        allChildren.addAll(this.users);
        allChildren.addAll(this.groups);
        return Collections.unmodifiableList(allChildren);
    }

    @NonBound
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
        this.rootObject.removeDependency(dependency);
        this.profileManager.removeDependency(dependency);
    }

    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof ProfileManager) {
            this.setProfileManager((ProfileManager)child);
        } else if (child instanceof ProjectSettings) {
            this.setProjectSettings((ProjectSettings)child);
        } else if (child instanceof User) {
            this.addUser((User)child, index);
        } else if (child instanceof Group) {
            this.addGroup((Group)child, index);
        } else if (child instanceof UserDefinedSQLType) {
            this.addSQLType((UserDefinedSQLType)child, index);
        } else {
            throw new IllegalArgumentException("Cannot add child of type " + child.getClass() + " to the project once it has been created.");
        }
    }

    public void addSQLType(UserDefinedSQLType sqlType, int index) {
        this.sqlTypes.add(index, sqlType);
        sqlType.setParent((SPObject)this);
        this.fireChildAdded(UserDefinedSQLType.class, (SPObject)sqlType, index);
    }

    @NonProperty
    public List<UserDefinedSQLType> getSqlTypes() {
        return Collections.unmodifiableList(this.sqlTypes);
    }

    public void addUser(User user, int index) {
        this.users.add(index, user);
        user.setParent((SPObject)this);
        this.fireChildAdded(User.class, (SPObject)user, index);
    }

    protected List<User> getUsers() {
        return Collections.unmodifiableList(this.users);
    }

    public void addGroup(Group group, int index) {
        this.groups.add(index, group);
        group.setParent((SPObject)this);
        this.fireChildAdded(Group.class, (SPObject)group, index);
    }

    protected List<Group> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @NonProperty
    public void setProjectSettings(ProjectSettings settings) {
        ProjectSettings oldSettings = this.projectSettings;
        this.projectSettings = settings;
        if (oldSettings != null) {
            this.fireChildRemoved(((Object)((Object)oldSettings)).getClass(), (SPObject)oldSettings, 0);
        }
        this.fireChildAdded(((Object)((Object)settings)).getClass(), (SPObject)settings, 0);
        settings.setParent((SPObject)this);
    }

    @NonProperty
    public ProjectSettings getProjectSettings() {
        return this.projectSettings;
    }

    @Accessor(isInteresting=true)
    public String getEtlProcessDescription() {
        return this.etlProcessDescription;
    }

    @Mutator
    public void setEtlProcessDescription(String etlProcessDescription) {
        String oldDescription = this.etlProcessDescription;
        this.etlProcessDescription = etlProcessDescription;
        this.firePropertyChange("etlProcessDescription", oldDescription, etlProcessDescription);
    }
}

