/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.JadxArgs;

public class StringUtils {
    private final boolean escapeUnicode;

    public StringUtils(JadxArgs args) {
        this.escapeUnicode = args.isEscapeUnicode();
    }

    public String unescapeString(String str) {
        int len = str.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder res = new StringBuilder();
        res.append('\"');
        for (int i = 0; i < len; ++i) {
            int c = str.charAt(i) & 0xFFFF;
            this.processChar(c, res);
        }
        res.append('\"');
        return res.toString();
    }

    public String unescapeChar(char ch) {
        if (ch == '\'') {
            return "'\\''";
        }
        StringBuilder res = new StringBuilder();
        res.append('\'');
        this.processChar(ch, res);
        res.append('\'');
        return res.toString();
    }

    private void processChar(int c, StringBuilder res) {
        switch (c) {
            case 10: {
                res.append("\\n");
                break;
            }
            case 13: {
                res.append("\\r");
                break;
            }
            case 9: {
                res.append("\\t");
                break;
            }
            case 8: {
                res.append("\\b");
                break;
            }
            case 12: {
                res.append("\\f");
                break;
            }
            case 39: {
                res.append('\'');
                break;
            }
            case 34: {
                res.append("\\\"");
                break;
            }
            case 92: {
                res.append("\\\\");
                break;
            }
            default: {
                if (c < 32 || c >= 127 && this.escapeUnicode) {
                    res.append("\\u").append(String.format("%04x", c));
                    break;
                }
                res.append((char)c);
            }
        }
    }

    public static String escape(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': 
                case '$': 
                case ',': 
                case '.': 
                case '/': 
                case ';': 
                case '<': {
                    sb.append('_');
                    continue block5;
                }
                case '[': {
                    sb.append('A');
                    continue block5;
                }
                case '*': 
                case '>': 
                case '?': 
                case ']': {
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeXML(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String replace = StringUtils.escapeXmlChar(c);
            if (replace != null) {
                sb.append(replace);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeResValue(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            StringUtils.commonEscapeAndAppend(sb, c);
        }
        return sb.toString();
    }

    public static String escapeResStrValue(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        block4: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block4;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block4;
                }
                default: {
                    StringUtils.commonEscapeAndAppend(sb, c);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeXmlChar(char c) {
        if (c >= '\u0000' && c <= '\u001f') {
            return "\\" + c;
        }
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    private static String escapeWhiteSpaceChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
        }
        return null;
    }

    private static void commonEscapeAndAppend(StringBuilder sb, char c) {
        String replace = StringUtils.escapeXmlChar(c);
        if (replace == null) {
            replace = StringUtils.escapeWhiteSpaceChar(c);
        }
        if (replace != null) {
            sb.append(replace);
        } else {
            sb.append(c);
        }
    }

    public static boolean notEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static int countMatches(String str, String subStr) {
        if (str == null || str.isEmpty() || subStr == null || subStr.isEmpty()) {
            return 0;
        }
        int subStrLen = subStr.length();
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(subStr, idx)) != -1) {
            ++count;
            idx += subStrLen;
        }
        return count;
    }
}

