/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.Jdk;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;
import org.eclipse.jdt.internal.compiler.util.RuntimeIOException;

public class JRTUtil {
    public static final boolean DISABLE_CACHE = Boolean.getBoolean("org.eclipse.jdt.disable_JRT_cache");
    public static final boolean PROPAGATE_IO_ERRORS = Boolean.getBoolean("org.eclipse.jdt.propagate_io_errors");
    public static final String JAVA_BASE = "java.base".intern();
    public static final char[] JAVA_BASE_CHAR = JAVA_BASE.toCharArray();
    static final String MODULES_SUBDIR = "/modules";
    static final String[] DEFAULT_MODULE = new String[]{JAVA_BASE};
    static final String[] NO_MODULE = new String[0];
    static final String MULTIPLE = "MU";
    static final String DEFAULT_PACKAGE = "";
    static String MODULE_TO_LOAD;
    public static final String JRT_FS_JAR = "jrt-fs.jar";
    static URI JRT_URI;
    public static final int NOTIFY_FILES = 1;
    public static final int NOTIFY_PACKAGES = 2;
    public static final int NOTIFY_MODULES = 4;
    public static final int NOTIFY_ALL = 7;
    private static Map<String, JrtFileSystem> images;
    private static final Map<Path, CtSym> ctSymFiles;

    static {
        JRT_URI = URI.create("jrt:/");
        images = new ConcurrentHashMap<String, JrtFileSystem>();
        ctSymFiles = new ConcurrentHashMap<Path, CtSym>();
    }

    public static JrtFileSystem getJrtSystem(File image) {
        return JRTUtil.getJrtSystem(image, null);
    }

    public static JrtFileSystem getJrtSystem(File image, String release) {
        Jdk jdk;
        String key = image.toString();
        try {
            jdk = new Jdk(image);
        }
        catch (IOException e) {
            String errorMessage = "Error: failed to create JrtFileSystem from " + image;
            if (PROPAGATE_IO_ERRORS) {
                throw new IllegalStateException(errorMessage, e);
            }
            System.err.println(errorMessage);
            e.printStackTrace();
            return null;
        }
        if (release != null && !jdk.sameRelease(release)) {
            key = String.valueOf(key) + "|" + release;
        }
        JrtFileSystem system = images.computeIfAbsent(key, x -> {
            try {
                return JrtFileSystem.getNewJrtFileSystem(jdk, release);
            }
            catch (IOException e) {
                String errorMessage = "Error: failed to create JrtFileSystem from " + image;
                if (PROPAGATE_IO_ERRORS) {
                    throw new IllegalStateException(errorMessage, e);
                }
                System.err.println(errorMessage);
                e.printStackTrace();
                return null;
            }
        });
        return system;
    }

    public static FileSystem getJarFileSystem(Path path) throws IOException {
        URI uri = URI.create("jar:file:" + path.toUri().getRawPath());
        try {
            try {
                return FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException fileSystemNotFoundException) {
                try {
                    return FileSystems.newFileSystem(uri, Map.of(), ClassLoader.getSystemClassLoader());
                }
                catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                    return FileSystems.getFileSystem(uri);
                }
            }
        }
        catch (ProviderNotFoundException e) {
            throw new IOException("No provider for uri " + uri, e);
        }
    }

    public static CtSym getCtSym(Path jdkHome) throws IOException {
        CtSym ctSym;
        try {
            ctSym = ctSymFiles.compute(jdkHome, (x, current) -> {
                if (current == null || !current.getFs().isOpen()) {
                    try {
                        return new CtSym((Path)x);
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e);
                    }
                }
                return current;
            });
        }
        catch (RuntimeIOException rio) {
            throw rio.getCause();
        }
        return ctSym;
    }

    public static void reset() {
        images.clear();
        MODULE_TO_LOAD = System.getProperty("modules.to.load");
    }

    public static void walkModuleImage(File image, JrtFileVisitor<Path> visitor, int notify) throws IOException {
        JRTUtil.getJrtSystem(image, null).walkModuleImage(visitor, notify);
    }

    public static void walkModuleImage(File image, String release, JrtFileVisitor<Path> visitor, int notify) throws IOException {
        JRTUtil.getJrtSystem(image, release).walkModuleImage(visitor, notify);
    }

    public static InputStream getContentFromJrt(File jrt, String fileName, String module) throws IOException {
        return JRTUtil.getJrtSystem(jrt).getContentFromJrt(fileName, module);
    }

    public static byte[] getClassfileContent(File jrt, String fileName, String module) throws IOException {
        return JRTUtil.getJrtSystem(jrt).getClassfileContent(fileName, module);
    }

    public static ClassFileReader getClassfile(File jrt, String fileName, IModule module) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(jrt).getClassfile(fileName, module);
    }

    public static ClassFileReader getClassfile(File jrt, String fileName, String module, Predicate<String> moduleNameFilter) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(jrt).getClassfile(fileName, module, moduleNameFilter);
    }

    public static List<String> getModulesDeclaringPackage(File jrt, String qName, String moduleName) {
        return JRTUtil.getJrtSystem(jrt).getModulesDeclaringPackage(qName, moduleName);
    }

    public static boolean hasCompilationUnit(File jrt, String qualifiedPackageName, String moduleName) {
        return JRTUtil.getJrtSystem(jrt).hasClassFile(qualifiedPackageName, moduleName);
    }

    public static String sanitizedFileName(Path path) {
        String p = path.getFileName().toString();
        if (p.length() > 1 && p.charAt(p.length() - 1) == '/') {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public static byte[] safeReadBytes(Path path) throws IOException {
        try {
            return Files.readAllBytes(path);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            try {
                return Files.readAllBytes(path);
            }
            catch (NoSuchFileException noSuchFileException) {
                return null;
            }
            catch (ClosedByInterruptException e2) {
                if (PROPAGATE_IO_ERRORS) {
                    throw e2;
                }
                return null;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    public static String getJdkRelease(File image) {
        JrtFileSystem jrt = JRTUtil.getJrtSystem(image);
        return jrt == null ? null : jrt.getJdkRelease();
    }

    public static abstract class AbstractFileVisitor<T>
    implements FileVisitor<T> {
        @Override
        public FileVisitResult preVisitDirectory(T dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(T file, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(T file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(T dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    public static interface JrtFileVisitor<T> {
        default public FileVisitResult visitPackage(T dir, T mod, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        default public FileVisitResult visitFile(T file, T mod, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        default public FileVisitResult visitModule(T path, String name) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

