# This file was automatically generated by bifcl from packet_analysis.bif.

export {
module PacketAnalyzer;




## Add an entry to parent's dispatcher that maps a protocol/index to a next-stage child analyzer.
##
## parent: The parent analyzer being modified
## identifier: The identifier for the protocol being registered
## child: The analyzer that will be called for the identifier
##
global register_packet_analyzer: function(parent: PacketAnalyzer::Tag , identifier: count , child: PacketAnalyzer::Tag ): bool ;


## Attempts to add an entry to `parent`'s dispatcher that maps a protocol/index to a next-stage `child`
## analyzer. This may fail if either of the two names does not respond to a known analyzer.
##
## parent: The parent analyzer being modified
## identifier: The identifier for the protocol being registered
## child: The analyzer that will be called for the identifier
##
global try_register_packet_analyzer_by_name: function(parent: string , identifier: count , child: string ): bool ;


## Internal function that is used to update the core-mirror of the script-level `ignore_checksums_nets` variable.
global PacketAnalyzer::__set_ignore_checksums_nets: function(v: subnet_set ) : bool ;


## Registers a child analyzer with a parent analyzer to perform packet detection when determining whether
## to forward from parent to child.
##
## parent: The parent analyzer being modified
## child: The analyzer that will use protocol detection
global register_protocol_detection: function(parent: PacketAnalyzer::Tag , child: PacketAnalyzer::Tag ): bool ;

} # end of export section
module GLOBAL;
