/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.jvm.toolchain.internal.JavaInstallationProbe;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.ToolchainToolFactory;

public class JavaToolchainFactory {
    private final JavaInstallationProbe probeService;
    private final JavaCompilerFactory compilerFactory;
    private final ToolchainToolFactory toolFactory;
    private final FileFactory fileFactory;

    @Inject
    public JavaToolchainFactory(JavaInstallationProbe probeService, JavaCompilerFactory compilerFactory, ToolchainToolFactory toolFactory, FileFactory fileFactory) {
        this.probeService = probeService;
        this.compilerFactory = compilerFactory;
        this.toolFactory = toolFactory;
        this.fileFactory = fileFactory;
    }

    public JavaToolchain newInstance(File javaHome) {
        JavaInstallationProbe.ProbeResult probeResult = this.probeService.checkJdk(javaHome);
        return new JavaToolchain(probeResult, this.compilerFactory, this.toolFactory, this.fileFactory);
    }
}

