/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import java.lang.reflect.Type;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TimeZoneSerializerAdapter
implements JsonSerializer<TimeZone> {
    @NotNull
    private final SentryOptions options;

    public TimeZoneSerializerAdapter(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Override
    @Nullable
    public JsonElement serialize(@Nullable TimeZone src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        try {
            return src == null ? null : new JsonPrimitive(src.getID());
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when serializing TimeZone", e);
            return null;
        }
    }
}

