"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = exports.isConfigSchema = exports.ValidationError = exports.SchemaTypeError = exports.ByteSizeValue = exports.Type = exports.ObjectType = void 0;
const references_1 = require("./references");
const types_1 = require("./types");
Object.defineProperty(exports, "ObjectType", { enumerable: true, get: function () { return types_1.ObjectType; } });
Object.defineProperty(exports, "Type", { enumerable: true, get: function () { return types_1.Type; } });
var byte_size_value_1 = require("./byte_size_value");
Object.defineProperty(exports, "ByteSizeValue", { enumerable: true, get: function () { return byte_size_value_1.ByteSizeValue; } });
var errors_1 = require("./errors");
Object.defineProperty(exports, "SchemaTypeError", { enumerable: true, get: function () { return errors_1.SchemaTypeError; } });
Object.defineProperty(exports, "ValidationError", { enumerable: true, get: function () { return errors_1.ValidationError; } });
var typeguards_1 = require("./typeguards");
Object.defineProperty(exports, "isConfigSchema", { enumerable: true, get: function () { return typeguards_1.isConfigSchema; } });
function any(options) {
    return new types_1.AnyType(options);
}
function boolean(options) {
    return new types_1.BooleanType(options);
}
function buffer(options) {
    return new types_1.BufferType(options);
}
function stream(options) {
    return new types_1.StreamType(options);
}
function string(options) {
    return new types_1.StringType(options);
}
function uri(options) {
    return new types_1.URIType(options);
}
function literal(value) {
    return new types_1.LiteralType(value);
}
function number(options) {
    return new types_1.NumberType(options);
}
function byteSize(options) {
    return new types_1.ByteSizeType(options);
}
function duration(options) {
    return new types_1.DurationType(options);
}
function never() {
    return new types_1.NeverType();
}
function ip(options) {
    return new types_1.IpType(options);
}
/**
 * Create an optional type
 */
function maybe(type) {
    return new types_1.MaybeType(type);
}
function nullable(type) {
    return exports.schema.oneOf([type, exports.schema.literal(null)], { defaultValue: null });
}
function object(props, options) {
    return new types_1.ObjectType(props, options);
}
function arrayOf(itemType, options) {
    return new types_1.ArrayType(itemType, options);
}
function mapOf(keyType, valueType, options) {
    return new types_1.MapOfType(keyType, valueType, options);
}
function recordOf(keyType, valueType, options) {
    return new types_1.RecordOfType(keyType, valueType, options);
}
function oneOf(types, options) {
    return new types_1.UnionType(types, options);
}
function contextRef(key) {
    return new references_1.ContextReference(key);
}
function siblingRef(key) {
    return new references_1.SiblingReference(key);
}
function conditional(leftOperand, rightOperand, equalType, notEqualType, options) {
    return new types_1.ConditionalType(leftOperand, rightOperand, equalType, notEqualType, options);
}
exports.schema = {
    any,
    arrayOf,
    boolean,
    buffer,
    byteSize,
    conditional,
    contextRef,
    duration,
    ip,
    literal,
    mapOf,
    maybe,
    nullable,
    never,
    number,
    object,
    oneOf,
    recordOf,
    stream,
    siblingRef,
    string,
    uri,
};
