/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiQuaternion")
public class AIQuaternion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    public AIQuaternion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIQuaternion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float w() {
        return AIQuaternion.nw(this.address());
    }

    public float x() {
        return AIQuaternion.nx(this.address());
    }

    public float y() {
        return AIQuaternion.ny(this.address());
    }

    public float z() {
        return AIQuaternion.nz(this.address());
    }

    public AIQuaternion w(float value) {
        AIQuaternion.nw(this.address(), value);
        return this;
    }

    public AIQuaternion x(float value) {
        AIQuaternion.nx(this.address(), value);
        return this;
    }

    public AIQuaternion y(float value) {
        AIQuaternion.ny(this.address(), value);
        return this;
    }

    public AIQuaternion z(float value) {
        AIQuaternion.nz(this.address(), value);
        return this;
    }

    public AIQuaternion set(float w, float x, float y, float z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public AIQuaternion set(AIQuaternion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIQuaternion malloc() {
        return (AIQuaternion)AIQuaternion.wrap(AIQuaternion.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIQuaternion calloc() {
        return (AIQuaternion)AIQuaternion.wrap(AIQuaternion.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIQuaternion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIQuaternion)AIQuaternion.wrap(AIQuaternion.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIQuaternion create(long address) {
        return (AIQuaternion)AIQuaternion.wrap(AIQuaternion.class, (long)address);
    }

    @Nullable
    public static AIQuaternion createSafe(long address) {
        return address == 0L ? null : (AIQuaternion)AIQuaternion.wrap(AIQuaternion.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIQuaternion.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIQuaternion.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIQuaternion.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIQuaternion.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIQuaternion.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIQuaternion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIQuaternion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIQuaternion mallocStack() {
        return AIQuaternion.mallocStack(MemoryStack.stackGet());
    }

    public static AIQuaternion callocStack() {
        return AIQuaternion.callocStack(MemoryStack.stackGet());
    }

    public static AIQuaternion mallocStack(MemoryStack stack) {
        return (AIQuaternion)AIQuaternion.wrap(AIQuaternion.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIQuaternion callocStack(MemoryStack stack) {
        return (AIQuaternion)AIQuaternion.wrap(AIQuaternion.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIQuaternion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIQuaternion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIQuaternion.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIQuaternion.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = AIQuaternion.__struct((Struct.Member[])new Struct.Member[]{AIQuaternion.__member((int)4), AIQuaternion.__member((int)4), AIQuaternion.__member((int)4), AIQuaternion.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIQuaternion, Buffer>
    implements NativeResource {
        private static final AIQuaternion ELEMENT_FACTORY = AIQuaternion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIQuaternion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float w() {
            return AIQuaternion.nw(this.address());
        }

        public float x() {
            return AIQuaternion.nx(this.address());
        }

        public float y() {
            return AIQuaternion.ny(this.address());
        }

        public float z() {
            return AIQuaternion.nz(this.address());
        }

        public Buffer w(float value) {
            AIQuaternion.nw(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            AIQuaternion.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            AIQuaternion.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            AIQuaternion.nz(this.address(), value);
            return this;
        }
    }
}

