/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkObjectTableEntryNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;

    public VkObjectTableEntryNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkObjectTableEntryNVX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkObjectEntryTypeNVX")
    public int type() {
        return VkObjectTableEntryNVX.ntype(this.address());
    }

    @NativeType(value="VkObjectEntryUsageFlagsNVX")
    public int flags() {
        return VkObjectTableEntryNVX.nflags(this.address());
    }

    public VkObjectTableEntryNVX type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
        VkObjectTableEntryNVX.ntype(this.address(), value);
        return this;
    }

    public VkObjectTableEntryNVX flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
        VkObjectTableEntryNVX.nflags(this.address(), value);
        return this;
    }

    public VkObjectTableEntryNVX set(int type, int flags) {
        this.type(type);
        this.flags(flags);
        return this;
    }

    public VkObjectTableEntryNVX set(VkObjectTableEntryNVX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkObjectTableEntryNVX malloc() {
        return (VkObjectTableEntryNVX)VkObjectTableEntryNVX.wrap(VkObjectTableEntryNVX.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkObjectTableEntryNVX calloc() {
        return (VkObjectTableEntryNVX)VkObjectTableEntryNVX.wrap(VkObjectTableEntryNVX.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkObjectTableEntryNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkObjectTableEntryNVX)VkObjectTableEntryNVX.wrap(VkObjectTableEntryNVX.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkObjectTableEntryNVX create(long address) {
        return (VkObjectTableEntryNVX)VkObjectTableEntryNVX.wrap(VkObjectTableEntryNVX.class, (long)address);
    }

    @Nullable
    public static VkObjectTableEntryNVX createSafe(long address) {
        return address == 0L ? null : (VkObjectTableEntryNVX)VkObjectTableEntryNVX.wrap(VkObjectTableEntryNVX.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkObjectTableEntryNVX.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkObjectTableEntryNVX.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkObjectTableEntryNVX.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkObjectTableEntryNVX.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkObjectTableEntryNVX.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkObjectTableEntryNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkObjectTableEntryNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkObjectTableEntryNVX mallocStack() {
        return VkObjectTableEntryNVX.mallocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableEntryNVX callocStack() {
        return VkObjectTableEntryNVX.callocStack(MemoryStack.stackGet());
    }

    public static VkObjectTableEntryNVX mallocStack(MemoryStack stack) {
        return (VkObjectTableEntryNVX)VkObjectTableEntryNVX.wrap(VkObjectTableEntryNVX.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkObjectTableEntryNVX callocStack(MemoryStack stack) {
        return (VkObjectTableEntryNVX)VkObjectTableEntryNVX.wrap(VkObjectTableEntryNVX.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkObjectTableEntryNVX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkObjectTableEntryNVX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkObjectTableEntryNVX.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkObjectTableEntryNVX.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkObjectTableEntryNVX.__struct((Struct.Member[])new Struct.Member[]{VkObjectTableEntryNVX.__member((int)4), VkObjectTableEntryNVX.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkObjectTableEntryNVX, Buffer>
    implements NativeResource {
        private static final VkObjectTableEntryNVX ELEMENT_FACTORY = VkObjectTableEntryNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkObjectTableEntryNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkObjectEntryTypeNVX")
        public int type() {
            return VkObjectTableEntryNVX.ntype(this.address());
        }

        @NativeType(value="VkObjectEntryUsageFlagsNVX")
        public int flags() {
            return VkObjectTableEntryNVX.nflags(this.address());
        }

        public Buffer type(@NativeType(value="VkObjectEntryTypeNVX") int value) {
            VkObjectTableEntryNVX.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkObjectEntryUsageFlagsNVX") int value) {
            VkObjectTableEntryNVX.nflags(this.address(), value);
            return this;
        }
    }
}

