/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3DynamicsInfo")
public class B3DynamicsInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_MASS;
    public static final int M_LOCALINERTIALDIAGONAL;
    public static final int M_LOCALINERTIALFRAME;
    public static final int M_LATERALFRICTIONCOEFF;
    public static final int M_ROLLINGFRICTIONCOEFF;
    public static final int M_SPINNINGFRICTIONCOEFF;
    public static final int M_RESTITUTION;
    public static final int M_CONTACTSTIFFNESS;
    public static final int M_CONTACTDAMPING;
    public static final int M_ACTIVATIONSTATE;
    public static final int M_ANGULARDAMPING;
    public static final int M_LINEARDAMPING;
    public static final int M_CCDSWEPTSPHERERADIUS;
    public static final int M_CONTACTPROCESSINGTHRESHOLD;
    public static final int M_FRICTIONANCHOR;

    public B3DynamicsInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3DynamicsInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double m_mass() {
        return B3DynamicsInfo.nm_mass(this.address());
    }

    @NativeType(value="double[3]")
    public DoubleBuffer m_localInertialDiagonal() {
        return B3DynamicsInfo.nm_localInertialDiagonal(this.address());
    }

    public double m_localInertialDiagonal(int index) {
        return B3DynamicsInfo.nm_localInertialDiagonal(this.address(), index);
    }

    @NativeType(value="double[7]")
    public DoubleBuffer m_localInertialFrame() {
        return B3DynamicsInfo.nm_localInertialFrame(this.address());
    }

    public double m_localInertialFrame(int index) {
        return B3DynamicsInfo.nm_localInertialFrame(this.address(), index);
    }

    public double m_lateralFrictionCoeff() {
        return B3DynamicsInfo.nm_lateralFrictionCoeff(this.address());
    }

    public double m_rollingFrictionCoeff() {
        return B3DynamicsInfo.nm_rollingFrictionCoeff(this.address());
    }

    public double m_spinningFrictionCoeff() {
        return B3DynamicsInfo.nm_spinningFrictionCoeff(this.address());
    }

    public double m_restitution() {
        return B3DynamicsInfo.nm_restitution(this.address());
    }

    public double m_contactStiffness() {
        return B3DynamicsInfo.nm_contactStiffness(this.address());
    }

    public double m_contactDamping() {
        return B3DynamicsInfo.nm_contactDamping(this.address());
    }

    public int m_activationState() {
        return B3DynamicsInfo.nm_activationState(this.address());
    }

    public double m_angularDamping() {
        return B3DynamicsInfo.nm_angularDamping(this.address());
    }

    public double m_linearDamping() {
        return B3DynamicsInfo.nm_linearDamping(this.address());
    }

    public double m_ccdSweptSphereRadius() {
        return B3DynamicsInfo.nm_ccdSweptSphereRadius(this.address());
    }

    public double m_contactProcessingThreshold() {
        return B3DynamicsInfo.nm_contactProcessingThreshold(this.address());
    }

    public int m_frictionAnchor() {
        return B3DynamicsInfo.nm_frictionAnchor(this.address());
    }

    public B3DynamicsInfo m_mass(double value) {
        B3DynamicsInfo.nm_mass(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_localInertialDiagonal(@NativeType(value="double[3]") DoubleBuffer value) {
        B3DynamicsInfo.nm_localInertialDiagonal(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_localInertialDiagonal(int index, double value) {
        B3DynamicsInfo.nm_localInertialDiagonal(this.address(), index, value);
        return this;
    }

    public B3DynamicsInfo m_localInertialFrame(@NativeType(value="double[7]") DoubleBuffer value) {
        B3DynamicsInfo.nm_localInertialFrame(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_localInertialFrame(int index, double value) {
        B3DynamicsInfo.nm_localInertialFrame(this.address(), index, value);
        return this;
    }

    public B3DynamicsInfo m_lateralFrictionCoeff(double value) {
        B3DynamicsInfo.nm_lateralFrictionCoeff(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_rollingFrictionCoeff(double value) {
        B3DynamicsInfo.nm_rollingFrictionCoeff(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_spinningFrictionCoeff(double value) {
        B3DynamicsInfo.nm_spinningFrictionCoeff(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_restitution(double value) {
        B3DynamicsInfo.nm_restitution(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_contactStiffness(double value) {
        B3DynamicsInfo.nm_contactStiffness(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_contactDamping(double value) {
        B3DynamicsInfo.nm_contactDamping(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_activationState(int value) {
        B3DynamicsInfo.nm_activationState(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_angularDamping(double value) {
        B3DynamicsInfo.nm_angularDamping(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_linearDamping(double value) {
        B3DynamicsInfo.nm_linearDamping(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_ccdSweptSphereRadius(double value) {
        B3DynamicsInfo.nm_ccdSweptSphereRadius(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_contactProcessingThreshold(double value) {
        B3DynamicsInfo.nm_contactProcessingThreshold(this.address(), value);
        return this;
    }

    public B3DynamicsInfo m_frictionAnchor(int value) {
        B3DynamicsInfo.nm_frictionAnchor(this.address(), value);
        return this;
    }

    public B3DynamicsInfo set(double m_mass, DoubleBuffer m_localInertialDiagonal, DoubleBuffer m_localInertialFrame, double m_lateralFrictionCoeff, double m_rollingFrictionCoeff, double m_spinningFrictionCoeff, double m_restitution, double m_contactStiffness, double m_contactDamping, int m_activationState, double m_angularDamping, double m_linearDamping, double m_ccdSweptSphereRadius, double m_contactProcessingThreshold, int m_frictionAnchor) {
        this.m_mass(m_mass);
        this.m_localInertialDiagonal(m_localInertialDiagonal);
        this.m_localInertialFrame(m_localInertialFrame);
        this.m_lateralFrictionCoeff(m_lateralFrictionCoeff);
        this.m_rollingFrictionCoeff(m_rollingFrictionCoeff);
        this.m_spinningFrictionCoeff(m_spinningFrictionCoeff);
        this.m_restitution(m_restitution);
        this.m_contactStiffness(m_contactStiffness);
        this.m_contactDamping(m_contactDamping);
        this.m_activationState(m_activationState);
        this.m_angularDamping(m_angularDamping);
        this.m_linearDamping(m_linearDamping);
        this.m_ccdSweptSphereRadius(m_ccdSweptSphereRadius);
        this.m_contactProcessingThreshold(m_contactProcessingThreshold);
        this.m_frictionAnchor(m_frictionAnchor);
        return this;
    }

    public B3DynamicsInfo set(B3DynamicsInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3DynamicsInfo malloc() {
        return (B3DynamicsInfo)B3DynamicsInfo.wrap(B3DynamicsInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3DynamicsInfo calloc() {
        return (B3DynamicsInfo)B3DynamicsInfo.wrap(B3DynamicsInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3DynamicsInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3DynamicsInfo)B3DynamicsInfo.wrap(B3DynamicsInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3DynamicsInfo create(long address) {
        return (B3DynamicsInfo)B3DynamicsInfo.wrap(B3DynamicsInfo.class, (long)address);
    }

    @Nullable
    public static B3DynamicsInfo createSafe(long address) {
        return address == 0L ? null : (B3DynamicsInfo)B3DynamicsInfo.wrap(B3DynamicsInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3DynamicsInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3DynamicsInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3DynamicsInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3DynamicsInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3DynamicsInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3DynamicsInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3DynamicsInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3DynamicsInfo mallocStack() {
        return B3DynamicsInfo.mallocStack(MemoryStack.stackGet());
    }

    public static B3DynamicsInfo callocStack() {
        return B3DynamicsInfo.callocStack(MemoryStack.stackGet());
    }

    public static B3DynamicsInfo mallocStack(MemoryStack stack) {
        return (B3DynamicsInfo)B3DynamicsInfo.wrap(B3DynamicsInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3DynamicsInfo callocStack(MemoryStack stack) {
        return (B3DynamicsInfo)B3DynamicsInfo.wrap(B3DynamicsInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3DynamicsInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3DynamicsInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3DynamicsInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3DynamicsInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static double nm_mass(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_MASS);
    }

    public static DoubleBuffer nm_localInertialDiagonal(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_LOCALINERTIALDIAGONAL), (int)3);
    }

    public static double nm_localInertialDiagonal(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_LOCALINERTIALDIAGONAL + Checks.check((int)index, (int)3) * 8L);
    }

    public static DoubleBuffer nm_localInertialFrame(long struct) {
        return MemoryUtil.memDoubleBuffer((long)(struct + (long)M_LOCALINERTIALFRAME), (int)7);
    }

    public static double nm_localInertialFrame(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)M_LOCALINERTIALFRAME + Checks.check((int)index, (int)7) * 8L);
    }

    public static double nm_lateralFrictionCoeff(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_LATERALFRICTIONCOEFF);
    }

    public static double nm_rollingFrictionCoeff(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_ROLLINGFRICTIONCOEFF);
    }

    public static double nm_spinningFrictionCoeff(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_SPINNINGFRICTIONCOEFF);
    }

    public static double nm_restitution(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_RESTITUTION);
    }

    public static double nm_contactStiffness(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_CONTACTSTIFFNESS);
    }

    public static double nm_contactDamping(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_CONTACTDAMPING);
    }

    public static int nm_activationState(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_ACTIVATIONSTATE);
    }

    public static double nm_angularDamping(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_ANGULARDAMPING);
    }

    public static double nm_linearDamping(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_LINEARDAMPING);
    }

    public static double nm_ccdSweptSphereRadius(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_CCDSWEPTSPHERERADIUS);
    }

    public static double nm_contactProcessingThreshold(long struct) {
        return UNSAFE.getDouble(null, struct + (long)M_CONTACTPROCESSINGTHRESHOLD);
    }

    public static int nm_frictionAnchor(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_FRICTIONANCHOR);
    }

    public static void nm_mass(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_MASS, value);
    }

    public static void nm_localInertialDiagonal(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_LOCALINERTIALDIAGONAL), (long)(value.remaining() * 8));
    }

    public static void nm_localInertialDiagonal(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_LOCALINERTIALDIAGONAL + Checks.check((int)index, (int)3) * 8L, value);
    }

    public static void nm_localInertialFrame(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((DoubleBuffer)value), (long)(struct + (long)M_LOCALINERTIALFRAME), (long)(value.remaining() * 8));
    }

    public static void nm_localInertialFrame(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)M_LOCALINERTIALFRAME + Checks.check((int)index, (int)7) * 8L, value);
    }

    public static void nm_lateralFrictionCoeff(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_LATERALFRICTIONCOEFF, value);
    }

    public static void nm_rollingFrictionCoeff(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_ROLLINGFRICTIONCOEFF, value);
    }

    public static void nm_spinningFrictionCoeff(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_SPINNINGFRICTIONCOEFF, value);
    }

    public static void nm_restitution(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_RESTITUTION, value);
    }

    public static void nm_contactStiffness(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_CONTACTSTIFFNESS, value);
    }

    public static void nm_contactDamping(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_CONTACTDAMPING, value);
    }

    public static void nm_activationState(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_ACTIVATIONSTATE, value);
    }

    public static void nm_angularDamping(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_ANGULARDAMPING, value);
    }

    public static void nm_linearDamping(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_LINEARDAMPING, value);
    }

    public static void nm_ccdSweptSphereRadius(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_CCDSWEPTSPHERERADIUS, value);
    }

    public static void nm_contactProcessingThreshold(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)M_CONTACTPROCESSINGTHRESHOLD, value);
    }

    public static void nm_frictionAnchor(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_FRICTIONANCHOR, value);
    }

    static {
        Struct.Layout layout = B3DynamicsInfo.__struct((Struct.Member[])new Struct.Member[]{B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__array((int)8, (int)3), B3DynamicsInfo.__array((int)8, (int)7), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)4), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)8), B3DynamicsInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_MASS = layout.offsetof(0);
        M_LOCALINERTIALDIAGONAL = layout.offsetof(1);
        M_LOCALINERTIALFRAME = layout.offsetof(2);
        M_LATERALFRICTIONCOEFF = layout.offsetof(3);
        M_ROLLINGFRICTIONCOEFF = layout.offsetof(4);
        M_SPINNINGFRICTIONCOEFF = layout.offsetof(5);
        M_RESTITUTION = layout.offsetof(6);
        M_CONTACTSTIFFNESS = layout.offsetof(7);
        M_CONTACTDAMPING = layout.offsetof(8);
        M_ACTIVATIONSTATE = layout.offsetof(9);
        M_ANGULARDAMPING = layout.offsetof(10);
        M_LINEARDAMPING = layout.offsetof(11);
        M_CCDSWEPTSPHERERADIUS = layout.offsetof(12);
        M_CONTACTPROCESSINGTHRESHOLD = layout.offsetof(13);
        M_FRICTIONANCHOR = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<B3DynamicsInfo, Buffer>
    implements NativeResource {
        private static final B3DynamicsInfo ELEMENT_FACTORY = B3DynamicsInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3DynamicsInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double m_mass() {
            return B3DynamicsInfo.nm_mass(this.address());
        }

        @NativeType(value="double[3]")
        public DoubleBuffer m_localInertialDiagonal() {
            return B3DynamicsInfo.nm_localInertialDiagonal(this.address());
        }

        public double m_localInertialDiagonal(int index) {
            return B3DynamicsInfo.nm_localInertialDiagonal(this.address(), index);
        }

        @NativeType(value="double[7]")
        public DoubleBuffer m_localInertialFrame() {
            return B3DynamicsInfo.nm_localInertialFrame(this.address());
        }

        public double m_localInertialFrame(int index) {
            return B3DynamicsInfo.nm_localInertialFrame(this.address(), index);
        }

        public double m_lateralFrictionCoeff() {
            return B3DynamicsInfo.nm_lateralFrictionCoeff(this.address());
        }

        public double m_rollingFrictionCoeff() {
            return B3DynamicsInfo.nm_rollingFrictionCoeff(this.address());
        }

        public double m_spinningFrictionCoeff() {
            return B3DynamicsInfo.nm_spinningFrictionCoeff(this.address());
        }

        public double m_restitution() {
            return B3DynamicsInfo.nm_restitution(this.address());
        }

        public double m_contactStiffness() {
            return B3DynamicsInfo.nm_contactStiffness(this.address());
        }

        public double m_contactDamping() {
            return B3DynamicsInfo.nm_contactDamping(this.address());
        }

        public int m_activationState() {
            return B3DynamicsInfo.nm_activationState(this.address());
        }

        public double m_angularDamping() {
            return B3DynamicsInfo.nm_angularDamping(this.address());
        }

        public double m_linearDamping() {
            return B3DynamicsInfo.nm_linearDamping(this.address());
        }

        public double m_ccdSweptSphereRadius() {
            return B3DynamicsInfo.nm_ccdSweptSphereRadius(this.address());
        }

        public double m_contactProcessingThreshold() {
            return B3DynamicsInfo.nm_contactProcessingThreshold(this.address());
        }

        public int m_frictionAnchor() {
            return B3DynamicsInfo.nm_frictionAnchor(this.address());
        }

        public Buffer m_mass(double value) {
            B3DynamicsInfo.nm_mass(this.address(), value);
            return this;
        }

        public Buffer m_localInertialDiagonal(@NativeType(value="double[3]") DoubleBuffer value) {
            B3DynamicsInfo.nm_localInertialDiagonal(this.address(), value);
            return this;
        }

        public Buffer m_localInertialDiagonal(int index, double value) {
            B3DynamicsInfo.nm_localInertialDiagonal(this.address(), index, value);
            return this;
        }

        public Buffer m_localInertialFrame(@NativeType(value="double[7]") DoubleBuffer value) {
            B3DynamicsInfo.nm_localInertialFrame(this.address(), value);
            return this;
        }

        public Buffer m_localInertialFrame(int index, double value) {
            B3DynamicsInfo.nm_localInertialFrame(this.address(), index, value);
            return this;
        }

        public Buffer m_lateralFrictionCoeff(double value) {
            B3DynamicsInfo.nm_lateralFrictionCoeff(this.address(), value);
            return this;
        }

        public Buffer m_rollingFrictionCoeff(double value) {
            B3DynamicsInfo.nm_rollingFrictionCoeff(this.address(), value);
            return this;
        }

        public Buffer m_spinningFrictionCoeff(double value) {
            B3DynamicsInfo.nm_spinningFrictionCoeff(this.address(), value);
            return this;
        }

        public Buffer m_restitution(double value) {
            B3DynamicsInfo.nm_restitution(this.address(), value);
            return this;
        }

        public Buffer m_contactStiffness(double value) {
            B3DynamicsInfo.nm_contactStiffness(this.address(), value);
            return this;
        }

        public Buffer m_contactDamping(double value) {
            B3DynamicsInfo.nm_contactDamping(this.address(), value);
            return this;
        }

        public Buffer m_activationState(int value) {
            B3DynamicsInfo.nm_activationState(this.address(), value);
            return this;
        }

        public Buffer m_angularDamping(double value) {
            B3DynamicsInfo.nm_angularDamping(this.address(), value);
            return this;
        }

        public Buffer m_linearDamping(double value) {
            B3DynamicsInfo.nm_linearDamping(this.address(), value);
            return this;
        }

        public Buffer m_ccdSweptSphereRadius(double value) {
            B3DynamicsInfo.nm_ccdSweptSphereRadius(this.address(), value);
            return this;
        }

        public Buffer m_contactProcessingThreshold(double value) {
            B3DynamicsInfo.nm_contactProcessingThreshold(this.address(), value);
            return this;
        }

        public Buffer m_frictionAnchor(int value) {
            B3DynamicsInfo.nm_frictionAnchor(this.address(), value);
            return this;
        }
    }
}

