"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDslRoute = registerDslRoute;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerDslRoute({
  router,
  facet
}) {
  router.post({
    path: `${_shared.DSL_BASE}${_shared.DSL_SEARCH}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index: index,
      size,
      body: rest
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_CAT}`,
    validate: {
      query: _configSchema.schema.object({
        format: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('cat.indices', request.query);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_MAPPING}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.getMapping', {
        index: request.query.index
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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