"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEventAnalyticsRouter = void 0;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const registerEventAnalyticsRouter = ({
  router,
  savedObjectFacet
}) => {
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}`,
    validate: {}
  }, async (context, req, res) => {
    var _savedRes$data, _savedRes$data2;

    const savedRes = await savedObjectFacet.getSavedObject(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data = savedRes.data) === null || _savedRes$data === void 0 ? void 0 : _savedRes$data.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data2 = savedRes.data) === null || _savedRes$data2 === void 0 ? void 0 : _savedRes$data2.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectId}`,
    validate: {
      params: _configSchema.schema.object({
        objectId: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data3, _savedRes$data4;

    const savedRes = await savedObjectFacet.getSavedObjectById(req, req.params.objectId);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data3 = savedRes.data) === null || _savedRes$data3 === void 0 ? void 0 : _savedRes$data3.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data4 = savedRes.data) === null || _savedRes$data4 === void 0 ? void 0 : _savedRes$data4.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data5;

    const savedRes = await savedObjectFacet.createSavedQuery(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data5 = savedRes.data) === null || _savedRes$data5 === void 0 ? void 0 : _savedRes$data5.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          user_configs: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data6;

    const savedRes = await savedObjectFacet.createSavedVisualization(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data6 = savedRes.data) === null || _savedRes$data6 === void 0 ? void 0 : _savedRes$data6.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data7;

    const savedRes = await savedObjectFacet.updateSavedQuery(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data7 = savedRes.data) === null || _savedRes$data7 === void 0 ? void 0 : _savedRes$data7.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          user_configs: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _updateRes$data;

    const updateRes = await savedObjectFacet.updateSavedVisualization(req);
    const result = {
      body: { ...updateRes.data
      }
    };
    if (updateRes.success) return res.ok(result);
    result.statusCode = (updateRes === null || updateRes === void 0 ? void 0 : (_updateRes$data = updateRes.data) === null || _updateRes$data === void 0 ? void 0 : _updateRes$data.statusCode) || 500;
    result.message = (updateRes === null || updateRes === void 0 ? void 0 : updateRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        index: _configSchema.schema.string(),
        type: _configSchema.schema.string(),
        dsl_type: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data8;

    const savedRes = await savedObjectFacet.createSavedTimestamp(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data8 = savedRes.data) === null || _savedRes$data8 === void 0 ? void 0 : _savedRes$data8.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        objectId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.object({
          name: _configSchema.schema.string(),
          index: _configSchema.schema.string(),
          type: _configSchema.schema.string(),
          dsl_type: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data9;

    const savedRes = await savedObjectFacet.updateSavedTimestamp(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data9 = savedRes.data) === null || _savedRes$data9 === void 0 ? void 0 : _savedRes$data9.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.delete({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectIdList}`,
    validate: {
      params: _configSchema.schema.object({
        objectIdList: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _deleteResponse$data;

    const deleteResponse = await savedObjectFacet.deleteSavedObject(req);
    const result = {
      body: { ...deleteResponse.data
      }
    };
    if (deleteResponse.success) return res.ok(result);
    result.statusCode = (deleteResponse === null || deleteResponse === void 0 ? void 0 : (_deleteResponse$data = deleteResponse.data) === null || _deleteResponse$data === void 0 ? void 0 : _deleteResponse$data.statusCode) || 500;
    result.message = (deleteResponse === null || deleteResponse === void 0 ? void 0 : deleteResponse.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/addSampleSavedObjects/{sampleRequestor}`,
    validate: {
      params: _configSchema.schema.object({
        sampleRequestor: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data10;

    const savedRes = await savedObjectFacet.createSampleSavedObjects(req);
    const result = {
      body: { ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 ? void 0 : (_savedRes$data10 = savedRes.data) === null || _savedRes$data10 === void 0 ? void 0 : _savedRes$data10.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
};

exports.registerEventAnalyticsRouter = registerEventAnalyticsRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImV2ZW50X2FuYWx5dGljc19yb3V0ZXIudHMiXSwibmFtZXMiOlsicmVnaXN0ZXJFdmVudEFuYWx5dGljc1JvdXRlciIsInJvdXRlciIsInNhdmVkT2JqZWN0RmFjZXQiLCJnZXQiLCJwYXRoIiwiT0JTRVJWQUJJTElUWV9CQVNFIiwiRVZFTlRfQU5BTFlUSUNTIiwiU0FWRURfT0JKRUNUUyIsInZhbGlkYXRlIiwiY29udGV4dCIsInJlcSIsInJlcyIsInNhdmVkUmVzIiwiZ2V0U2F2ZWRPYmplY3QiLCJyZXN1bHQiLCJib2R5IiwiZGF0YSIsInN1Y2Nlc3MiLCJzdGF0dXNDb2RlIiwib2siLCJtZXNzYWdlIiwiY3VzdG9tIiwicGFyYW1zIiwic2NoZW1hIiwib2JqZWN0Iiwib2JqZWN0SWQiLCJzdHJpbmciLCJnZXRTYXZlZE9iamVjdEJ5SWQiLCJwb3N0IiwiU0FWRURfUVVFUlkiLCJxdWVyeSIsInNlbGVjdGVkX2RhdGVfcmFuZ2UiLCJzdGFydCIsImVuZCIsInRleHQiLCJzZWxlY3RlZF90aW1lc3RhbXAiLCJuYW1lIiwidHlwZSIsInNlbGVjdGVkX2ZpZWxkcyIsInRva2VucyIsImFycmF5T2YiLCJ1bmtub3ducyIsImRlc2NyaXB0aW9uIiwiY3JlYXRlU2F2ZWRRdWVyeSIsIlNBVkVEX1ZJU1VBTElaQVRJT04iLCJhcHBsaWNhdGlvbl9pZCIsIm1heWJlIiwidXNlcl9jb25maWdzIiwiY3JlYXRlU2F2ZWRWaXN1YWxpemF0aW9uIiwicHV0Iiwib2JqZWN0X2lkIiwidXBkYXRlU2F2ZWRRdWVyeSIsInVwZGF0ZVJlcyIsInVwZGF0ZVNhdmVkVmlzdWFsaXphdGlvbiIsImluZGV4IiwiZHNsX3R5cGUiLCJjcmVhdGVTYXZlZFRpbWVzdGFtcCIsInRpbWVzdGFtcCIsInVwZGF0ZVNhdmVkVGltZXN0YW1wIiwiZGVsZXRlIiwib2JqZWN0SWRMaXN0IiwiZGVsZXRlUmVzcG9uc2UiLCJkZWxldGVTYXZlZE9iamVjdCIsInNhbXBsZVJlcXVlc3RvciIsImNyZWF0ZVNhbXBsZVNhdmVkT2JqZWN0cyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQU1BOztBQVhBO0FBQ0E7QUFDQTtBQUNBO0FBaUJPLE1BQU1BLDRCQUE0QixHQUFHLENBQUM7QUFDM0NDLEVBQUFBLE1BRDJDO0FBRTNDQyxFQUFBQTtBQUYyQyxDQUFELEtBTXRDO0FBRUpELEVBQUFBLE1BQU0sQ0FBQ0UsR0FBUCxDQUNFO0FBQ0VDLElBQUFBLElBQUksRUFBRyxHQUFFQywwQkFBbUIsR0FBRUMsdUJBQWdCLEdBQUVDLHFCQUFjLEVBRGhFO0FBRUVDLElBQUFBLFFBQVEsRUFBRTtBQUZaLEdBREYsRUFLRSxPQUFPQyxPQUFQLEVBQWdCQyxHQUFoQixFQUFxQkMsR0FBckIsS0FBMEY7QUFBQTs7QUFDeEYsVUFBTUMsUUFBUSxHQUFHLE1BQU1WLGdCQUFnQixDQUFDVyxjQUFqQixDQUFnQ0gsR0FBaEMsQ0FBdkI7QUFDQSxVQUFNSSxNQUFXLEdBQUc7QUFDbEJDLE1BQUFBLElBQUksRUFBRSxFQUNKLEdBQUdILFFBQVEsQ0FBQ0k7QUFEUjtBQURZLEtBQXBCO0FBTUEsUUFBSUosUUFBUSxDQUFDSyxPQUFULElBQW9CLENBQUFMLFFBQVEsU0FBUixJQUFBQSxRQUFRLFdBQVIsOEJBQUFBLFFBQVEsQ0FBRUksSUFBVixrRUFBZ0JFLFVBQWhCLE1BQStCLEdBQXZELEVBQTRELE9BQU9QLEdBQUcsQ0FBQ1EsRUFBSixDQUFPTCxNQUFQLENBQVA7QUFFNURBLElBQUFBLE1BQU0sQ0FBQ0ksVUFBUCxHQUFvQixDQUFBTixRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLCtCQUFBQSxRQUFRLENBQUVJLElBQVYsb0VBQWdCRSxVQUFoQixLQUE4QixHQUFsRDtBQUNBSixJQUFBQSxNQUFNLENBQUNNLE9BQVAsR0FBaUIsQ0FBQVIsUUFBUSxTQUFSLElBQUFBLFFBQVEsV0FBUixZQUFBQSxRQUFRLENBQUVJLElBQVYsS0FBa0IsRUFBbkM7QUFDQSxXQUFPTCxHQUFHLENBQUNVLE1BQUosQ0FBV1AsTUFBWCxDQUFQO0FBQ0QsR0FsQkg7QUFxQkFiLEVBQUFBLE1BQU0sQ0FBQ0UsR0FBUCxDQUNFO0FBQ0VDLElBQUFBLElBQUksRUFBRyxHQUFFQywwQkFBbUIsR0FBRUMsdUJBQWdCLEdBQUVDLHFCQUFjLGFBRGhFO0FBRUVDLElBQUFBLFFBQVEsRUFBRTtBQUNSYyxNQUFBQSxNQUFNLEVBQUVDLHFCQUFPQyxNQUFQLENBQWM7QUFDcEJDLFFBQUFBLFFBQVEsRUFBRUYscUJBQU9HLE1BQVA7QUFEVSxPQUFkO0FBREE7QUFGWixHQURGLEVBU0UsT0FBT2pCLE9BQVAsRUFBZ0JDLEdBQWhCLEVBQXFCQyxHQUFyQixLQUEwRjtBQUFBOztBQUN4RixVQUFNQyxRQUFRLEdBQUcsTUFBTVYsZ0JBQWdCLENBQUN5QixrQkFBakIsQ0FBb0NqQixHQUFwQyxFQUF5Q0EsR0FBRyxDQUFDWSxNQUFKLENBQVdHLFFBQXBELENBQXZCO0FBQ0EsVUFBTVgsTUFBVyxHQUFHO0FBQ2xCQyxNQUFBQSxJQUFJLEVBQUUsRUFDSixHQUFHSCxRQUFRLENBQUNJO0FBRFI7QUFEWSxLQUFwQjtBQU1BLFFBQUlKLFFBQVEsQ0FBQ0ssT0FBVCxJQUFvQixDQUFBTCxRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLCtCQUFBQSxRQUFRLENBQUVJLElBQVYsb0VBQWdCRSxVQUFoQixNQUErQixHQUF2RCxFQUE0RCxPQUFPUCxHQUFHLENBQUNRLEVBQUosQ0FBT0wsTUFBUCxDQUFQO0FBRTVEQSxJQUFBQSxNQUFNLENBQUNJLFVBQVAsR0FBb0IsQ0FBQU4sUUFBUSxTQUFSLElBQUFBLFFBQVEsV0FBUiwrQkFBQUEsUUFBUSxDQUFFSSxJQUFWLG9FQUFnQkUsVUFBaEIsS0FBOEIsR0FBbEQ7QUFDQUosSUFBQUEsTUFBTSxDQUFDTSxPQUFQLEdBQWlCLENBQUFSLFFBQVEsU0FBUixJQUFBQSxRQUFRLFdBQVIsWUFBQUEsUUFBUSxDQUFFSSxJQUFWLEtBQWtCLEVBQW5DO0FBQ0EsV0FBT0wsR0FBRyxDQUFDVSxNQUFKLENBQVdQLE1BQVgsQ0FBUDtBQUNELEdBdEJIO0FBeUJBYixFQUFBQSxNQUFNLENBQUMyQixJQUFQLENBQ0U7QUFDRXhCLElBQUFBLElBQUksRUFBRyxHQUFFQywwQkFBbUIsR0FBRUMsdUJBQWdCLEdBQUVDLHFCQUFjLEdBQUVzQixtQkFBWSxFQUQ5RTtBQUVFckIsSUFBQUEsUUFBUSxFQUFFO0FBQ1JPLE1BQUFBLElBQUksRUFBRVEscUJBQU9DLE1BQVAsQ0FBYztBQUNsQkEsUUFBQUEsTUFBTSxFQUFFRCxxQkFBT0MsTUFBUCxDQUFjO0FBQ3BCTSxVQUFBQSxLQUFLLEVBQUVQLHFCQUFPRyxNQUFQLEVBRGE7QUFFcEJLLFVBQUFBLG1CQUFtQixFQUFFUixxQkFBT0MsTUFBUCxDQUFjO0FBQ2pDUSxZQUFBQSxLQUFLLEVBQUVULHFCQUFPRyxNQUFQLEVBRDBCO0FBRWpDTyxZQUFBQSxHQUFHLEVBQUVWLHFCQUFPRyxNQUFQLEVBRjRCO0FBR2pDUSxZQUFBQSxJQUFJLEVBQUVYLHFCQUFPRyxNQUFQO0FBSDJCLFdBQWQsQ0FGRDtBQU9wQlMsVUFBQUEsa0JBQWtCLEVBQUVaLHFCQUFPQyxNQUFQLENBQWM7QUFDaENZLFlBQUFBLElBQUksRUFBRWIscUJBQU9HLE1BQVAsRUFEMEI7QUFFaENXLFlBQUFBLElBQUksRUFBRWQscUJBQU9HLE1BQVA7QUFGMEIsV0FBZCxDQVBBO0FBV3BCWSxVQUFBQSxlQUFlLEVBQUVmLHFCQUFPQyxNQUFQLENBQWM7QUFDN0JlLFlBQUFBLE1BQU0sRUFBRWhCLHFCQUFPaUIsT0FBUCxDQUFlakIscUJBQU9DLE1BQVAsQ0FBYyxFQUFkLEVBQWtCO0FBQUVpQixjQUFBQSxRQUFRLEVBQUU7QUFBWixhQUFsQixDQUFmLENBRHFCO0FBRTdCUCxZQUFBQSxJQUFJLEVBQUVYLHFCQUFPRyxNQUFQO0FBRnVCLFdBQWQsQ0FYRztBQWVwQlUsVUFBQUEsSUFBSSxFQUFFYixxQkFBT0csTUFBUCxFQWZjO0FBZ0JwQmdCLFVBQUFBLFdBQVcsRUFBRW5CLHFCQUFPRyxNQUFQO0FBaEJPLFNBQWQ7QUFEVSxPQUFkO0FBREU7QUFGWixHQURGLEVBMEJFLE9BQU9qQixPQUFQLEVBQWdCQyxHQUFoQixFQUFxQkMsR0FBckIsS0FBMEY7QUFBQTs7QUFDeEYsVUFBTUMsUUFBUSxHQUFHLE1BQU1WLGdCQUFnQixDQUFDeUMsZ0JBQWpCLENBQWtDakMsR0FBbEMsQ0FBdkI7QUFDQSxVQUFNSSxNQUFXLEdBQUc7QUFDbEJDLE1BQUFBLElBQUksRUFBRSxFQUNKLEdBQUdILFFBQVEsQ0FBQ0k7QUFEUjtBQURZLEtBQXBCO0FBTUEsUUFBSUosUUFBUSxDQUFDSyxPQUFiLEVBQXNCLE9BQU9OLEdBQUcsQ0FBQ1EsRUFBSixDQUFPTCxNQUFQLENBQVA7QUFFdEJBLElBQUFBLE1BQU0sQ0FBQ0ksVUFBUCxHQUFvQixDQUFBTixRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLCtCQUFBQSxRQUFRLENBQUVJLElBQVYsb0VBQWdCRSxVQUFoQixLQUE4QixHQUFsRDtBQUNBSixJQUFBQSxNQUFNLENBQUNNLE9BQVAsR0FBaUIsQ0FBQVIsUUFBUSxTQUFSLElBQUFBLFFBQVEsV0FBUixZQUFBQSxRQUFRLENBQUVJLElBQVYsS0FBa0IsRUFBbkM7QUFDQSxXQUFPTCxHQUFHLENBQUNVLE1BQUosQ0FBV1AsTUFBWCxDQUFQO0FBQ0QsR0F2Q0g7QUEwQ0FiLEVBQUFBLE1BQU0sQ0FBQzJCLElBQVAsQ0FDRTtBQUNFeEIsSUFBQUEsSUFBSSxFQUFHLEdBQUVDLDBCQUFtQixHQUFFQyx1QkFBZ0IsR0FBRUMscUJBQWMsR0FBRXFDLDJCQUFvQixFQUR0RjtBQUVFcEMsSUFBQUEsUUFBUSxFQUFFO0FBQ1JPLE1BQUFBLElBQUksRUFBRVEscUJBQU9DLE1BQVAsQ0FBYztBQUNsQkEsUUFBQUEsTUFBTSxFQUFFRCxxQkFBT0MsTUFBUCxDQUFjO0FBQ3BCTSxVQUFBQSxLQUFLLEVBQUVQLHFCQUFPRyxNQUFQLEVBRGE7QUFFcEJLLFVBQUFBLG1CQUFtQixFQUFFUixxQkFBT0MsTUFBUCxDQUFjO0FBQ2pDUSxZQUFBQSxLQUFLLEVBQUVULHFCQUFPRyxNQUFQLEVBRDBCO0FBRWpDTyxZQUFBQSxHQUFHLEVBQUVWLHFCQUFPRyxNQUFQLEVBRjRCO0FBR2pDUSxZQUFBQSxJQUFJLEVBQUVYLHFCQUFPRyxNQUFQO0FBSDJCLFdBQWQsQ0FGRDtBQU9wQlMsVUFBQUEsa0JBQWtCLEVBQUVaLHFCQUFPQyxNQUFQLENBQWM7QUFDaENZLFlBQUFBLElBQUksRUFBRWIscUJBQU9HLE1BQVAsRUFEMEI7QUFFaENXLFlBQUFBLElBQUksRUFBRWQscUJBQU9HLE1BQVA7QUFGMEIsV0FBZCxDQVBBO0FBV3BCWSxVQUFBQSxlQUFlLEVBQUVmLHFCQUFPQyxNQUFQLENBQWM7QUFDN0JlLFlBQUFBLE1BQU0sRUFBRWhCLHFCQUFPaUIsT0FBUCxDQUFlakIscUJBQU9DLE1BQVAsQ0FBYyxFQUFkLEVBQWtCO0FBQUVpQixjQUFBQSxRQUFRLEVBQUU7QUFBWixhQUFsQixDQUFmLENBRHFCO0FBRTdCUCxZQUFBQSxJQUFJLEVBQUVYLHFCQUFPRyxNQUFQO0FBRnVCLFdBQWQsQ0FYRztBQWVwQlcsVUFBQUEsSUFBSSxFQUFFZCxxQkFBT0csTUFBUCxFQWZjO0FBZ0JwQlUsVUFBQUEsSUFBSSxFQUFFYixxQkFBT0csTUFBUCxFQWhCYztBQWlCcEJnQixVQUFBQSxXQUFXLEVBQUVuQixxQkFBT0csTUFBUCxFQWpCTztBQWtCcEJtQixVQUFBQSxjQUFjLEVBQUV0QixxQkFBT3VCLEtBQVAsQ0FBYXZCLHFCQUFPRyxNQUFQLEVBQWIsQ0FsQkk7QUFtQnBCcUIsVUFBQUEsWUFBWSxFQUFFeEIscUJBQU9HLE1BQVA7QUFuQk0sU0FBZDtBQURVLE9BQWQ7QUFERTtBQUZaLEdBREYsRUE2QkUsT0FBT2pCLE9BQVAsRUFBZ0JDLEdBQWhCLEVBQXFCQyxHQUFyQixLQUEwRjtBQUFBOztBQUN4RixVQUFNQyxRQUFRLEdBQUcsTUFBTVYsZ0JBQWdCLENBQUM4Qyx3QkFBakIsQ0FBMEN0QyxHQUExQyxDQUF2QjtBQUNBLFVBQU1JLE1BQVcsR0FBRztBQUNsQkMsTUFBQUEsSUFBSSxFQUFFLEVBQ0osR0FBR0gsUUFBUSxDQUFDSTtBQURSO0FBRFksS0FBcEI7QUFNQSxRQUFJSixRQUFRLENBQUNLLE9BQWIsRUFBc0IsT0FBT04sR0FBRyxDQUFDUSxFQUFKLENBQU9MLE1BQVAsQ0FBUDtBQUV0QkEsSUFBQUEsTUFBTSxDQUFDSSxVQUFQLEdBQW9CLENBQUFOLFFBQVEsU0FBUixJQUFBQSxRQUFRLFdBQVIsK0JBQUFBLFFBQVEsQ0FBRUksSUFBVixvRUFBZ0JFLFVBQWhCLEtBQThCLEdBQWxEO0FBQ0FKLElBQUFBLE1BQU0sQ0FBQ00sT0FBUCxHQUFpQixDQUFBUixRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLFlBQUFBLFFBQVEsQ0FBRUksSUFBVixLQUFrQixFQUFuQztBQUNBLFdBQU9MLEdBQUcsQ0FBQ1UsTUFBSixDQUFXUCxNQUFYLENBQVA7QUFDRCxHQTFDSDtBQTZDQWIsRUFBQUEsTUFBTSxDQUFDZ0QsR0FBUCxDQUNFO0FBQ0U3QyxJQUFBQSxJQUFJLEVBQUcsR0FBRUMsMEJBQW1CLEdBQUVDLHVCQUFnQixHQUFFQyxxQkFBYyxHQUFFc0IsbUJBQVksRUFEOUU7QUFFRXJCLElBQUFBLFFBQVEsRUFBRTtBQUNSTyxNQUFBQSxJQUFJLEVBQUVRLHFCQUFPQyxNQUFQLENBQWM7QUFDbEIwQixRQUFBQSxTQUFTLEVBQUUzQixxQkFBT0csTUFBUCxFQURPO0FBRWxCRixRQUFBQSxNQUFNLEVBQUVELHFCQUFPQyxNQUFQLENBQWM7QUFDcEJNLFVBQUFBLEtBQUssRUFBRVAscUJBQU9HLE1BQVAsRUFEYTtBQUVwQkssVUFBQUEsbUJBQW1CLEVBQUVSLHFCQUFPQyxNQUFQLENBQWM7QUFDakNRLFlBQUFBLEtBQUssRUFBRVQscUJBQU9HLE1BQVAsRUFEMEI7QUFFakNPLFlBQUFBLEdBQUcsRUFBRVYscUJBQU9HLE1BQVAsRUFGNEI7QUFHakNRLFlBQUFBLElBQUksRUFBRVgscUJBQU9HLE1BQVA7QUFIMkIsV0FBZCxDQUZEO0FBT3BCUyxVQUFBQSxrQkFBa0IsRUFBRVoscUJBQU9DLE1BQVAsQ0FBYztBQUNoQ1ksWUFBQUEsSUFBSSxFQUFFYixxQkFBT0csTUFBUCxFQUQwQjtBQUVoQ1csWUFBQUEsSUFBSSxFQUFFZCxxQkFBT0csTUFBUDtBQUYwQixXQUFkLENBUEE7QUFXcEJZLFVBQUFBLGVBQWUsRUFBRWYscUJBQU9DLE1BQVAsQ0FBYztBQUM3QmUsWUFBQUEsTUFBTSxFQUFFaEIscUJBQU9pQixPQUFQLENBQWVqQixxQkFBT0MsTUFBUCxDQUFjLEVBQWQsRUFBa0I7QUFBRWlCLGNBQUFBLFFBQVEsRUFBRTtBQUFaLGFBQWxCLENBQWYsQ0FEcUI7QUFFN0JQLFlBQUFBLElBQUksRUFBRVgscUJBQU9HLE1BQVA7QUFGdUIsV0FBZCxDQVhHO0FBZXBCVSxVQUFBQSxJQUFJLEVBQUViLHFCQUFPRyxNQUFQLEVBZmM7QUFnQnBCZ0IsVUFBQUEsV0FBVyxFQUFFbkIscUJBQU9HLE1BQVA7QUFoQk8sU0FBZDtBQUZVLE9BQWQ7QUFERTtBQUZaLEdBREYsRUEyQkUsT0FBT2pCLE9BQVAsRUFBZ0JDLEdBQWhCLEVBQXFCQyxHQUFyQixLQUEwRjtBQUFBOztBQUN4RixVQUFNQyxRQUFRLEdBQUcsTUFBTVYsZ0JBQWdCLENBQUNpRCxnQkFBakIsQ0FBa0N6QyxHQUFsQyxDQUF2QjtBQUNBLFVBQU1JLE1BQVcsR0FBRztBQUNsQkMsTUFBQUEsSUFBSSxFQUFFLEVBQ0osR0FBR0gsUUFBUSxDQUFDSTtBQURSO0FBRFksS0FBcEI7QUFLQSxRQUFJSixRQUFRLENBQUNLLE9BQWIsRUFBc0IsT0FBT04sR0FBRyxDQUFDUSxFQUFKLENBQU9MLE1BQVAsQ0FBUDtBQUN0QkEsSUFBQUEsTUFBTSxDQUFDSSxVQUFQLEdBQW9CLENBQUFOLFFBQVEsU0FBUixJQUFBQSxRQUFRLFdBQVIsK0JBQUFBLFFBQVEsQ0FBRUksSUFBVixvRUFBZ0JFLFVBQWhCLEtBQThCLEdBQWxEO0FBQ0FKLElBQUFBLE1BQU0sQ0FBQ00sT0FBUCxHQUFpQixDQUFBUixRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLFlBQUFBLFFBQVEsQ0FBRUksSUFBVixLQUFrQixFQUFuQztBQUNBLFdBQU9MLEdBQUcsQ0FBQ1UsTUFBSixDQUFXUCxNQUFYLENBQVA7QUFDRCxHQXRDSDtBQXlDQWIsRUFBQUEsTUFBTSxDQUFDZ0QsR0FBUCxDQUNFO0FBQ0U3QyxJQUFBQSxJQUFJLEVBQUcsR0FBRUMsMEJBQW1CLEdBQUVDLHVCQUFnQixHQUFFQyxxQkFBYyxHQUFFcUMsMkJBQW9CLEVBRHRGO0FBRUVwQyxJQUFBQSxRQUFRLEVBQUU7QUFDUk8sTUFBQUEsSUFBSSxFQUFFUSxxQkFBT0MsTUFBUCxDQUFjO0FBQ2xCMEIsUUFBQUEsU0FBUyxFQUFFM0IscUJBQU9HLE1BQVAsRUFETztBQUVsQkYsUUFBQUEsTUFBTSxFQUFFRCxxQkFBT0MsTUFBUCxDQUFjO0FBQ3BCTSxVQUFBQSxLQUFLLEVBQUVQLHFCQUFPRyxNQUFQLEVBRGE7QUFFcEJLLFVBQUFBLG1CQUFtQixFQUFFUixxQkFBT0MsTUFBUCxDQUFjO0FBQ2pDUSxZQUFBQSxLQUFLLEVBQUVULHFCQUFPRyxNQUFQLEVBRDBCO0FBRWpDTyxZQUFBQSxHQUFHLEVBQUVWLHFCQUFPRyxNQUFQLEVBRjRCO0FBR2pDUSxZQUFBQSxJQUFJLEVBQUVYLHFCQUFPRyxNQUFQO0FBSDJCLFdBQWQsQ0FGRDtBQU9wQlMsVUFBQUEsa0JBQWtCLEVBQUVaLHFCQUFPQyxNQUFQLENBQWM7QUFDaENZLFlBQUFBLElBQUksRUFBRWIscUJBQU9HLE1BQVAsRUFEMEI7QUFFaENXLFlBQUFBLElBQUksRUFBRWQscUJBQU9HLE1BQVA7QUFGMEIsV0FBZCxDQVBBO0FBV3BCWSxVQUFBQSxlQUFlLEVBQUVmLHFCQUFPQyxNQUFQLENBQWM7QUFDN0JlLFlBQUFBLE1BQU0sRUFBRWhCLHFCQUFPaUIsT0FBUCxDQUFlakIscUJBQU9DLE1BQVAsQ0FBYyxFQUFkLEVBQWtCO0FBQUVpQixjQUFBQSxRQUFRLEVBQUU7QUFBWixhQUFsQixDQUFmLENBRHFCO0FBRTdCUCxZQUFBQSxJQUFJLEVBQUVYLHFCQUFPRyxNQUFQO0FBRnVCLFdBQWQsQ0FYRztBQWVwQlcsVUFBQUEsSUFBSSxFQUFFZCxxQkFBT0csTUFBUCxFQWZjO0FBZ0JwQlUsVUFBQUEsSUFBSSxFQUFFYixxQkFBT0csTUFBUCxFQWhCYztBQWlCcEJnQixVQUFBQSxXQUFXLEVBQUVuQixxQkFBT0csTUFBUCxFQWpCTztBQWtCcEJtQixVQUFBQSxjQUFjLEVBQUV0QixxQkFBT3VCLEtBQVAsQ0FBYXZCLHFCQUFPRyxNQUFQLEVBQWIsQ0FsQkk7QUFtQnBCcUIsVUFBQUEsWUFBWSxFQUFFeEIscUJBQU9HLE1BQVA7QUFuQk0sU0FBZDtBQUZVLE9BQWQ7QUFERTtBQUZaLEdBREYsRUE4QkUsT0FBT2pCLE9BQVAsRUFBZ0JDLEdBQWhCLEVBQXFCQyxHQUFyQixLQUEwRjtBQUFBOztBQUN4RixVQUFNeUMsU0FBUyxHQUFHLE1BQU1sRCxnQkFBZ0IsQ0FBQ21ELHdCQUFqQixDQUEwQzNDLEdBQTFDLENBQXhCO0FBQ0EsVUFBTUksTUFBVyxHQUFHO0FBQ2xCQyxNQUFBQSxJQUFJLEVBQUUsRUFDSixHQUFHcUMsU0FBUyxDQUFDcEM7QUFEVDtBQURZLEtBQXBCO0FBS0EsUUFBSW9DLFNBQVMsQ0FBQ25DLE9BQWQsRUFBdUIsT0FBT04sR0FBRyxDQUFDUSxFQUFKLENBQU9MLE1BQVAsQ0FBUDtBQUN2QkEsSUFBQUEsTUFBTSxDQUFDSSxVQUFQLEdBQW9CLENBQUFrQyxTQUFTLFNBQVQsSUFBQUEsU0FBUyxXQUFULCtCQUFBQSxTQUFTLENBQUVwQyxJQUFYLG9FQUFpQkUsVUFBakIsS0FBK0IsR0FBbkQ7QUFDQUosSUFBQUEsTUFBTSxDQUFDTSxPQUFQLEdBQWlCLENBQUFnQyxTQUFTLFNBQVQsSUFBQUEsU0FBUyxXQUFULFlBQUFBLFNBQVMsQ0FBRXBDLElBQVgsS0FBbUIsRUFBcEM7QUFDQSxXQUFPTCxHQUFHLENBQUNVLE1BQUosQ0FBV1AsTUFBWCxDQUFQO0FBQ0QsR0F6Q0g7QUE0Q0FiLEVBQUFBLE1BQU0sQ0FBQzJCLElBQVAsQ0FDRTtBQUNFeEIsSUFBQUEsSUFBSSxFQUFHLEdBQUVDLDBCQUFtQixHQUFFQyx1QkFBZ0IsR0FBRUMscUJBQWMsWUFEaEU7QUFFRUMsSUFBQUEsUUFBUSxFQUFFO0FBQ1JPLE1BQUFBLElBQUksRUFBRVEscUJBQU9DLE1BQVAsQ0FBYztBQUNsQlksUUFBQUEsSUFBSSxFQUFFYixxQkFBT0csTUFBUCxFQURZO0FBRWxCNEIsUUFBQUEsS0FBSyxFQUFFL0IscUJBQU9HLE1BQVAsRUFGVztBQUdsQlcsUUFBQUEsSUFBSSxFQUFFZCxxQkFBT0csTUFBUCxFQUhZO0FBSWxCNkIsUUFBQUEsUUFBUSxFQUFFaEMscUJBQU9HLE1BQVA7QUFKUSxPQUFkO0FBREU7QUFGWixHQURGLEVBWUUsT0FBT2pCLE9BQVAsRUFBZ0JDLEdBQWhCLEVBQXFCQyxHQUFyQixLQUEwRjtBQUFBOztBQUN4RixVQUFNQyxRQUFRLEdBQUcsTUFBTVYsZ0JBQWdCLENBQUNzRCxvQkFBakIsQ0FBc0M5QyxHQUF0QyxDQUF2QjtBQUNBLFVBQU1JLE1BQVcsR0FBRztBQUNsQkMsTUFBQUEsSUFBSSxFQUFFLEVBQ0osR0FBR0gsUUFBUSxDQUFDSTtBQURSO0FBRFksS0FBcEI7QUFNQSxRQUFJSixRQUFRLENBQUNLLE9BQWIsRUFBc0IsT0FBT04sR0FBRyxDQUFDUSxFQUFKLENBQU9MLE1BQVAsQ0FBUDtBQUV0QkEsSUFBQUEsTUFBTSxDQUFDSSxVQUFQLEdBQW9CLENBQUFOLFFBQVEsU0FBUixJQUFBQSxRQUFRLFdBQVIsK0JBQUFBLFFBQVEsQ0FBRUksSUFBVixvRUFBZ0JFLFVBQWhCLEtBQThCLEdBQWxEO0FBQ0FKLElBQUFBLE1BQU0sQ0FBQ00sT0FBUCxHQUFpQixDQUFBUixRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLFlBQUFBLFFBQVEsQ0FBRUksSUFBVixLQUFrQixFQUFuQztBQUNBLFdBQU9MLEdBQUcsQ0FBQ1UsTUFBSixDQUFXUCxNQUFYLENBQVA7QUFDRCxHQXpCSDtBQTRCQWIsRUFBQUEsTUFBTSxDQUFDZ0QsR0FBUCxDQUNFO0FBQ0U3QyxJQUFBQSxJQUFJLEVBQUcsR0FBRUMsMEJBQW1CLEdBQUVDLHVCQUFnQixHQUFFQyxxQkFBYyxZQURoRTtBQUVFQyxJQUFBQSxRQUFRLEVBQUU7QUFDUk8sTUFBQUEsSUFBSSxFQUFFUSxxQkFBT0MsTUFBUCxDQUFjO0FBQ2xCQyxRQUFBQSxRQUFRLEVBQUVGLHFCQUFPRyxNQUFQLEVBRFE7QUFFbEIrQixRQUFBQSxTQUFTLEVBQUVsQyxxQkFBT0MsTUFBUCxDQUFjO0FBQ3ZCWSxVQUFBQSxJQUFJLEVBQUViLHFCQUFPRyxNQUFQLEVBRGlCO0FBRXZCNEIsVUFBQUEsS0FBSyxFQUFFL0IscUJBQU9HLE1BQVAsRUFGZ0I7QUFHdkJXLFVBQUFBLElBQUksRUFBRWQscUJBQU9HLE1BQVAsRUFIaUI7QUFJdkI2QixVQUFBQSxRQUFRLEVBQUVoQyxxQkFBT0csTUFBUDtBQUphLFNBQWQ7QUFGTyxPQUFkO0FBREU7QUFGWixHQURGLEVBZUUsT0FBT2pCLE9BQVAsRUFBZ0JDLEdBQWhCLEVBQXFCQyxHQUFyQixLQUEwRjtBQUFBOztBQUN4RixVQUFNQyxRQUFRLEdBQUcsTUFBTVYsZ0JBQWdCLENBQUN3RCxvQkFBakIsQ0FBc0NoRCxHQUF0QyxDQUF2QjtBQUNBLFVBQU1JLE1BQVcsR0FBRztBQUNsQkMsTUFBQUEsSUFBSSxFQUFFLEVBQ0osR0FBR0gsUUFBUSxDQUFDSTtBQURSO0FBRFksS0FBcEI7QUFNQSxRQUFJSixRQUFRLENBQUNLLE9BQWIsRUFBc0IsT0FBT04sR0FBRyxDQUFDUSxFQUFKLENBQU9MLE1BQVAsQ0FBUDtBQUV0QkEsSUFBQUEsTUFBTSxDQUFDSSxVQUFQLEdBQW9CLENBQUFOLFFBQVEsU0FBUixJQUFBQSxRQUFRLFdBQVIsK0JBQUFBLFFBQVEsQ0FBRUksSUFBVixvRUFBZ0JFLFVBQWhCLEtBQThCLEdBQWxEO0FBQ0FKLElBQUFBLE1BQU0sQ0FBQ00sT0FBUCxHQUFpQixDQUFBUixRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLFlBQUFBLFFBQVEsQ0FBRUksSUFBVixLQUFrQixFQUFuQztBQUNBLFdBQU9MLEdBQUcsQ0FBQ1UsTUFBSixDQUFXUCxNQUFYLENBQVA7QUFDRCxHQTVCSDtBQStCQWIsRUFBQUEsTUFBTSxDQUFDMEQsTUFBUCxDQUNFO0FBQ0V2RCxJQUFBQSxJQUFJLEVBQUcsR0FBRUMsMEJBQW1CLEdBQUVDLHVCQUFnQixHQUFFQyxxQkFBYyxpQkFEaEU7QUFFRUMsSUFBQUEsUUFBUSxFQUFFO0FBQ1JjLE1BQUFBLE1BQU0sRUFBRUMscUJBQU9DLE1BQVAsQ0FBYztBQUNwQm9DLFFBQUFBLFlBQVksRUFBRXJDLHFCQUFPRyxNQUFQO0FBRE0sT0FBZDtBQURBO0FBRlosR0FERixFQVNFLE9BQU9qQixPQUFQLEVBQWdCQyxHQUFoQixFQUFxQkMsR0FBckIsS0FBMEY7QUFBQTs7QUFDeEYsVUFBTWtELGNBQWMsR0FBRyxNQUFNM0QsZ0JBQWdCLENBQUM0RCxpQkFBakIsQ0FBbUNwRCxHQUFuQyxDQUE3QjtBQUNBLFVBQU1JLE1BQVcsR0FBRztBQUNsQkMsTUFBQUEsSUFBSSxFQUFFLEVBQ0osR0FBRzhDLGNBQWMsQ0FBQzdDO0FBRGQ7QUFEWSxLQUFwQjtBQUtBLFFBQUk2QyxjQUFjLENBQUM1QyxPQUFuQixFQUE0QixPQUFPTixHQUFHLENBQUNRLEVBQUosQ0FBT0wsTUFBUCxDQUFQO0FBQzVCQSxJQUFBQSxNQUFNLENBQUNJLFVBQVAsR0FBb0IsQ0FBQTJDLGNBQWMsU0FBZCxJQUFBQSxjQUFjLFdBQWQsb0NBQUFBLGNBQWMsQ0FBRTdDLElBQWhCLDhFQUFzQkUsVUFBdEIsS0FBb0MsR0FBeEQ7QUFDQUosSUFBQUEsTUFBTSxDQUFDTSxPQUFQLEdBQWlCLENBQUF5QyxjQUFjLFNBQWQsSUFBQUEsY0FBYyxXQUFkLFlBQUFBLGNBQWMsQ0FBRTdDLElBQWhCLEtBQXdCLEVBQXpDO0FBQ0EsV0FBT0wsR0FBRyxDQUFDVSxNQUFKLENBQVdQLE1BQVgsQ0FBUDtBQUNELEdBcEJIO0FBdUJBYixFQUFBQSxNQUFNLENBQUNFLEdBQVAsQ0FDRTtBQUNFQyxJQUFBQSxJQUFJLEVBQUcsR0FBRUMsMEJBQW1CLEdBQUVDLHVCQUFnQixHQUFFQyxxQkFBYywwQ0FEaEU7QUFFRUMsSUFBQUEsUUFBUSxFQUFFO0FBQ1JjLE1BQUFBLE1BQU0sRUFBRUMscUJBQU9DLE1BQVAsQ0FBYztBQUNwQnVDLFFBQUFBLGVBQWUsRUFBRXhDLHFCQUFPRyxNQUFQO0FBREcsT0FBZDtBQURBO0FBRlosR0FERixFQVNFLE9BQU9qQixPQUFQLEVBQWdCQyxHQUFoQixFQUFxQkMsR0FBckIsS0FBMEY7QUFBQTs7QUFDeEYsVUFBTUMsUUFBUSxHQUFHLE1BQU1WLGdCQUFnQixDQUFDOEQsd0JBQWpCLENBQTBDdEQsR0FBMUMsQ0FBdkI7QUFDQSxVQUFNSSxNQUFXLEdBQUc7QUFDbEJDLE1BQUFBLElBQUksRUFBRSxFQUNKLEdBQUdILFFBQVEsQ0FBQ0k7QUFEUjtBQURZLEtBQXBCO0FBTUEsUUFBSUosUUFBUSxDQUFDSyxPQUFiLEVBQXNCLE9BQU9OLEdBQUcsQ0FBQ1EsRUFBSixDQUFPTCxNQUFQLENBQVA7QUFFdEJBLElBQUFBLE1BQU0sQ0FBQ0ksVUFBUCxHQUFvQixDQUFBTixRQUFRLFNBQVIsSUFBQUEsUUFBUSxXQUFSLGdDQUFBQSxRQUFRLENBQUVJLElBQVYsc0VBQWdCRSxVQUFoQixLQUE4QixHQUFsRDtBQUNBSixJQUFBQSxNQUFNLENBQUNNLE9BQVAsR0FBaUIsQ0FBQVIsUUFBUSxTQUFSLElBQUFBLFFBQVEsV0FBUixZQUFBQSxRQUFRLENBQUVJLElBQVYsS0FBa0IsRUFBbkM7QUFDQSxXQUFPTCxHQUFHLENBQUNVLE1BQUosQ0FBV1AsTUFBWCxDQUFQO0FBQ0QsR0F0Qkg7QUF3QkQsQ0E1VU0iLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IHNjaGVtYSB9IGZyb20gJ0Bvc2QvY29uZmlnLXNjaGVtYSc7XG5pbXBvcnQge1xuICBJUm91dGVyLFxuICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZSxcbiAgUmVzcG9uc2VFcnJvcixcbn0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCB7XG4gIE9CU0VSVkFCSUxJVFlfQkFTRSxcbiAgRVZFTlRfQU5BTFlUSUNTLFxuICBTQVZFRF9PQkpFQ1RTLFxuICBTQVZFRF9RVUVSWSxcbiAgU0FWRURfVklTVUFMSVpBVElPTixcbn0gZnJvbSAnLi4vLi4vLi4vY29tbW9uL2NvbnN0YW50cy9zaGFyZWQnO1xuaW1wb3J0IFNhdmVkT2JqZWN0RmFjZXQgZnJvbSAnLi4vLi4vc2VydmljZXMvZmFjZXRzL3NhdmVkX29iamVjdHMnO1xuXG5leHBvcnQgY29uc3QgcmVnaXN0ZXJFdmVudEFuYWx5dGljc1JvdXRlciA9ICh7XG4gIHJvdXRlcixcbiAgc2F2ZWRPYmplY3RGYWNldCxcbn06IHtcbiAgcm91dGVyOiBJUm91dGVyO1xuICBzYXZlZE9iamVjdEZhY2V0OiBTYXZlZE9iamVjdEZhY2V0O1xufSkgPT4ge1xuICBcbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtPQlNFUlZBQklMSVRZX0JBU0V9JHtFVkVOVF9BTkFMWVRJQ1N9JHtTQVZFRF9PQkpFQ1RTfWAsXG4gICAgICB2YWxpZGF0ZToge30sXG4gICAgfSxcbiAgICBhc3luYyAoY29udGV4dCwgcmVxLCByZXMpOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCBzYXZlZFJlcyA9IGF3YWl0IHNhdmVkT2JqZWN0RmFjZXQuZ2V0U2F2ZWRPYmplY3QocmVxKTtcbiAgICAgIGNvbnN0IHJlc3VsdDogYW55ID0ge1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgLi4uc2F2ZWRSZXMuZGF0YSxcbiAgICAgICAgfSxcbiAgICAgIH07XG5cbiAgICAgIGlmIChzYXZlZFJlcy5zdWNjZXNzIHx8IHNhdmVkUmVzPy5kYXRhPy5zdGF0dXNDb2RlID09PSA0MDQpIHJldHVybiByZXMub2socmVzdWx0KTtcblxuICAgICAgcmVzdWx0LnN0YXR1c0NvZGUgPSBzYXZlZFJlcz8uZGF0YT8uc3RhdHVzQ29kZSB8fCA1MDA7XG4gICAgICByZXN1bHQubWVzc2FnZSA9IHNhdmVkUmVzPy5kYXRhIHx8ICcnO1xuICAgICAgcmV0dXJuIHJlcy5jdXN0b20ocmVzdWx0KTtcbiAgICB9XG4gICk7XG4gIFxuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6IGAke09CU0VSVkFCSUxJVFlfQkFTRX0ke0VWRU5UX0FOQUxZVElDU30ke1NBVkVEX09CSkVDVFN9L3tvYmplY3RJZH1gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBvYmplY3RJZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoY29udGV4dCwgcmVxLCByZXMpOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCBzYXZlZFJlcyA9IGF3YWl0IHNhdmVkT2JqZWN0RmFjZXQuZ2V0U2F2ZWRPYmplY3RCeUlkKHJlcSwgcmVxLnBhcmFtcy5vYmplY3RJZCk7XG4gICAgICBjb25zdCByZXN1bHQ6IGFueSA9IHtcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIC4uLnNhdmVkUmVzLmRhdGEsXG4gICAgICAgIH0sXG4gICAgICB9O1xuXG4gICAgICBpZiAoc2F2ZWRSZXMuc3VjY2VzcyB8fCBzYXZlZFJlcz8uZGF0YT8uc3RhdHVzQ29kZSA9PT0gNDA0KSByZXR1cm4gcmVzLm9rKHJlc3VsdCk7XG5cbiAgICAgIHJlc3VsdC5zdGF0dXNDb2RlID0gc2F2ZWRSZXM/LmRhdGE/LnN0YXR1c0NvZGUgfHwgNTAwO1xuICAgICAgcmVzdWx0Lm1lc3NhZ2UgPSBzYXZlZFJlcz8uZGF0YSB8fCAnJztcbiAgICAgIHJldHVybiByZXMuY3VzdG9tKHJlc3VsdCk7XG4gICAgfVxuICApO1xuXG4gIHJvdXRlci5wb3N0KFxuICAgIHtcbiAgICAgIHBhdGg6IGAke09CU0VSVkFCSUxJVFlfQkFTRX0ke0VWRU5UX0FOQUxZVElDU30ke1NBVkVEX09CSkVDVFN9JHtTQVZFRF9RVUVSWX1gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgb2JqZWN0OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICAgIHF1ZXJ5OiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICBzZWxlY3RlZF9kYXRlX3JhbmdlOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICAgICAgc3RhcnQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgICAgZW5kOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICAgIHRleHQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgc2VsZWN0ZWRfdGltZXN0YW1wOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICAgICAgbmFtZTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgICB0eXBlOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHNlbGVjdGVkX2ZpZWxkczogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgICAgIHRva2Vuczogc2NoZW1hLmFycmF5T2Yoc2NoZW1hLm9iamVjdCh7fSwgeyB1bmtub3duczogJ2FsbG93JyB9KSksXG4gICAgICAgICAgICAgIHRleHQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgbmFtZTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgZGVzY3JpcHRpb246IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICB9KSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH0sXG4gICAgYXN5bmMgKGNvbnRleHQsIHJlcSwgcmVzKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxhbnkgfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgICAgY29uc3Qgc2F2ZWRSZXMgPSBhd2FpdCBzYXZlZE9iamVjdEZhY2V0LmNyZWF0ZVNhdmVkUXVlcnkocmVxKTtcbiAgICAgIGNvbnN0IHJlc3VsdDogYW55ID0ge1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgLi4uc2F2ZWRSZXMuZGF0YSxcbiAgICAgICAgfSxcbiAgICAgIH07XG5cbiAgICAgIGlmIChzYXZlZFJlcy5zdWNjZXNzKSByZXR1cm4gcmVzLm9rKHJlc3VsdCk7XG5cbiAgICAgIHJlc3VsdC5zdGF0dXNDb2RlID0gc2F2ZWRSZXM/LmRhdGE/LnN0YXR1c0NvZGUgfHwgNTAwO1xuICAgICAgcmVzdWx0Lm1lc3NhZ2UgPSBzYXZlZFJlcz8uZGF0YSB8fCAnJztcbiAgICAgIHJldHVybiByZXMuY3VzdG9tKHJlc3VsdCk7XG4gICAgfVxuICApO1xuXG4gIHJvdXRlci5wb3N0KFxuICAgIHtcbiAgICAgIHBhdGg6IGAke09CU0VSVkFCSUxJVFlfQkFTRX0ke0VWRU5UX0FOQUxZVElDU30ke1NBVkVEX09CSkVDVFN9JHtTQVZFRF9WSVNVQUxJWkFUSU9OfWAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBvYmplY3Q6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgcXVlcnk6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIHNlbGVjdGVkX2RhdGVfcmFuZ2U6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgICBzdGFydDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgICBlbmQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgICAgdGV4dDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBzZWxlY3RlZF90aW1lc3RhbXA6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgICBuYW1lOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICAgIHR5cGU6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgc2VsZWN0ZWRfZmllbGRzOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICAgICAgdG9rZW5zOiBzY2hlbWEuYXJyYXlPZihzY2hlbWEub2JqZWN0KHt9LCB7IHVua25vd25zOiAnYWxsb3cnIH0pKSxcbiAgICAgICAgICAgICAgdGV4dDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB0eXBlOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICBuYW1lOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgYXBwbGljYXRpb25faWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxuICAgICAgICAgICAgdXNlcl9jb25maWdzOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgfSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChjb250ZXh0LCByZXEsIHJlcyk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICAgIGNvbnN0IHNhdmVkUmVzID0gYXdhaXQgc2F2ZWRPYmplY3RGYWNldC5jcmVhdGVTYXZlZFZpc3VhbGl6YXRpb24ocmVxKTtcbiAgICAgIGNvbnN0IHJlc3VsdDogYW55ID0ge1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgLi4uc2F2ZWRSZXMuZGF0YSxcbiAgICAgICAgfSxcbiAgICAgIH07XG5cbiAgICAgIGlmIChzYXZlZFJlcy5zdWNjZXNzKSByZXR1cm4gcmVzLm9rKHJlc3VsdCk7XG5cbiAgICAgIHJlc3VsdC5zdGF0dXNDb2RlID0gc2F2ZWRSZXM/LmRhdGE/LnN0YXR1c0NvZGUgfHwgNTAwO1xuICAgICAgcmVzdWx0Lm1lc3NhZ2UgPSBzYXZlZFJlcz8uZGF0YSB8fCAnJztcbiAgICAgIHJldHVybiByZXMuY3VzdG9tKHJlc3VsdCk7XG4gICAgfVxuICApO1xuXG4gIHJvdXRlci5wdXQoXG4gICAge1xuICAgICAgcGF0aDogYCR7T0JTRVJWQUJJTElUWV9CQVNFfSR7RVZFTlRfQU5BTFlUSUNTfSR7U0FWRURfT0JKRUNUU30ke1NBVkVEX1FVRVJZfWAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBvYmplY3RfaWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICBvYmplY3Q6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgcXVlcnk6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIHNlbGVjdGVkX2RhdGVfcmFuZ2U6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgICBzdGFydDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgICBlbmQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgICAgdGV4dDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBzZWxlY3RlZF90aW1lc3RhbXA6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgICBuYW1lOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICAgIHR5cGU6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgc2VsZWN0ZWRfZmllbGRzOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICAgICAgdG9rZW5zOiBzY2hlbWEuYXJyYXlPZihzY2hlbWEub2JqZWN0KHt9LCB7IHVua25vd25zOiAnYWxsb3cnIH0pKSxcbiAgICAgICAgICAgICAgdGV4dDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBuYW1lOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIH0pLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoY29udGV4dCwgcmVxLCByZXMpOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCBzYXZlZFJlcyA9IGF3YWl0IHNhdmVkT2JqZWN0RmFjZXQudXBkYXRlU2F2ZWRRdWVyeShyZXEpO1xuICAgICAgY29uc3QgcmVzdWx0OiBhbnkgPSB7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAuLi5zYXZlZFJlcy5kYXRhLFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICAgIGlmIChzYXZlZFJlcy5zdWNjZXNzKSByZXR1cm4gcmVzLm9rKHJlc3VsdCk7XG4gICAgICByZXN1bHQuc3RhdHVzQ29kZSA9IHNhdmVkUmVzPy5kYXRhPy5zdGF0dXNDb2RlIHx8IDUwMDtcbiAgICAgIHJlc3VsdC5tZXNzYWdlID0gc2F2ZWRSZXM/LmRhdGEgfHwgJyc7XG4gICAgICByZXR1cm4gcmVzLmN1c3RvbShyZXN1bHQpO1xuICAgIH1cbiAgKTtcblxuICByb3V0ZXIucHV0KFxuICAgIHtcbiAgICAgIHBhdGg6IGAke09CU0VSVkFCSUxJVFlfQkFTRX0ke0VWRU5UX0FOQUxZVElDU30ke1NBVkVEX09CSkVDVFN9JHtTQVZFRF9WSVNVQUxJWkFUSU9OfWAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBvYmplY3RfaWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICBvYmplY3Q6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgcXVlcnk6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIHNlbGVjdGVkX2RhdGVfcmFuZ2U6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgICBzdGFydDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgICBlbmQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgICAgdGV4dDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICBzZWxlY3RlZF90aW1lc3RhbXA6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgICBuYW1lOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICAgIHR5cGU6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgc2VsZWN0ZWRfZmllbGRzOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICAgICAgdG9rZW5zOiBzY2hlbWEuYXJyYXlPZihzY2hlbWEub2JqZWN0KHt9LCB7IHVua25vd25zOiAnYWxsb3cnIH0pKSxcbiAgICAgICAgICAgICAgdGV4dDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB0eXBlOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICBuYW1lOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgICBkZXNjcmlwdGlvbjogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgYXBwbGljYXRpb25faWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxuICAgICAgICAgICAgdXNlcl9jb25maWdzOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgfSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChjb250ZXh0LCByZXEsIHJlcyk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICAgIGNvbnN0IHVwZGF0ZVJlcyA9IGF3YWl0IHNhdmVkT2JqZWN0RmFjZXQudXBkYXRlU2F2ZWRWaXN1YWxpemF0aW9uKHJlcSk7XG4gICAgICBjb25zdCByZXN1bHQ6IGFueSA9IHtcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIC4uLnVwZGF0ZVJlcy5kYXRhLFxuICAgICAgICB9LFxuICAgICAgfTtcbiAgICAgIGlmICh1cGRhdGVSZXMuc3VjY2VzcykgcmV0dXJuIHJlcy5vayhyZXN1bHQpO1xuICAgICAgcmVzdWx0LnN0YXR1c0NvZGUgPSB1cGRhdGVSZXM/LmRhdGE/LnN0YXR1c0NvZGUgfHwgNTAwO1xuICAgICAgcmVzdWx0Lm1lc3NhZ2UgPSB1cGRhdGVSZXM/LmRhdGEgfHwgJyc7XG4gICAgICByZXR1cm4gcmVzLmN1c3RvbShyZXN1bHQpO1xuICAgIH1cbiAgKTtcblxuICByb3V0ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtPQlNFUlZBQklMSVRZX0JBU0V9JHtFVkVOVF9BTkFMWVRJQ1N9JHtTQVZFRF9PQkpFQ1RTfS90aW1lc3RhbXBgLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgbmFtZTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIGluZGV4OiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgdHlwZTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIGRzbF90eXBlOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChjb250ZXh0LCByZXEsIHJlcyk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICAgIGNvbnN0IHNhdmVkUmVzID0gYXdhaXQgc2F2ZWRPYmplY3RGYWNldC5jcmVhdGVTYXZlZFRpbWVzdGFtcChyZXEpO1xuICAgICAgY29uc3QgcmVzdWx0OiBhbnkgPSB7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAuLi5zYXZlZFJlcy5kYXRhLFxuICAgICAgICB9LFxuICAgICAgfTtcblxuICAgICAgaWYgKHNhdmVkUmVzLnN1Y2Nlc3MpIHJldHVybiByZXMub2socmVzdWx0KTtcblxuICAgICAgcmVzdWx0LnN0YXR1c0NvZGUgPSBzYXZlZFJlcz8uZGF0YT8uc3RhdHVzQ29kZSB8fCA1MDA7XG4gICAgICByZXN1bHQubWVzc2FnZSA9IHNhdmVkUmVzPy5kYXRhIHx8ICcnO1xuICAgICAgcmV0dXJuIHJlcy5jdXN0b20ocmVzdWx0KTtcbiAgICB9XG4gICk7XG5cbiAgcm91dGVyLnB1dChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtPQlNFUlZBQklMSVRZX0JBU0V9JHtFVkVOVF9BTkFMWVRJQ1N9JHtTQVZFRF9PQkpFQ1RTfS90aW1lc3RhbXBgLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgYm9keTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgb2JqZWN0SWQ6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICB0aW1lc3RhbXA6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgICAgbmFtZTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgICAgaW5kZXg6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIHR5cGU6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgICAgIGRzbF90eXBlOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgICAgfSksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGFzeW5jIChjb250ZXh0LCByZXEsIHJlcyk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8YW55IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICAgIGNvbnN0IHNhdmVkUmVzID0gYXdhaXQgc2F2ZWRPYmplY3RGYWNldC51cGRhdGVTYXZlZFRpbWVzdGFtcChyZXEpO1xuICAgICAgY29uc3QgcmVzdWx0OiBhbnkgPSB7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAuLi5zYXZlZFJlcy5kYXRhLFxuICAgICAgICB9LFxuICAgICAgfTtcblxuICAgICAgaWYgKHNhdmVkUmVzLnN1Y2Nlc3MpIHJldHVybiByZXMub2socmVzdWx0KTtcblxuICAgICAgcmVzdWx0LnN0YXR1c0NvZGUgPSBzYXZlZFJlcz8uZGF0YT8uc3RhdHVzQ29kZSB8fCA1MDA7XG4gICAgICByZXN1bHQubWVzc2FnZSA9IHNhdmVkUmVzPy5kYXRhIHx8ICcnO1xuICAgICAgcmV0dXJuIHJlcy5jdXN0b20ocmVzdWx0KTtcbiAgICB9XG4gICk7XG5cbiAgcm91dGVyLmRlbGV0ZShcbiAgICB7XG4gICAgICBwYXRoOiBgJHtPQlNFUlZBQklMSVRZX0JBU0V9JHtFVkVOVF9BTkFMWVRJQ1N9JHtTQVZFRF9PQkpFQ1RTfS97b2JqZWN0SWRMaXN0fWAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xuICAgICAgICAgIG9iamVjdElkTGlzdDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoY29udGV4dCwgcmVxLCByZXMpOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCBkZWxldGVSZXNwb25zZSA9IGF3YWl0IHNhdmVkT2JqZWN0RmFjZXQuZGVsZXRlU2F2ZWRPYmplY3QocmVxKTtcbiAgICAgIGNvbnN0IHJlc3VsdDogYW55ID0ge1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgLi4uZGVsZXRlUmVzcG9uc2UuZGF0YSxcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgICBpZiAoZGVsZXRlUmVzcG9uc2Uuc3VjY2VzcykgcmV0dXJuIHJlcy5vayhyZXN1bHQpO1xuICAgICAgcmVzdWx0LnN0YXR1c0NvZGUgPSBkZWxldGVSZXNwb25zZT8uZGF0YT8uc3RhdHVzQ29kZSB8fCA1MDA7XG4gICAgICByZXN1bHQubWVzc2FnZSA9IGRlbGV0ZVJlc3BvbnNlPy5kYXRhIHx8ICcnO1xuICAgICAgcmV0dXJuIHJlcy5jdXN0b20ocmVzdWx0KTtcbiAgICB9XG4gICk7XG5cbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtPQlNFUlZBQklMSVRZX0JBU0V9JHtFVkVOVF9BTkFMWVRJQ1N9JHtTQVZFRF9PQkpFQ1RTfS9hZGRTYW1wbGVTYXZlZE9iamVjdHMve3NhbXBsZVJlcXVlc3Rvcn1gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBzYW1wbGVSZXF1ZXN0b3I6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgfSksXG4gICAgICB9LFxuICAgIH0sXG4gICAgYXN5bmMgKGNvbnRleHQsIHJlcSwgcmVzKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxhbnkgfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgICAgY29uc3Qgc2F2ZWRSZXMgPSBhd2FpdCBzYXZlZE9iamVjdEZhY2V0LmNyZWF0ZVNhbXBsZVNhdmVkT2JqZWN0cyhyZXEpO1xuICAgICAgY29uc3QgcmVzdWx0OiBhbnkgPSB7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAuLi5zYXZlZFJlcy5kYXRhLFxuICAgICAgICB9LFxuICAgICAgfTtcblxuICAgICAgaWYgKHNhdmVkUmVzLnN1Y2Nlc3MpIHJldHVybiByZXMub2socmVzdWx0KTtcblxuICAgICAgcmVzdWx0LnN0YXR1c0NvZGUgPSBzYXZlZFJlcz8uZGF0YT8uc3RhdHVzQ29kZSB8fCA1MDA7XG4gICAgICByZXN1bHQubWVzc2FnZSA9IHNhdmVkUmVzPy5kYXRhIHx8ICcnO1xuICAgICAgcmV0dXJuIHJlcy5jdXN0b20ocmVzdWx0KTtcbiAgICB9XG4gICk7XG59O1xuIl19