/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;

public class ResolvedIndexFieldAccess
extends ResolvedFieldAccess {
    private List<Long> indices;

    public ResolvedIndexFieldAccess(boolean permissive, List<Long> indices) {
        super(permissive);
        this.indices = indices;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (long _index : this.indices) {
            if (in.isArray()) {
                long index;
                long l = index = _index < 0L ? _index + (long)in.size() : _index;
                if (0L <= index && index < (long)in.size()) {
                    out.add(in.get((int)index));
                    continue;
                }
                out.add((JsonNode)NullNode.getInstance());
                continue;
            }
            if (in.isNull()) {
                out.add((JsonNode)NullNode.getInstance());
                continue;
            }
            if (this.permissive) continue;
            throw JsonQueryException.format("Cannot index %s with number", in.getNodeType());
        }
        return out;
    }

    public List<Long> indices() {
        return Collections.unmodifiableList(this.indices);
    }
}

