/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TrustedCaIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.TrustedAuthorityParser;
import java.util.LinkedList;

public class TrustedCaIndicationExtensionParser
extends ExtensionParser<TrustedCaIndicationExtensionMessage> {
    public TrustedCaIndicationExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(TrustedCaIndicationExtensionMessage msg) {
        msg.setTrustedAuthoritiesLength(this.parseIntField(2));
        msg.setTrustedAuthoritiesBytes(this.parseByteArrayField((Integer)msg.getTrustedAuthoritiesLength().getValue()));
        LinkedList<TrustedAuthority> trustedAuthoritiesList = new LinkedList<TrustedAuthority>();
        int position = 0;
        while (position < (Integer)msg.getTrustedAuthoritiesLength().getValue()) {
            TrustedAuthorityParser parser = new TrustedAuthorityParser(position, (byte[])msg.getTrustedAuthoritiesBytes().getValue());
            trustedAuthoritiesList.add(parser.parse());
            if (position == parser.getPointer()) {
                throw new ParserException("Ran into infinite Loop while parsing TrustedAuthorities");
            }
            position = parser.getPointer();
        }
        msg.setTrustedAuthorities(trustedAuthoritiesList);
    }

    @Override
    protected TrustedCaIndicationExtensionMessage createExtensionMessage() {
        return new TrustedCaIndicationExtensionMessage();
    }
}

