/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.BaseProtocol;
import org.traccar.ServerManager;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.session.ConnectionManager;
import org.traccar.session.DeviceSession;
import org.traccar.sms.SmsManager;
import org.traccar.storage.Storage;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class CommandsManager {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Long, Queue<Command>> deviceQueues = new ConcurrentHashMap<Long, Queue<Command>>();
    private final Storage storage;
    private final ServerManager serverManager;
    private final SmsManager smsManager;
    private final ConnectionManager connectionManager;
    private final boolean queueing;

    @Inject
    public CommandsManager(Storage storage, ServerManager serverManager, @Nullable SmsManager smsManager, ConnectionManager connectionManager, Config config) {
        this.storage = storage;
        this.serverManager = serverManager;
        this.smsManager = smsManager;
        this.connectionManager = connectionManager;
        this.queueing = config.getBoolean(Keys.COMMANDS_QUEUEING);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean sendCommand(Command command) throws Exception {
        long deviceId = command.getDeviceId();
        if (command.getTextChannel()) {
            Device device = this.storage.getObject(Device.class, new Request(new Columns.Include("positionId", "phone"), new Condition.Equals("id", "id", deviceId)));
            Position position = this.storage.getObject(Position.class, new Request(new Columns.All(), new Condition.Equals("id", "id", device.getPositionId())));
            if (position != null) {
                BaseProtocol protocol = this.serverManager.getProtocol(position.getProtocol());
                protocol.sendTextCommand(device.getPhone(), command);
                return true;
            }
            if (!command.getType().equals("custom")) throw new RuntimeException("Command " + command.getType() + " is not supported");
            this.smsManager.sendMessage(device.getPhone(), command.getString("data"), true);
            return true;
        }
        DeviceSession deviceSession = this.connectionManager.getDeviceSession(deviceId);
        if (deviceSession != null) {
            if (deviceSession.supportsLiveCommands()) {
                deviceSession.sendCommand(command);
                return true;
            }
            this.getDeviceQueue(deviceId).add(command);
            return false;
        }
        if (!this.queueing) {
            throw new RuntimeException("Device is not online");
        }
        this.getDeviceQueue(deviceId).add(command);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<Command> getDeviceQueue(long deviceId) {
        Queue<Command> deviceQueue;
        try {
            this.lock.readLock().lock();
            deviceQueue = this.deviceQueues.get(deviceId);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (deviceQueue != null) {
            return deviceQueue;
        }
        try {
            this.lock.writeLock().lock();
            Queue queue = this.deviceQueues.computeIfAbsent(deviceId, key -> new ConcurrentLinkedQueue());
            return queue;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Collection<Command> readQueuedCommands(long deviceId) {
        return this.readQueuedCommands(deviceId, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Command> readQueuedCommands(long deviceId, int count) {
        Queue<Command> deviceQueue;
        try {
            this.lock.readLock().lock();
            deviceQueue = this.deviceQueues.get(deviceId);
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<Command> result = new ArrayList<Command>();
        if (deviceQueue != null) {
            Command command = deviceQueue.poll();
            while (command != null && result.size() < count) {
                result.add(command);
                command = deviceQueue.poll();
            }
        }
        return result;
    }
}

