/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class GalileoProtocolDecoder
extends BaseProtocolDecoder {
    private ByteBuf photo;
    private static final Map<Integer, Integer> TAG_LENGTH_MAP = new HashMap<Integer, Integer>();

    public GalileoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static int getTagLength(int tag) {
        Integer length = TAG_LENGTH_MAP.get(tag);
        if (length == null) {
            throw new IllegalArgumentException(String.format("Unknown tag: 0x%02x", tag));
        }
        return length;
    }

    private void sendResponse(Channel channel, int header, int checksum) {
        if (channel != null) {
            ByteBuf reply = Unpooled.buffer((int)3);
            reply.writeByte(header);
            reply.writeShortLE((int)((short)checksum));
            channel.writeAndFlush((Object)new NetworkMessage(reply, channel.remoteAddress()));
        }
    }

    private void decodeTag(Position position, ByteBuf buf, int tag) {
        if (tag >= 80 && tag <= 87) {
            position.set("adc" + (tag - 80), buf.readUnsignedShortLE());
        } else if (tag >= 96 && tag <= 98) {
            position.set("fuel" + (tag - 96), buf.readUnsignedShortLE());
        } else if (tag >= 160 && tag <= 175) {
            position.set("can8BitR" + (tag - 160 + 15), buf.readUnsignedByte());
        } else if (tag >= 176 && tag <= 185) {
            position.set("can16BitR" + (tag - 176 + 5), buf.readUnsignedShortLE());
        } else if (tag >= 196 && tag <= 210) {
            position.set("can8BitR" + (tag - 196), buf.readUnsignedByte());
        } else if (tag >= 214 && tag <= 218) {
            position.set("can16BitR" + (tag - 214), buf.readUnsignedShortLE());
        } else if (tag >= 219 && tag <= 223) {
            position.set("can32BitR" + (tag - 219), buf.readUnsignedIntLE());
        } else if (tag >= 226 && tag <= 233) {
            position.set("userData" + (tag - 226), buf.readUnsignedIntLE());
        } else if (tag >= 240 && tag <= 249) {
            position.set("can32BitR" + (tag - 240 + 5), buf.readUnsignedIntLE());
        } else {
            this.decodeTagOther(position, buf, tag);
        }
    }

    private void decodeTagOther(Position position, ByteBuf buf, int tag) {
        switch (tag) {
            case 1: {
                position.set("versionHw", buf.readUnsignedByte());
                break;
            }
            case 2: {
                position.set("versionFw", buf.readUnsignedByte());
                break;
            }
            case 4: {
                position.set("deviceId", buf.readUnsignedShortLE());
                break;
            }
            case 16: {
                position.set("index", buf.readUnsignedShortLE());
                break;
            }
            case 32: {
                position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                break;
            }
            case 51: {
                position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShortLE() * 0.1));
                position.setCourse((double)buf.readUnsignedShortLE() * 0.1);
                break;
            }
            case 52: {
                position.setAltitude(buf.readShortLE());
                break;
            }
            case 53: {
                position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
                break;
            }
            case 64: {
                position.set("status", buf.readUnsignedShortLE());
                break;
            }
            case 65: {
                position.set("power", (double)buf.readUnsignedShortLE() / 1000.0);
                break;
            }
            case 66: {
                position.set("battery", (double)buf.readUnsignedShortLE() / 1000.0);
                break;
            }
            case 67: {
                position.set("deviceTemp", buf.readByte());
                break;
            }
            case 68: {
                position.set("acceleration", buf.readUnsignedIntLE());
                break;
            }
            case 69: {
                position.set("output", buf.readUnsignedShortLE());
                break;
            }
            case 70: {
                position.set("input", buf.readUnsignedShortLE());
                break;
            }
            case 72: {
                position.set("statusExtended", buf.readUnsignedShortLE());
                break;
            }
            case 88: {
                position.set("rs2320", buf.readUnsignedShortLE());
                break;
            }
            case 89: {
                position.set("rs2321", buf.readUnsignedShortLE());
                break;
            }
            case 144: {
                position.set("driverUniqueId", String.valueOf(buf.readUnsignedIntLE()));
                break;
            }
            case 192: {
                position.set("fuelTotal", (double)buf.readUnsignedIntLE() * 0.5);
                break;
            }
            case 193: {
                position.set("fuel", (double)buf.readUnsignedByte() * 0.4);
                position.set("temp1", buf.readUnsignedByte() - 40);
                position.set("rpm", (double)buf.readUnsignedShortLE() * 0.125);
                break;
            }
            case 194: {
                position.set("canB0", buf.readUnsignedIntLE());
                break;
            }
            case 195: {
                position.set("canB1", buf.readUnsignedIntLE());
                break;
            }
            case 212: {
                position.set("odometer", buf.readUnsignedIntLE());
                break;
            }
            case 224: {
                position.set("index", buf.readUnsignedIntLE());
                break;
            }
            case 225: {
                position.set("result", buf.readSlice((int)buf.readUnsignedByte()).toString(StandardCharsets.US_ASCII));
                break;
            }
            case 234: {
                position.set("userDataArray", ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)buf.readUnsignedByte())));
                break;
            }
            default: {
                buf.skipBytes(GalileoProtocolDecoder.getTagLength(tag));
            }
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short header = buf.readUnsignedByte();
        if (header == 1) {
            if (buf.getUnsignedMedium(buf.readerIndex() + 2) == 65564) {
                return this.decodeIridiumPosition(channel, remoteAddress, buf);
            }
            return this.decodePositions(channel, remoteAddress, buf);
        }
        if (header == 7) {
            return this.decodePhoto(channel, remoteAddress, buf);
        }
        return null;
    }

    private Position decodeIridiumPosition(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        buf.readUnsignedShortLE();
        buf.skipBytes(3);
        buf.readUnsignedIntLE();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readSlice(15).toString(StandardCharsets.US_ASCII));
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedByte();
        buf.skipBytes(4);
        position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
        buf.skipBytes(3);
        short flags = buf.readUnsignedByte();
        double latitude = (double)buf.readUnsignedByte() + (double)buf.readUnsignedShortLE() / 60000.0;
        double longitude = (double)buf.readUnsignedByte() + (double)buf.readUnsignedShortLE() / 60000.0;
        position.setLatitude(BitUtil.check(flags, 1) ? -latitude : latitude);
        position.setLongitude(BitUtil.check(flags, 0) ? -longitude : longitude);
        position.setAccuracy(buf.readUnsignedIntLE());
        return position;
    }

    private List<Position> decodePositions(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        int endIndex = (buf.readUnsignedShortLE() & Short.MAX_VALUE) + buf.readerIndex();
        LinkedList<Position> positions = new LinkedList<Position>();
        HashSet<Integer> tags = new HashSet<Integer>();
        boolean hasLocation = false;
        DeviceSession deviceSession = null;
        Position position = new Position(this.getProtocolName());
        while (buf.readerIndex() < endIndex) {
            short tag = buf.readUnsignedByte();
            if (tags.contains(tag)) {
                if (hasLocation && position.getFixTime() != null) {
                    positions.add(position);
                }
                tags.clear();
                hasLocation = false;
                position = new Position(this.getProtocolName());
            }
            tags.add(Integer.valueOf(tag));
            if (tag == 3) {
                deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readSlice(15).toString(StandardCharsets.US_ASCII));
                continue;
            }
            if (tag == 48) {
                hasLocation = true;
                position.setValid((buf.readUnsignedByte() & 0xF0) == 0);
                position.setLatitude((double)buf.readIntLE() / 1000000.0);
                position.setLongitude((double)buf.readIntLE() / 1000000.0);
                continue;
            }
            this.decodeTag(position, buf, tag);
        }
        if (deviceSession == null && (deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0])) == null) {
            return null;
        }
        if (hasLocation && position.getFixTime() != null) {
            positions.add(position);
        } else if (position.hasAttribute("result")) {
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            positions.add(position);
        }
        this.sendResponse(channel, 2, buf.readUnsignedShortLE());
        for (Position p : positions) {
            p.setDeviceId(deviceSession.getDeviceId());
        }
        return positions.isEmpty() ? null : positions;
    }

    private Object decodePhoto(Channel channel, SocketAddress remoteAddress, ByteBuf buf) throws Exception {
        int length = buf.readUnsignedShortLE();
        Position position = null;
        if (this.photo == null) {
            this.photo = Unpooled.buffer();
        }
        buf.readUnsignedByte();
        if (length > 1) {
            this.photo.writeBytes(buf, length - 1);
        } else {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            position.set("image", this.writeMediaFile(deviceSession.getUniqueId(), this.photo, "jpg"));
            this.photo.release();
            this.photo = null;
        }
        this.sendResponse(channel, 7, buf.readUnsignedShortLE());
        return position;
    }

    static {
        int[] l1 = new int[]{1, 2, 53, 67, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 213, 136, 138, 139, 140, 160, 175, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174};
        int[] l2 = new int[]{4, 16, 52, 64, 65, 66, 69, 70, 84, 85, 86, 87, 88, 89, 96, 97, 98, 112, 113, 114, 115, 116, 117, 118, 119, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 214, 215, 216, 217, 218};
        int[] l3 = new int[]{99, 100, 111, 93, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110};
        int[] l4 = new int[]{32, 51, 68, 144, 192, 194, 195, 211, 212, 219, 220, 221, 222, 223, 240, 249, 90, 71, 241, 242, 243, 244, 245, 246, 247, 248, 226, 233};
        for (int i : l1) {
            TAG_LENGTH_MAP.put(i, 1);
        }
        for (int i : l2) {
            TAG_LENGTH_MAP.put(i, 2);
        }
        for (int i : l3) {
            TAG_LENGTH_MAP.put(i, 3);
        }
        for (int i : l4) {
            TAG_LENGTH_MAP.put(i, 4);
        }
        TAG_LENGTH_MAP.put(91, 7);
        TAG_LENGTH_MAP.put(92, 68);
    }
}

