/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.Transient;
import java.util.Collections;
import java.util.List;

public abstract class SystemSPObjectSnapshot<T extends SPObject>
extends AbstractSPObject
implements SPObjectSnapshot<T> {
    private static final String SYSTEM_WORKSPACE_UUID = "system";
    private final String originalUUID;
    private boolean obsolete;
    private boolean deleted = false;

    @Constructor
    public SystemSPObjectSnapshot(@ConstructorParameter(propertyName="originalUUID") String originalUUID) {
        this.originalUUID = originalUUID;
    }

    @Override
    @Accessor
    public String getOriginalUUID() {
        return this.originalUUID;
    }

    @Override
    @Accessor
    public String getWorkspaceUUID() {
        return SYSTEM_WORKSPACE_UUID;
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        return false;
    }

    @Override
    public boolean allowsChildren() {
        return false;
    }

    @Override
    public int childPositionOffset(Class<? extends SPObject> childType) {
        return 0;
    }

    @Override
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
    }

    @Override
    @Mutator
    public void setObsolete(boolean isObsolete) {
        boolean oldValue = this.obsolete;
        this.obsolete = isObsolete;
        this.firePropertyChange("obsolete", oldValue, isObsolete);
    }

    @Override
    @Accessor
    public boolean isObsolete() {
        return this.obsolete;
    }

    @Override
    @Transient
    @Mutator
    public void setDeleted(boolean isDeleted) {
        boolean oldValue = this.deleted;
        this.deleted = isDeleted;
        this.firePropertyChange("deleted", oldValue, isDeleted);
    }

    @Override
    @Transient
    @Accessor
    public boolean isDeleted() {
        return this.deleted;
    }
}

