/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OLAPTreeModel
implements TreeModel {
    private static final Logger logger = Logger.getLogger(OLAPTreeModel.class);
    private final MondrianModel.Schema schema;
    private final BusinessModelEventHandler modelEventHandler = new BusinessModelEventHandler();
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
    private final List<Class<? extends MondrianModel.ExpressionView>> hiddenClasses = Arrays.asList(MondrianModel.ExpressionView.class, MondrianModel.CaptionExpression.class, MondrianModel.KeyExpression.class, MondrianModel.MeasureExpression.class, MondrianModel.NameExpression.class, MondrianModel.OrdinalExpression.class, MondrianModel.ParentExpression.class);

    public OLAPTreeModel(MondrianModel.Schema schema) {
        this.schema = schema;
        SQLPowerUtils.listenToHierarchy((SPObject)schema, (SPListener)this.modelEventHandler);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> getChild(" + parent + ", " + index + ")"));
        }
        List children = ((OLAPObject)((Object)parent)).getChildren();
        int i = -1;
        for (SPObject oo : children) {
            if (!this.hiddenClasses.contains(oo.getClass())) {
                ++i;
            }
            if (i != index) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("<<< getChild: " + oo));
            }
            return oo;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> getChildCount(" + parent + ")"));
        }
        int childCount = 0;
        List children = ((OLAPObject)((Object)parent)).getChildren();
        for (SPObject oo : children) {
            if (this.hiddenClasses.contains(oo.getClass())) continue;
            ++childCount;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<<< getChildCount: " + childCount));
        }
        return childCount;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> getIndexOfChild(" + parent + ", " + child + ")"));
        }
        int index = -1;
        List children = ((OLAPObject)((Object)parent)).getChildren();
        for (SPObject oo : children) {
            if (!this.hiddenClasses.contains(oo.getClass())) {
                ++index;
            }
            if (oo != child) continue;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<<< getIndexOfChild: " + index));
        }
        return index;
    }

    public MondrianModel.Schema getRoot() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)">>> getRoot()");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<<< getRoot: " + (Object)((Object)this.schema)));
        }
        return this.schema;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean retval;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> isLeaf(" + node + ")"));
        }
        boolean bl = retval = !((OLAPObject)((Object)node)).allowsChildren();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<<< isLeaf: " + retval));
        }
        return retval;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> addTreeModelListener(" + l + ")"));
        }
        this.treeModelListeners.add(l);
        logger.debug((Object)"<<< addTreeModelListener");
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeTreeModelListener(" + l + ")"));
        }
        this.treeModelListeners.remove(l);
        logger.debug((Object)"<<< removeTreeModelListener");
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("model doesn't support editting yet");
    }

    private void fireTreeNodeChanged(OLAPObject node) {
        TreeModelEvent e;
        if (node == this.getRoot()) {
            e = new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, null, null);
        } else {
            SPObject parent = node.getParent();
            int indexOfChild = this.getIndexOfChild(parent, (Object)node);
            e = new TreeModelEvent((Object)this, this.pathToNode(parent), new int[]{indexOfChild}, new Object[]{node});
        }
        for (int i = this.treeModelListeners.size() - 1; i >= 0; --i) {
            this.treeModelListeners.get(i).treeNodesChanged(e);
        }
    }

    private void fireTreeNodeAdded(SPObject parent, int childIndex, SPObject child) {
        TreeModelEvent e = new TreeModelEvent((Object)this, this.pathToNode(parent), new int[]{childIndex}, new Object[]{child});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Firing tree node added: " + e));
        }
        for (int i = this.treeModelListeners.size() - 1; i >= 0; --i) {
            this.treeModelListeners.get(i).treeNodesInserted(e);
        }
    }

    private void fireTreeNodeRemoved(SPObject parent, int childIndex, SPObject child) {
        TreeModelEvent e = new TreeModelEvent((Object)this, this.pathToNode(parent), new int[]{childIndex}, new Object[]{child});
        for (int i = this.treeModelListeners.size() - 1; i >= 0; --i) {
            this.treeModelListeners.get(i).treeNodesRemoved(e);
        }
    }

    private TreePath pathToNode(SPObject o) {
        ArrayList<OLAPObject> path = new ArrayList<OLAPObject>();
        while (o != null) {
            path.add(0, (OLAPObject)o);
            if (o == this.getRoot()) break;
            o = o.getParent();
        }
        return new TreePath(path.toArray());
    }

    private class BusinessModelEventHandler
    implements SPListener {
        private BusinessModelEventHandler() {
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            OLAPTreeModel.this.fireTreeNodeChanged((OLAPObject)((Object)evt.getSource()));
        }

        public void childAdded(SPChildEvent e) {
            OLAPTreeModel.this.fireTreeNodeAdded(e.getSource(), e.getIndex(), e.getChild());
            SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
        }

        public void childRemoved(SPChildEvent e) {
            OLAPTreeModel.this.fireTreeNodeRemoved(e.getSource(), e.getIndex(), e.getChild());
            SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
        }

        public void transactionEnded(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }
    }
}

