/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoInstantiationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class CollectionComponentParameter
implements Parameter,
Serializable {
    public static final CollectionComponentParameter ARRAY = new CollectionComponentParameter();
    public static final CollectionComponentParameter ARRAY_ALLOW_EMPTY = new CollectionComponentParameter(true);
    private final boolean emptyCollection;
    private final Class componentKeyType;
    private final Class componentValueType;

    public CollectionComponentParameter() {
        this(false);
    }

    public CollectionComponentParameter(boolean emptyCollection) {
        this(Void.TYPE, emptyCollection);
    }

    public CollectionComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(Object.class, componentValueType, emptyCollection);
    }

    public CollectionComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this.emptyCollection = emptyCollection;
        this.componentKeyType = componentKeyType;
        this.componentValueType = componentValueType;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoInstantiationException {
        Object result = null;
        Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            Map adapterMap = this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, this.getValueType(expectedType));
            if (Array.class.isAssignableFrom(collectionType)) {
                result = this.getArrayInstance(container, expectedType, adapterMap);
            } else if (Map.class.isAssignableFrom(collectionType)) {
                result = this.getMapInstance(container, expectedType, adapterMap);
            } else if (Collection.class.isAssignableFrom(collectionType)) {
                result = this.getCollectionInstance(container, expectedType, adapterMap);
            } else {
                throw new PicoIntrospectionException(expectedType.getName() + " is not a collective type");
            }
        }
        return result;
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        Class collectionType = this.getCollectionType(expectedType);
        Class valueType = this.getValueType(expectedType);
        return collectionType != null && (this.emptyCollection || this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).size() > 0);
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoIntrospectionException {
        Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            Class valueType = this.getValueType(expectedType);
            Collection componentAdapters = this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).values();
            if (componentAdapters.isEmpty()) {
                if (!this.emptyCollection) {
                    throw new PicoIntrospectionException(expectedType.getName() + " not resolvable, no components of type " + this.getValueType(expectedType).getName() + " available");
                }
            } else {
                Iterator iter = componentAdapters.iterator();
                while (iter.hasNext()) {
                    ComponentAdapter componentAdapter = (ComponentAdapter)iter.next();
                    componentAdapter.verify(container);
                }
            }
        } else {
            throw new PicoIntrospectionException(expectedType.getName() + " is not a collective type");
        }
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    protected boolean evaluate(ComponentAdapter adapter) {
        return adapter != null;
    }

    protected Map getMatchingComponentAdapters(PicoContainer container, ComponentAdapter adapter, Class keyType, Class valueType) {
        HashMap<Object, ComponentAdapter> adapterMap = new HashMap<Object, ComponentAdapter>();
        PicoContainer parent = container.getParent();
        if (parent != null) {
            adapterMap.putAll(this.getMatchingComponentAdapters(parent, adapter, keyType, valueType));
        }
        Collection allAdapters = container.getComponentAdapters();
        Iterator iter = allAdapters.iterator();
        while (iter.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iter.next();
            adapterMap.remove(componentAdapter.getComponentKey());
        }
        List adapterList = container.getComponentAdaptersOfType(valueType);
        Iterator iter2 = adapterList.iterator();
        while (iter2.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iter2.next();
            Object key = componentAdapter.getComponentKey();
            if (adapter != null && key.equals(adapter.getComponentKey()) || !keyType.isAssignableFrom(key.getClass()) || !this.evaluate(componentAdapter)) continue;
            adapterMap.put(key, componentAdapter);
        }
        return adapterMap;
    }

    private Class getCollectionType(Class collectionType) {
        Class collectionClass = null;
        if (collectionType.isArray()) {
            collectionClass = Array.class;
        } else if (Map.class.isAssignableFrom(collectionType)) {
            collectionClass = Map.class;
        } else if (Collection.class.isAssignableFrom(collectionType)) {
            collectionClass = Collection.class;
        }
        return collectionClass;
    }

    private Class getValueType(Class collectionType) {
        Class<?> valueType = this.componentValueType;
        if (collectionType.isArray()) {
            valueType = collectionType.getComponentType();
        }
        return valueType;
    }

    private Object[] getArrayInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Object[] result = (Object[])Array.newInstance(expectedType.getComponentType(), adapterList.size());
        int i = 0;
        Iterator iterator = adapterList.values().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            result[i] = container.getComponentInstance(componentAdapter.getComponentKey());
            ++i;
        }
        return result;
    }

    private Collection getCollectionInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Class collectionType = expectedType;
        if (collectionType.isInterface()) {
            if (List.class.isAssignableFrom(collectionType)) {
                collectionType = ArrayList.class;
            } else if (SortedSet.class.isAssignableFrom(collectionType)) {
                collectionType = TreeSet.class;
            } else if (Set.class.isAssignableFrom(collectionType)) {
                collectionType = HashSet.class;
            } else if (Collection.class.isAssignableFrom(collectionType)) {
                collectionType = ArrayList.class;
            }
        }
        try {
            Collection result = (Collection)collectionType.newInstance();
            Iterator iterator = adapterList.values().iterator();
            while (iterator.hasNext()) {
                ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
                result.add(container.getComponentInstance(componentAdapter.getComponentKey()));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }

    private Map getMapInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Class collectionType = expectedType;
        if (collectionType.isInterface()) {
            if (SortedMap.class.isAssignableFrom(collectionType)) {
                collectionType = TreeMap.class;
            } else if (Map.class.isAssignableFrom(collectionType)) {
                collectionType = HashMap.class;
            }
        }
        try {
            Map result = (Map)collectionType.newInstance();
            Iterator iterator = adapterList.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                ComponentAdapter componentAdapter = (ComponentAdapter)entry.getValue();
                result.put(key, container.getComponentInstance(key));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }
}

