<?php
/**
 * UTF-8 lookup table for upper case accented letters
 *
 * This lookuptable defines replacements for accented characters from the ASCII-7
 * range. This are upper case letters only.
 *
 * @author Andreas Gohr <andi@splitbrain.org>
 * @see    \dokuwiki\Utf8\Clean::deaccent()
 */
return [
    'Á' => 'A',
    'À' => 'A',
    'Ă' => 'A',
    'Â' => 'A',
    'Å' => 'A',
    'Ä' => 'Ae',
    'Ã' => 'A',
    'Ą' => 'A',
    'Ā' => 'A',
    'Æ' => 'Ae',
    'Ḃ' => 'B',
    'Ć' => 'C',
    'Ĉ' => 'C',
    'Č' => 'C',
    'Ċ' => 'C',
    'Ç' => 'C',
    'Ď' => 'D',
    'Ḋ' => 'D',
    'Đ' => 'D',
    'Ð' => 'Dh',
    'É' => 'E',
    'È' => 'E',
    'Ĕ' => 'E',
    'Ê' => 'E',
    'Ě' => 'E',
    'Ë' => 'E',
    'Ė' => 'E',
    'Ę' => 'E',
    'Ē' => 'E',
    'Ḟ' => 'F',
    'Ƒ' => 'F',
    'Ğ' => 'G',
    'Ĝ' => 'G',
    'Ġ' => 'G',
    'Ģ' => 'G',
    'Ĥ' => 'H',
    'Ħ' => 'H',
    'Í' => 'I',
    'Ì' => 'I',
    'Î' => 'I',
    'Ï' => 'I',
    'Ĩ' => 'I',
    'Į' => 'I',
    'Ī' => 'I',
    'Ĵ' => 'J',
    'Ķ' => 'K',
    'Ĺ' => 'L',
    'Ľ' => 'L',
    'Ļ' => 'L',
    'Ł' => 'L',
    'Ṁ' => 'M',
    'Ń' => 'N',
    'Ň' => 'N',
    'Ñ' => 'N',
    'Ņ' => 'N',
    'Ó' => 'O',
    'Ò' => 'O',
    'Ô' => 'O',
    'Ö' => 'Oe',
    'Ő' => 'O',
    'Õ' => 'O',
    'Ø' => 'O',
    'Ō' => 'O',
    'Ơ' => 'O',
    'Ṗ' => 'P',
    'Ŕ' => 'R',
    'Ř' => 'R',
    'Ŗ' => 'R',
    'Ś' => 'S',
    'Ŝ' => 'S',
    'Š' => 'S',
    'Ṡ' => 'S',
    'Ş' => 'S',
    'Ș' => 'S',
    'Ť' => 'T',
    'Ṫ' => 'T',
    'Ţ' => 'T',
    'Ț' => 'T',
    'Ŧ' => 'T',
    'Ú' => 'U',
    'Ù' => 'U',
    'Ŭ' => 'U',
    'Û' => 'U',
    'Ů' => 'U',
    'Ü' => 'Ue',
    'Ű' => 'U',
    'Ũ' => 'U',
    'Ų' => 'U',
    'Ū' => 'U',
    'Ư' => 'U',
    'Ẃ' => 'W',
    'Ẁ' => 'W',
    'Ŵ' => 'W',
    'Ẅ' => 'W',
    'Ý' => 'Y',
    'Ỳ' => 'Y',
    'Ŷ' => 'Y',
    'Ÿ' => 'Y',
    'Ź' => 'Z',
    'Ž' => 'Z',
    'Ż' => 'Z',
    'Þ' => 'Th',
];
