/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable.deprecated;

import ghidra.feature.vt.api.stringable.deprecated.LocalVariableInfo;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;

public class LocalVariableStringable
extends Stringable {
    public static final String SHORT_NAME = "LOCAL";
    private LocalVariableInfo localVariableInfo;

    public LocalVariableStringable() {
        super(SHORT_NAME);
    }

    public LocalVariableStringable(Variable localVariable) {
        super(SHORT_NAME);
        this.localVariableInfo = LocalVariableInfo.createLocalVariableInfo(localVariable);
    }

    @Override
    public String getDisplayString() {
        return this.localVariableInfo.getDataType().getName() + " " + this.localVariableInfo.getName();
    }

    @Override
    protected String doConvertToString(Program program) {
        return this.localVariableInfo.convertToString();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        this.localVariableInfo = LocalVariableInfo.createLocalVariableInfo(string, program);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * (this.localVariableInfo == null ? 0 : this.localVariableInfo.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalVariableStringable other = (LocalVariableStringable)obj;
        return !(this.localVariableInfo == null ? other.localVariableInfo != null : !this.localVariableInfo.equals((Object)other.localVariableInfo));
    }

    public Variable getLocalVariable(Function function, Address destinationStorageAddress) {
        return this.localVariableInfo.createLocalVariable(function, destinationStorageAddress);
    }
}

