/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.analyzers;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.javaclass.analyzers.AbstractJavaAnalyzer;
import ghidra.javaclass.format.JavaClassUtil;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JvmSwitchAnalyzer
extends AbstractJavaAnalyzer {
    private static final String ANALYZER_NAME = "JVM Switch Analyzer";
    private static final String ANALYZER_DESCRIPTION = "Disassembles jump targets of tableswitch  and lookupswitch instructions";
    private static final String LOOKUPSWITCH_MNEMONIC = "lookupswitch";
    private static final String TABLESWITCH_MNEMONIC = "tableswitch";
    private static final String DEFAULT_CASE_LABEL = "default";

    public String getName() {
        return ANALYZER_NAME;
    }

    public AnalyzerType getAnalysisType() {
        return AnalyzerType.INSTRUCTION_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return ANALYZER_DESCRIPTION;
    }

    public AnalysisPriority getPriority() {
        return AnalysisPriority.DISASSEMBLY;
    }

    public boolean canAnalyze(Program program) {
        try {
            return JavaClassUtil.isClassFile(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMaximum(set.getNumAddresses());
        monitor.setProgress(0L);
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
        BinaryReader reader = new BinaryReader((ByteProvider)provider, false);
        Listing listing = program.getListing();
        InstructionIterator instructionIterator = listing.getInstructions(set, true);
        while (instructionIterator.hasNext()) {
            Instruction instruction = instructionIterator.next();
            monitor.checkCanceled();
            monitor.incrementProgress((long)instruction.getLength());
            String mnenomic = instruction.getMnemonicString();
            if (!mnenomic.equals(TABLESWITCH_MNEMONIC) && !mnenomic.equals(LOOKUPSWITCH_MNEMONIC) || instruction.getMnemonicReferences().length > 0) continue;
            monitor.setMessage("JvmSwitchAnalyzer: " + instruction.getMinAddress());
            if (instruction.getMnemonicString().equals(TABLESWITCH_MNEMONIC)) {
                this.processTableSwitch(program, reader, instruction, monitor);
                continue;
            }
            this.processLookupSwitch(program, reader, instruction, monitor);
        }
        return true;
    }

    private void processTableSwitch(Program program, BinaryReader bReader, Instruction instruction, TaskMonitor monitor) {
        Register alignmentPad = program.getRegister("alignmentPad");
        int alignment = instruction.getValue(alignmentPad, false).intValue();
        if (instruction.getOperandReferences(0).length == 0) {
            Msg.info((Object)this, (Object)("Skipping tableswitch instruction at " + instruction.getAddress().toString() + " - missing operand reference for default case."));
            return;
        }
        Object[] opObjects = instruction.getOpObjects(0);
        Address defaultAddress = instruction.getOperandReferences(0)[0].getToAddress();
        long low = ((Scalar)opObjects[1]).getUnsignedValue();
        long high = ((Scalar)opObjects[2]).getUnsignedValue();
        ArrayList<Address> addressesToDisassemble = new ArrayList<Address>();
        addressesToDisassemble.add(defaultAddress);
        this.addLabelAndReference(program, instruction, defaultAddress, DEFAULT_CASE_LABEL);
        long base = instruction.getMemory().getMinAddress().getOffset();
        long index = instruction.getMinAddress().getOffset();
        index -= base;
        bReader.setPointerIndex(index += (long)(1 + alignment + 4 + 4 + 4));
        int i = 0;
        while ((long)i <= high - low) {
            try {
                int offset = bReader.readNextInt();
                Address toDis = instruction.getMinAddress().add((long)offset);
                addressesToDisassemble.add(toDis);
                String label = "case_" + (low + (long)i) + "_(0x" + Long.toHexString(low + (long)i) + ")";
                this.addLabelAndReference(program, instruction, toDis, label);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)e.getMessage());
            }
            ++i;
        }
        this.disassembleCases(program, addressesToDisassemble);
        this.fixupFunction(program, instruction, addressesToDisassemble, monitor);
    }

    private void processLookupSwitch(Program program, BinaryReader bReader, Instruction instruction, TaskMonitor monitor) {
        Register alignmentPad = program.getRegister("alignmentPad");
        int alignment = instruction.getValue(alignmentPad, false).intValue();
        Object[] opObjects = instruction.getOpObjects(0);
        long defaultOffset = ((Scalar)opObjects[0]).getUnsignedValue();
        long numberOfCases = ((Scalar)opObjects[1]).getUnsignedValue();
        ArrayList<Address> addressesToDisassemble = new ArrayList<Address>();
        Address defaultAddress = instruction.getMinAddress().add(defaultOffset);
        addressesToDisassemble.add(defaultAddress);
        this.addLabelAndReference(program, instruction, defaultAddress, DEFAULT_CASE_LABEL);
        long base = instruction.getMemory().getMinAddress().getOffset();
        long index = instruction.getMinAddress().getOffset();
        index -= base;
        bReader.setPointerIndex(index += (long)(1 + alignment + 4 + 4));
        int i = 0;
        while ((long)i < numberOfCases) {
            try {
                int match = bReader.readNextInt();
                int offset = bReader.readNextInt();
                Address toDis = instruction.getMinAddress().add((long)offset);
                addressesToDisassemble.add(toDis);
                String label = "case_" + match + "_(0x" + Integer.toHexString(match) + ")";
                this.addLabelAndReference(program, instruction, toDis, label);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)e.getMessage());
            }
            ++i;
        }
        this.disassembleCases(program, addressesToDisassemble);
        this.fixupFunction(program, instruction, addressesToDisassemble, monitor);
    }

    private void disassembleCases(Program program, List<Address> addressesToDisassemble) {
        for (Address addr : addressesToDisassemble) {
            DisassembleCommand dCommand = new DisassembleCommand(addr, null, true);
            dCommand.applyTo((DomainObject)program);
        }
    }

    private void addLabelAndReference(Program program, Instruction switchInstruction, Address target, String label) {
        program.getReferenceManager().addMemoryReference(switchInstruction.getMinAddress(), target, (RefType)RefType.COMPUTED_JUMP, SourceType.ANALYSIS, -1);
        Namespace space = null;
        String switchName = switchInstruction.getMnemonicString() + "_" + switchInstruction.getAddress().toString();
        try {
            space = program.getSymbolTable().createNameSpace(null, switchName, SourceType.ANALYSIS);
        }
        catch (DuplicateNameException e) {
            space = program.getSymbolTable().getNamespace(switchName, null);
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        try {
            program.getSymbolTable().createLabel(target, label, space, SourceType.ANALYSIS);
        }
        catch (InvalidInputException e1) {
            Msg.error((Object)this, (Object)e1.getMessage());
        }
    }

    private void fixupFunction(Program program, Instruction instruction, List<Address> additions, TaskMonitor monitor) {
        Function func = program.getFunctionManager().getFunctionContaining(instruction.getAddress());
        AddressSet newBody = new AddressSet(func.getBody());
        for (Address addr : additions) {
            newBody.add(addr);
        }
        try {
            func.setBody((AddressSetView)newBody);
        }
        catch (OverlappingFunctionException e) {
            e.printStackTrace();
        }
        try {
            CreateFunctionCmd.fixupFunctionBody((Program)program, (Function)func, (TaskMonitor)monitor);
        }
        catch (CancelledException e) {
            e.printStackTrace();
        }
    }
}

