/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring.util;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.scoring.util.VEPair;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;

public class UniformInOut<V, E>
implements Function<VEPair<V, E>, Double> {
    protected Graph<V, E> graph;

    public UniformInOut(Graph<V, E> graph) {
        this.graph = graph;
    }

    public Double apply(VEPair<V, E> ve_pair) {
        V v = ve_pair.getV();
        E e = ve_pair.getE();
        if (this.graph.getEdgeType(e) != EdgeType.DIRECTED) {
            throw new IllegalArgumentException("This Function only operates on directed edges");
        }
        return 1.0 / (double)(this.graph.isSource(v, e) ? this.graph.outDegree(v) : this.graph.inDegree(v));
    }
}

