/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import generic.hash.FNV1a64MessageDigestFactory;
import generic.hash.MessageDigestFactory;
import generic.stl.Pair;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidFileManager;
import ghidra.feature.fid.db.FidQueryService;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.feature.fid.hash.FidHasher;
import ghidra.feature.fid.hash.FunctionBodyFunctionExtentGenerator;
import ghidra.feature.fid.hash.FunctionExtentGenerator;
import ghidra.feature.fid.hash.MessageDigestFidHasher;
import ghidra.feature.fid.service.FidPopulateResult;
import ghidra.feature.fid.service.FidProgramSeeker;
import ghidra.feature.fid.service.FidSearchResult;
import ghidra.feature.fid.service.FidServiceLibraryIngest;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.search.InstructionSkipper;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class FidService {
    public static final byte SHORT_HASH_CODE_UNIT_LENGTH = 4;
    public static final byte MEDIUM_HASH_CODE_UNIT_LENGTH = 24;
    public static final float SCORE_THRESHOLD = 14.6f;
    public static final float MULTINAME_SCORE_THRESHOLD = 30.0f;
    private FidFileManager fidFileManager = FidFileManager.getInstance();
    private FunctionExtentGenerator generator = new FunctionBodyFunctionExtentGenerator();
    private MessageDigestFactory digestFactory = new FNV1a64MessageDigestFactory();
    private HashMap<Processor, List<InstructionSkipper>> skippers = new HashMap();

    public FidService() {
        Set classes = ClassSearcher.getClasses(InstructionSkipper.class);
        for (Class clazz : classes) {
            try {
                InstructionSkipper skipper = (InstructionSkipper)clazz.newInstance();
                Processor processor = skipper.getApplicableProcessor();
                List<InstructionSkipper> list = this.skippers.get(processor);
                if (list == null) {
                    list = new ArrayList<InstructionSkipper>();
                    this.skippers.put(processor, list);
                }
                list.add(skipper);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public byte getShortHashCodeUnitLength() {
        return 4;
    }

    public byte getMediumHashCodeUnitLengthLimit() {
        return 24;
    }

    public float getDefaultScoreThreshold() {
        return 14.6f;
    }

    public float getDefaultMultiNameThreshold() {
        return 30.0f;
    }

    public FidHashQuad hashFunction(Function function) throws MemoryAccessException {
        List<CodeUnit> codeUnits = this.generator.calculateExtent(function);
        if (codeUnits.size() < this.getShortHashCodeUnitLength()) {
            return null;
        }
        FidHasher fidHasher = this.getHasher(function.getProgram());
        FidHashQuad hashTriple = fidHasher.hash(function);
        return hashTriple;
    }

    public FidHasher getHasher(Program program) {
        List<Object> list = this.skippers.get(program.getLanguage().getProcessor());
        if (list == null) {
            list = Collections.emptyList();
        }
        MessageDigestFidHasher fidHasher = new MessageDigestFidHasher(this.generator, 4, this.digestFactory, list);
        return fidHasher;
    }

    public FidProgramSeeker getProgramSeeker(Program program, FidQueryService fidQueryService, float scoreThreshold) throws VersionException, IOException {
        FidHasher fidHasher = this.getHasher(program);
        FidProgramSeeker seeker = new FidProgramSeeker(fidQueryService, program, fidHasher, this.getShortHashCodeUnitLength(), this.getMediumHashCodeUnitLengthLimit(), scoreThreshold);
        return seeker;
    }

    public FidPopulateResult createNewLibraryFromPrograms(FidDB fidDb, String libraryFamilyName, String libraryVersion, String libraryVariant, List<DomainFile> programDomainFiles, Predicate<Pair<Function, FidHashQuad>> functionFilter, LanguageID languageId, List<LibraryRecord> linkLibraries, List<String> commonSymbols, TaskMonitor monitor) throws MemoryAccessException, VersionException, CancelledException, IllegalStateException, IOException {
        FidServiceLibraryIngest ingest = new FidServiceLibraryIngest(fidDb, this, libraryFamilyName, libraryVersion, libraryVariant, programDomainFiles, functionFilter, languageId, linkLibraries, monitor);
        ingest.markCommonChildReferences(commonSymbols);
        return ingest.create();
    }

    public List<FidSearchResult> processProgram(Program program, FidQueryService queryService, float scoreThreshold, TaskMonitor monitor) throws CancelledException, VersionException, IOException {
        FidProgramSeeker seeker = this.getProgramSeeker(program, queryService, scoreThreshold);
        List<FidSearchResult> searchResult = seeker.search(monitor);
        return searchResult;
    }

    public List<FunctionRecord> markRecordsAutoPass(List<FunctionRecord> funcList, boolean value) throws IOException {
        ArrayList<FunctionRecord> res = new ArrayList<FunctionRecord>();
        for (FunctionRecord funcRec : funcList) {
            res.add(funcRec.getFidDb().setAutoPassOnFunction(funcRec, value));
        }
        return res;
    }

    public List<FunctionRecord> markRecordsAutoFail(List<FunctionRecord> funcList, boolean value) throws IOException {
        ArrayList<FunctionRecord> res = new ArrayList<FunctionRecord>();
        for (FunctionRecord funcRec : funcList) {
            res.add(funcRec.getFidDb().setAutoFailOnFunction(funcRec, value));
        }
        return res;
    }

    public List<FunctionRecord> markRecordsForceSpecific(List<FunctionRecord> funcList, boolean value) throws IOException {
        ArrayList<FunctionRecord> res = new ArrayList<FunctionRecord>();
        for (FunctionRecord funcRec : funcList) {
            res.add(funcRec.getFidDb().setForceSpecificOnFunction(funcRec, value));
        }
        return res;
    }

    public List<FunctionRecord> markRecordsForceRelation(List<FunctionRecord> funcList, boolean value) throws IOException {
        ArrayList<FunctionRecord> res = new ArrayList<FunctionRecord>();
        for (FunctionRecord funcRec : funcList) {
            res.add(funcRec.getFidDb().setForceRelationOnFunction(funcRec, value));
        }
        return res;
    }

    public boolean canProcess(Language language) {
        return this.fidFileManager.canQuery(language);
    }

    public FidQueryService openFidQueryService(Language language, boolean openForUpdate) throws VersionException, IOException {
        return this.fidFileManager.openFidQueryService(language, openForUpdate);
    }
}

