/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionToGuiMapper;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.ComponentTransferable;
import docking.DockableHeader;
import docking.DockingWindowManager;
import docking.DropCode;
import docking.action.DockingActionIf;
import docking.help.HelpService;
import ghidra.util.CascadedDropTarget;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.CellRendererPane;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DockableComponent
extends JPanel
implements ContainerListener {
    private static final int DROP_EDGE_OFFSET = 20;
    private static final Dimension MIN_DIM = new Dimension(100, 50);
    public static DropCode DROP_CODE;
    public static ComponentPlaceholder TARGET_INFO;
    public static ComponentPlaceholder DRAGGED_OVER_INFO;
    public static ComponentPlaceholder SOURCE_INFO;
    public static boolean DROP_CODE_SET;
    private DockableHeader header;
    private MouseListener popupListener;
    private ComponentPlaceholder placeholder;
    private JComponent providerComp;
    private Component focusedComponent;
    private DockingWindowManager winMgr;
    private ActionToGuiMapper actionMgr;
    private DropTarget dockableDropTarget;

    DockableComponent(ComponentPlaceholder placeholder, boolean isDocking) {
        if (placeholder != null) {
            this.placeholder = placeholder;
            this.winMgr = placeholder.getNode().winMgr;
            this.actionMgr = this.winMgr.getActionToGuiMapper();
            this.popupListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DockableComponent.this.componentSelected((Component)e.getSource());
                    DockableComponent.this.processPopupMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    DockableComponent.this.processPopupMouseEvent(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    DockableComponent.this.processPopupMouseEvent(e);
                }
            };
            this.dockableDropTarget = new DockableComponentDropTarget(this);
            this.initializeComponents(this);
            this.setLayout(new BorderLayout());
            this.header = new DockableHeader(this, isDocking);
            if (placeholder.isHeaderShowing()) {
                this.add((Component)this.header, "North");
            }
            this.providerComp = this.initializeComponentPlaceholder(placeholder);
            JPanel contentPanel = new JPanel(new BorderLayout());
            this.setFocusable(false);
            this.setFocusCycleRoot(false);
            contentPanel.add((Component)this.providerComp, "Center");
            this.add((Component)contentPanel, "Center");
        } else {
            this.dockableDropTarget = new DockableComponentDropTarget(this);
        }
    }

    private JComponent initializeComponentPlaceholder(ComponentPlaceholder newPlaceholder) {
        JComponent providerComponent = newPlaceholder.getProviderComponent();
        ComponentProvider provider = newPlaceholder.getProvider();
        HelpLocation helpLocation = provider.getHelpLocation();
        HelpLocation location = this.registerHelpLocation(provider, helpLocation);
        this.header.setHelp(location);
        return providerComponent;
    }

    public DockableHeader getHeader() {
        return this.header;
    }

    private HelpLocation registerHelpLocation(ComponentProvider provider, HelpLocation helpLocation) {
        HelpService helpService = DockingWindowManager.getHelpService();
        if (helpService.isExcludedFromHelp(provider)) {
            return null;
        }
        HelpLocation registeredHelpLocation = helpService.getHelpLocation(provider);
        if (registeredHelpLocation != null) {
            return registeredHelpLocation;
        }
        if (helpLocation == null) {
            helpLocation = new HelpLocation(provider.getOwner(), provider.getName());
        }
        helpService.registerHelp(provider, helpLocation);
        return helpLocation;
    }

    public Component getFocusedComponent() {
        return this.focusedComponent;
    }

    private void processPopupMouseEvent(MouseEvent e) {
        Component component = e.getComponent();
        if (component == null) {
            return;
        }
        Rectangle bounds = component.getBounds();
        if (component instanceof JComponent) {
            ((JComponent)component).computeVisibleRect(bounds);
        }
        Point point = e.getPoint();
        boolean withinBounds = bounds.contains(point);
        if (e.isPopupTrigger() && withinBounds) {
            this.actionMgr.showPopupMenu(this.placeholder, e);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_DIM;
    }

    JComponent getProviderComponent() {
        return this.providerComp;
    }

    public ComponentPlaceholder getComponentWindowingPlaceholder() {
        return this.placeholder;
    }

    public ComponentProvider getComponentProvider() {
        if (this.placeholder == null) {
            return null;
        }
        return this.placeholder.getProvider();
    }

    public DockingWindowManager getDockingWindowManager() {
        if (this.placeholder == null) {
            return null;
        }
        return this.placeholder.getNode().getDockingWindowManager();
    }

    @Override
    public String toString() {
        if (this.placeholder == null) {
            return "";
        }
        return this.placeholder.getFullTitle();
    }

    private void translate(Point p, Component c) {
        Point cLoc = c.getLocationOnScreen();
        Point myLoc = this.getLocationOnScreen();
        p.x = p.x + cLoc.x - myLoc.x;
        p.y = p.y + cLoc.y - myLoc.y;
    }

    public void installDragDropTarget(Component component) {
        new DockableComponentDropTarget(component);
    }

    private void initializeComponents(Component comp) {
        DropTarget dt;
        if (comp instanceof CellRendererPane) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps;
            Container c = (Container)comp;
            c.addContainerListener(this);
            for (Component comp2 : comps = c.getComponents()) {
                this.initializeComponents(comp2);
            }
        }
        if ((dt = comp.getDropTarget()) != null) {
            new CascadedDropTarget(comp, this.dockableDropTarget, dt);
        }
        if (comp.isFocusable()) {
            comp.removeMouseListener(this.popupListener);
            comp.addMouseListener(this.popupListener);
        }
    }

    private void deinitializeComponents(Component comp) {
        DropTarget dt;
        if (comp instanceof CellRendererPane) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps;
            Container c = (Container)comp;
            c.removeContainerListener(this);
            for (Component comp2 : comps = c.getComponents()) {
                this.deinitializeComponents(comp2);
            }
        }
        if ((dt = comp.getDropTarget()) instanceof CascadedDropTarget) {
            CascadedDropTarget cascadedDropTarget = (CascadedDropTarget)dt;
            DropTarget newDropTarget = cascadedDropTarget.removeDropTarget(this.dockableDropTarget);
            comp.setDropTarget(newDropTarget);
        }
        comp.removeMouseListener(this.popupListener);
    }

    private void setDropCode(Point p) {
        DROP_CODE_SET = true;
        if (this.placeholder == null) {
            DROP_CODE = DropCode.ROOT;
            return;
        }
        if (SOURCE_INFO == null) {
            DROP_CODE = DropCode.WINDOW;
            return;
        }
        if (DockableComponent.SOURCE_INFO.getNode().winMgr != this.placeholder.getNode().winMgr) {
            DROP_CODE = DropCode.WINDOW;
            return;
        }
        if (SOURCE_INFO == this.placeholder && !this.placeholder.isStacked()) {
            DROP_CODE = DropCode.INVALID;
            return;
        }
        DROP_CODE = p.x < 20 ? DropCode.LEFT : (p.x > this.getWidth() - 20 ? DropCode.RIGHT : (p.y < 20 ? DropCode.TOP : (p.y > this.getHeight() - 20 ? DropCode.BOTTOM : (SOURCE_INFO == this.placeholder ? DropCode.INVALID : DropCode.STACK))));
    }

    void setSelected(boolean selected) {
        this.header.setSelected(selected);
    }

    void emphasize() {
        this.header.emphasize();
    }

    void setTitle(String title) {
        this.header.setTitle(title);
    }

    void setIcon(Icon icon) {
        this.header.setIcon(icon);
    }

    void dispose() {
        this.header.dispose();
        this.header = null;
        this.placeholder = null;
        this.providerComp = null;
        this.actionMgr = null;
    }

    void actionAdded(DockingActionIf action) {
        this.header.actionAdded(action);
    }

    void actionRemoved(DockingActionIf action) {
        this.header.actionRemoved(action);
    }

    @Override
    public void requestFocus() {
        this.focusedComponent = this.findFocusedComponent();
        if (this.focusedComponent != null) {
            DockingWindowManager.requestFocus(this.focusedComponent);
        }
    }

    void setFocusedComponent(Component newFocusedComponet) {
        this.focusedComponent = newFocusedComponet;
    }

    private void componentSelected(Component component) {
        if (!component.isFocusable()) {
            this.requestFocus();
        }
    }

    private Component findFocusedComponent() {
        if (this.focusedComponent != null && this.focusedComponent.isShowing()) {
            return this.focusedComponent;
        }
        DefaultFocusManager dfm = (DefaultFocusManager)FocusManager.getCurrentManager();
        Component component = dfm.getComponentAfter(this, this);
        if (component != null && SwingUtilities.isDescendingFrom(component, this)) {
            return component;
        }
        return null;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.initializeComponents(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.deinitializeComponents(e.getChild());
    }

    private class DockableComponentDropTarget
    extends DropTarget {
        DockableComponentDropTarget(Component comp) {
            super(comp, null);
        }

        @Override
        public synchronized void drop(DropTargetDropEvent dtde) {
            this.clearAutoscroll();
            if (dtde.isDataFlavorSupported(ComponentTransferable.localComponentProviderFlavor)) {
                Point p = dtde.getLocation();
                DockableComponent.this.translate(p, ((DropTarget)dtde.getSource()).getComponent());
                DockableComponent.this.setDropCode(p);
                TARGET_INFO = DockableComponent.this.placeholder;
                dtde.acceptDrop(dtde.getDropAction());
                dtde.dropComplete(true);
            } else {
                dtde.rejectDrop();
            }
        }

        @Override
        public synchronized void dragEnter(DropTargetDragEvent dtde) {
            super.dragEnter(dtde);
            if (!DockableComponent.this.isShowing()) {
                dtde.rejectDrag();
                return;
            }
            if (dtde.isDataFlavorSupported(ComponentTransferable.localComponentProviderFlavor)) {
                Point p = dtde.getLocation();
                DockableComponent.this.translate(p, ((DropTarget)dtde.getSource()).getComponent());
                DockableComponent.this.setDropCode(p);
                DRAGGED_OVER_INFO = DockableComponent.this.placeholder;
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public synchronized void dragOver(DropTargetDragEvent dtde) {
            super.dragOver(dtde);
            if (!DockableComponent.this.isShowing()) {
                dtde.rejectDrag();
                return;
            }
            if (dtde.isDataFlavorSupported(ComponentTransferable.localComponentProviderFlavor)) {
                Point p = dtde.getLocation();
                DockableComponent.this.translate(p, ((DropTarget)dtde.getSource()).getComponent());
                DockableComponent.this.setDropCode(p);
                DRAGGED_OVER_INFO = DockableComponent.this.placeholder;
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public synchronized void dragExit(DropTargetEvent dte) {
            super.dragExit(dte);
            DROP_CODE = DropCode.WINDOW;
            DROP_CODE_SET = true;
            DRAGGED_OVER_INFO = null;
        }
    }
}

