/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.auth;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rzo.netty.ahessian.auth.AuthToken;
import org.rzo.netty.ahessian.auth.ByteArrayWrapper;
import org.rzo.netty.ahessian.auth.SimpleAuthToken;

public class AuthTokenList
implements AuthToken {
    private Map<ByteArrayWrapper, AuthToken> _tokens;
    int _receivedLength = 0;
    byte[] _receivedBytes;
    AuthToken _currentToken;
    boolean _uniqueLogon;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SimpleAuthToken.class);

    public AuthTokenList(Map<ByteArrayWrapper, AuthToken> tokens, int bytesLength, boolean uniqueLogon) {
        this._tokens = tokens;
        this._receivedBytes = new byte[bytesLength];
        this._uniqueLogon = uniqueLogon;
    }

    public static AuthTokenList fromList(List<AuthToken> tokens, boolean uniqueLogon) {
        HashMap<ByteArrayWrapper, AuthToken> tks = new HashMap<ByteArrayWrapper, AuthToken>();
        int bytesLength = 0;
        for (AuthToken token : tokens) {
            byte[] pwd = ((SimpleAuthToken)token).getPassword();
            tks.put(new ByteArrayWrapper(pwd), token);
            if (bytesLength >= pwd.length) continue;
            bytesLength = pwd.length;
        }
        return new AuthTokenList(tks, bytesLength, uniqueLogon);
    }

    public static AuthTokenList fromList(List<AuthToken> tokens) {
        return AuthTokenList.fromList(tokens, false);
    }

    @Override
    public int authenticate(ChannelHandlerContext ctx, ByteBuf e) {
        ByteBuf b = e;
        int toCopy = Math.min(this._receivedBytes.length - this._receivedLength, b.readableBytes());
        byte[] bytes = new byte[toCopy];
        b.readBytes(bytes);
        System.arraycopy(bytes, 0, this._receivedBytes, this._receivedLength, bytes.length);
        this._receivedLength += toCopy;
        if (this._receivedLength == this._receivedBytes.length) {
            this._currentToken = this._tokens.get(new ByteArrayWrapper(this._receivedBytes));
            if (this._currentToken != null && (this._uniqueLogon || this._currentToken.isLoggedOn())) {
                logger.info("authenticated");
                ((SimpleAuthToken)this._currentToken).setLoggedOn(true);
                if (b.readableBytes() != 0) {
                    ctx.fireChannelRead((Object)e);
                }
                return 1;
            }
            this._currentToken = null;
            return 2;
        }
        return 0;
    }

    public AuthToken authenticate(String password) throws Exception {
        ByteArrayWrapper input = new ByteArrayWrapper(password.getBytes("UTF-8"));
        AuthToken result = this._tokens.get(input);
        if (result == null) {
            return null;
        }
        if (this._uniqueLogon && result.isLoggedOn()) {
            return null;
        }
        ((SimpleAuthToken)result).setLoggedOn(true);
        return result;
    }

    @Override
    public void sendPassword(ChannelHandlerContext ctx) {
    }

    @Override
    public boolean isLoggedOn() {
        return this._currentToken != null;
    }

    public void setLoggedOn(boolean value) {
        if (!value && this._currentToken != null) {
            ((SimpleAuthToken)this._currentToken).setLoggedOn(false);
            this._currentToken = null;
        }
    }

    @Override
    public void disconnected() {
        this.setLoggedOn(false);
    }
}

