/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import docking.widgets.tabbedpane.DockingTabRenderer;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import resources.ResourceManager;

public class FunctionComparisonPanel
extends JPanel
implements ChangeListener {
    private static final String DEFAULT_CODE_COMPARISON_VIEW = "Listing View";
    private static final String COMPARISON_VIEW_DISPLAYED = "COMPARISON_VIEW_DISPLAYED";
    private static final String CODE_COMPARISON_LOCK_SCROLLING_TOGETHER = "CODE_COMPARISON_LOCK_SCROLLING_TOGETHER";
    private static final HelpService help = Help.getHelpService();
    private static final String HELP_TOPIC = "FunctionComparison";
    private static final Icon SYNC_SCROLLING_ICON = ResourceManager.loadImage((String)"images/lock.gif");
    private static final Icon UNSYNC_SCROLLING_ICON = ResourceManager.loadImage((String)"images/unlock.gif");
    private static final String SCROLLING_GROUP = "A9_SCROLLING";
    private static final String DUAL_SCROLLING_ACTION_GROUP = "DualScrolling";
    private static final String DUAL_SCROLLING_HELP_TOPIC = "FunctionComparison";
    private JTabbedPane tabbedPane;
    private HashMap<String, JComponent> tabNameToComponentMap;
    protected PluginTool tool;
    protected ComponentProvider provider;
    protected Program leftProgram;
    protected Program rightProgram;
    private Function leftFunction;
    private Function rightFunction;
    private Data leftData;
    private Data rightData;
    private AddressSetView leftAddressSet = new AddressSet();
    private AddressSetView rightAddressSet = new AddressSet();
    private List<CodeComparisonPanel<? extends FieldPanelCoordinator>> codeComparisonPanels;
    private ToggleScrollLockAction toggleScrollLockAction;
    private boolean syncScrolling = false;

    public FunctionComparisonPanel(ComponentProvider provider, PluginTool tool, Function leftFunction, Function rightFunction) {
        this.provider = provider;
        this.tool = tool;
        this.leftFunction = leftFunction;
        this.rightFunction = rightFunction;
        this.leftProgram = leftFunction != null ? leftFunction.getProgram() : null;
        this.rightProgram = rightFunction != null ? rightFunction.getProgram() : null;
        this.codeComparisonPanels = this.getCodeComparisonPanels();
        this.leftAddressSet = leftFunction != null ? leftFunction.getBody() : new AddressSet();
        this.rightAddressSet = rightFunction != null ? rightFunction.getBody() : new AddressSet();
        this.tabNameToComponentMap = new HashMap();
        this.create();
        this.createActions();
        this.setScrollingSyncState(true);
        help.registerHelp((Object)this, new HelpLocation("FunctionComparison", "Function Comparison"));
    }

    private List<CodeComparisonPanel<? extends FieldPanelCoordinator>> getCodeComparisonPanels() {
        if (this.codeComparisonPanels == null) {
            this.codeComparisonPanels = new ArrayList<CodeComparisonPanel<? extends FieldPanelCoordinator>>();
            Set<CodeComparisonPanel<? extends FieldPanelCoordinator>> instances = this.createAllPossibleCodeComparisonPanels();
            ArrayList<Class<CodeComparisonPanel<? extends FieldPanelCoordinator>>> classesOfPanelsToSupersede = new ArrayList<Class<CodeComparisonPanel<? extends FieldPanelCoordinator>>>();
            for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : instances) {
                this.codeComparisonPanels.add(codeComparisonPanel);
                Class<CodeComparisonPanel<? extends FieldPanelCoordinator>> panelThisSupersedes = codeComparisonPanel.getPanelThisSupersedes();
                if (panelThisSupersedes == null) continue;
                classesOfPanelsToSupersede.add(panelThisSupersedes);
            }
            Iterator<CodeComparisonPanel<? extends FieldPanelCoordinator>> iterator = this.codeComparisonPanels.iterator();
            while (iterator.hasNext()) {
                CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel;
                codeComparisonPanel = iterator.next();
                if (!classesOfPanelsToSupersede.contains(codeComparisonPanel.getClass())) continue;
                iterator.remove();
            }
            CodeComparisonPanelComparator comparator = new CodeComparisonPanelComparator();
            this.codeComparisonPanels.sort(comparator);
        }
        return this.codeComparisonPanels;
    }

    private Set<CodeComparisonPanel<? extends FieldPanelCoordinator>> createAllPossibleCodeComparisonPanels() {
        HashSet<CodeComparisonPanel<? extends FieldPanelCoordinator>> instances = new HashSet<CodeComparisonPanel<? extends FieldPanelCoordinator>>();
        Set classes = ClassSearcher.getClasses(CodeComparisonPanel.class);
        for (Class panelClass : classes) {
            try {
                Constructor constructor = panelClass.getConstructor(String.class, PluginTool.class);
                CodeComparisonPanel panel = (CodeComparisonPanel)constructor.newInstance(this.provider.getName(), this.tool);
                instances.add(panel);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Msg.showError((Object)this, null, (String)"Error Creating Extension Point", (Object)("Error creating class " + panelClass.getName() + " when creating extension points for " + CodeComparisonPanel.class.getName()), (Throwable)e);
            }
        }
        return instances;
    }

    public void loadFunctions(Function newLeftFunction, Function newRightFunction) {
        if (this.leftFunction != null && this.leftFunction.equals(newLeftFunction) && this.rightFunction != null && this.rightFunction.equals(newRightFunction)) {
            return;
        }
        this.leftData = null;
        this.rightData = null;
        this.leftFunction = newLeftFunction;
        this.rightFunction = newRightFunction;
        this.leftProgram = this.leftFunction != null ? this.leftFunction.getProgram() : null;
        this.rightProgram = this.rightFunction != null ? this.rightFunction.getProgram() : null;
        this.leftAddressSet = this.leftFunction != null ? this.leftFunction.getBody() : new AddressSet();
        this.rightAddressSet = this.rightFunction != null ? this.rightFunction.getBody() : new AddressSet();
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadFunctions(this.leftFunction, this.rightFunction);
        }
    }

    public void loadData(Data newLeftData, Data newRightData) {
        if (this.leftData != null && this.leftData.equals(newLeftData) && this.rightData != null && this.rightData.equals(newRightData)) {
            return;
        }
        this.leftFunction = null;
        this.rightFunction = null;
        this.leftData = newLeftData;
        this.rightData = newRightData;
        this.leftProgram = this.leftData != null ? this.leftData.getProgram() : null;
        this.rightProgram = this.rightData != null ? this.rightData.getProgram() : null;
        this.leftAddressSet = this.leftData != null ? new AddressSet(this.leftData.getMinAddress(), this.leftData.getMaxAddress()) : new AddressSet();
        this.rightAddressSet = this.rightData != null ? new AddressSet(this.rightData.getMinAddress(), this.rightData.getMaxAddress()) : new AddressSet();
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadData(this.leftData, this.rightData);
        }
    }

    public void loadAddresses(Program newLeftProgram, Program newRightProgram, AddressSetView newLeftAddresses, AddressSetView newRightAddresses) {
        this.leftData = null;
        this.rightData = null;
        this.leftFunction = null;
        this.rightFunction = null;
        this.leftProgram = newLeftProgram;
        this.rightProgram = newRightProgram;
        this.leftAddressSet = new AddressSet(newLeftAddresses);
        this.rightAddressSet = new AddressSet(newRightAddresses);
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadAddresses(this.leftProgram, this.rightProgram, this.leftAddressSet, this.rightAddressSet);
        }
    }

    public void clear() {
        this.leftData = null;
        this.rightData = null;
        this.leftFunction = null;
        this.rightFunction = null;
        this.leftAddressSet = new AddressSet();
        this.rightAddressSet = new AddressSet();
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel != null) {
            activePanel.loadAddresses(null, null, null, null);
        }
    }

    public ListingCodeComparisonPanel getDualListingPanel() {
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            JComponent component = codeComparisonPanel.getComponent();
            if (!(component instanceof ListingCodeComparisonPanel)) continue;
            return (ListingCodeComparisonPanel)component;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.tabChanged();
    }

    boolean isTabClick(MouseEvent event) {
        Component component = event.getComponent();
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            DockingTabRenderer renderer = (DockingTabRenderer)this.tabbedPane.getTabComponentAt(i);
            if (!SwingUtilities.isDescendingFrom(component, (Component)renderer)) continue;
            return true;
        }
        return false;
    }

    public boolean setCurrentTabbedComponent(String name) {
        JComponent component = this.tabNameToComponentMap.get(name);
        if (component != null) {
            if (this.tabbedPane.getSelectedComponent() == component) {
                this.tabChanged();
            }
            this.tabbedPane.setSelectedComponent(component);
        }
        return component != null;
    }

    CodeComparisonPanel<? extends FieldPanelCoordinator> getCurrentComponent() {
        return (CodeComparisonPanel)this.tabbedPane.getSelectedComponent();
    }

    public String getCurrentComponentName() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            return this.tabbedPane.getTitleAt(selectedIndex);
        }
        return null;
    }

    int getNumberOfTabbedComponents() {
        return this.tabNameToComponentMap.size();
    }

    public void dispose() {
        this.tool.removeComponentProvider(this.provider);
        this.tabbedPane.removeAll();
        this.setVisible(false);
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.dispose();
        }
    }

    private void create() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setPreferredSize(new Dimension(200, 300));
        this.leftProgram = this.leftFunction != null ? this.leftFunction.getProgram() : null;
        this.rightProgram = this.rightFunction != null ? this.rightFunction.getProgram() : null;
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.loadFunctions(this.leftFunction, this.rightFunction);
            JComponent component = codeComparisonPanel.getComponent();
            this.addTab(codeComparisonPanel.getTitle(), component);
        }
    }

    private void addTab(String title, JComponent component) {
        this.tabbedPane.add(title, component);
        this.tabNameToComponentMap.put(title, component);
    }

    private void tabChanged() {
        CodeComparisonPanel<? extends FieldPanelCoordinator> activePanel = this.getActiveComparisonPanel();
        if (activePanel == null) {
            return;
        }
        if (this.leftFunction != null || this.rightFunction != null) {
            activePanel.loadFunctions(this.leftFunction, this.rightFunction);
        } else if (this.leftData != null || this.rightData != null) {
            activePanel.loadData(this.leftData, this.rightData);
        } else {
            activePanel.loadAddresses(this.leftProgram, this.rightProgram, this.leftAddressSet, this.rightAddressSet);
        }
    }

    private CodeComparisonPanel<? extends FieldPanelCoordinator> getActiveComparisonPanel() {
        JComponent c = (JComponent)this.tabbedPane.getSelectedComponent();
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            JComponent component = codeComparisonPanel.getComponent();
            if (c != component) continue;
            return codeComparisonPanel;
        }
        return null;
    }

    public Function[] getFunctions() {
        return new Function[]{this.leftFunction, this.rightFunction};
    }

    public Function getLeftFunction() {
        return this.leftFunction;
    }

    protected void setLeftFunction(Function function) {
        this.loadFunctions(function, this.rightFunction);
    }

    public Function getRightFunction() {
        return this.rightFunction;
    }

    protected void setRightFunction(Function function) {
        this.loadFunctions(this.leftFunction, function);
    }

    public Data getLeftData() {
        return this.leftData;
    }

    public Data getRightData() {
        return this.rightData;
    }

    public void setMouseNavigationEnabled(boolean enabled) {
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.setMouseNavigationEnabled(enabled);
        }
    }

    public void readConfigState(String prefix, SaveState saveState) {
        String currentTabView = saveState.getString(prefix + COMPARISON_VIEW_DISPLAYED, DEFAULT_CODE_COMPARISON_VIEW);
        this.setCurrentTabbedComponent(currentTabView);
        this.setScrollingSyncState(saveState.getBoolean(prefix + CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, true));
        ListingCodeComparisonPanel dualListingPanel = this.getDualListingPanel();
        if (dualListingPanel != null) {
            dualListingPanel.readConfigState(prefix, saveState);
        }
    }

    public void writeConfigState(String prefix, SaveState saveState) {
        String currentComponentName = this.getCurrentComponentName();
        if (currentComponentName != null) {
            saveState.putString(prefix + COMPARISON_VIEW_DISPLAYED, this.getCurrentComponentName());
        }
        saveState.putBoolean(prefix + CODE_COMPARISON_LOCK_SCROLLING_TOGETHER, this.isScrollingSynced());
        ListingCodeComparisonPanel dualListingPanel = this.getDualListingPanel();
        if (dualListingPanel != null) {
            dualListingPanel.writeConfigState(prefix, saveState);
        }
    }

    public DockingAction[] getCodeComparisonActions() {
        ArrayList<DockingAction> dockingActionList = new ArrayList<DockingAction>();
        DockingAction[] functionComparisonActions = this.getActions();
        for (DockingAction dockingAction : functionComparisonActions) {
            dockingActionList.add(dockingAction);
        }
        for (CodeComparisonPanel codeComparisonPanel : this.codeComparisonPanels) {
            DockingAction[] actions;
            for (DockingAction dockingAction : actions = codeComparisonPanel.getActions()) {
                dockingActionList.add(dockingAction);
            }
        }
        return dockingActionList.toArray(new DockingAction[dockingActionList.size()]);
    }

    public CodeComparisonPanel<? extends FieldPanelCoordinator> getDisplayedPanel() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        Component component = this.tabbedPane.getComponentAt(selectedIndex);
        return (CodeComparisonPanel)component;
    }

    public List<CodeComparisonPanel<? extends FieldPanelCoordinator>> getMatchingPanels(Class<? extends CodeComparisonPanel<? extends FieldPanelCoordinator>> clazz) {
        Component[] components;
        ArrayList<CodeComparisonPanel<? extends FieldPanelCoordinator>> matchingPanels = new ArrayList<CodeComparisonPanel<? extends FieldPanelCoordinator>>();
        for (Component component : components = this.tabbedPane.getComponents()) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            matchingPanels.add((CodeComparisonPanel)component);
        }
        return matchingPanels;
    }

    public void setTitlePrefixes(String leftTitlePrefix, String rightTitlePrefix) {
        Component[] components;
        for (Component component : components = this.tabbedPane.getComponents()) {
            if (!(component instanceof CodeComparisonPanel)) continue;
            ((CodeComparisonPanel)component).setTitlePrefixes(leftTitlePrefix, rightTitlePrefix);
        }
    }

    public ActionContext getActionContext(MouseEvent event, ComponentProvider componentProvider) {
        Object source = event != null ? event.getSource() : null;
        Component sourceComponent = source instanceof Component ? (Component)source : null;
        ListingCodeComparisonPanel dualListingPanel = this.getDualListingPanel();
        if (dualListingPanel != null && dualListingPanel.isAncestorOf(sourceComponent)) {
            return dualListingPanel.getActionContext(event, componentProvider);
        }
        return null;
    }

    public final boolean isScrollingSynced() {
        return this.syncScrolling;
    }

    public void setScrollingSyncState(boolean syncScrolling) {
        if (this.isScrollingSynced() == syncScrolling) {
            return;
        }
        this.toggleScrollLockAction.setSelected(syncScrolling);
        this.toggleScrollLockAction.setToolBarData(new ToolBarData(syncScrolling ? SYNC_SCROLLING_ICON : UNSYNC_SCROLLING_ICON, SCROLLING_GROUP));
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.setScrollingSyncState(syncScrolling);
        }
        this.syncScrolling = syncScrolling;
    }

    private void createActions() {
        this.toggleScrollLockAction = new ToggleScrollLockAction();
    }

    public DockingAction[] getActions() {
        DockingAction[] actions = new DockingAction[]{this.toggleScrollLockAction};
        return actions;
    }

    public void updateActionEnablement() {
        for (CodeComparisonPanel<? extends FieldPanelCoordinator> codeComparisonPanel : this.codeComparisonPanels) {
            codeComparisonPanel.updateActionEnablement();
        }
    }

    class ToggleScrollLockAction
    extends ToggleDockingAction {
        ToggleScrollLockAction() {
            super("Synchronize Scrolling of Dual View", FunctionComparisonPanel.this.provider.getName());
            this.setDescription("Lock/Unlock Synchronized Scrolling of Dual View");
            this.setToolBarData(new ToolBarData(UNSYNC_SCROLLING_ICON, FunctionComparisonPanel.SCROLLING_GROUP));
            this.setEnabled(true);
            MenuData menuData = new MenuData(new String[]{"Synchronize Scrolling"}, FunctionComparisonPanel.DUAL_SCROLLING_ACTION_GROUP);
            this.setMenuBarData(menuData);
            this.setHelpLocation(new HelpLocation("FunctionComparison", "Synchronize Scrolling of Dual View"));
        }

        public void actionPerformed(ActionContext context) {
            FunctionComparisonPanel.this.setScrollingSyncState(this.isSelected());
        }
    }

    private class CodeComparisonPanelComparator
    implements Comparator<CodeComparisonPanel<? extends FieldPanelCoordinator>> {
        private CodeComparisonPanelComparator() {
        }

        @Override
        public int compare(CodeComparisonPanel<? extends FieldPanelCoordinator> o1, CodeComparisonPanel<? extends FieldPanelCoordinator> o2) {
            if (o1 == o2) {
                return 0;
            }
            String title1 = o1.getTitle();
            String title2 = o2.getTitle();
            return title1.compareTo(title2);
        }
    }
}

