/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class NextPreviousNonFunctionAction
extends AbstractNextPreviousAction {
    public NextPreviousNonFunctionAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Non-Function", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.loadImage((String)"images/notF.gif");
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(78, 640);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Instruction Not In a Function";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        Function function = program.getListing().getFunctionContaining(address);
        if (function == null) {
            function = this.getNextFunction(program, address, true);
        }
        if (function == null) {
            return null;
        }
        return this.findNextInstructionAddressNotInFunction(monitor, program, function.getEntryPoint(), true);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        Function function = program.getListing().getFunctionContaining(address);
        if (function == null) {
            function = this.getNextFunction(program, address, false);
        }
        if (function == null) {
            return null;
        }
        return this.findNextInstructionAddressNotInFunction(monitor, program, function.getEntryPoint(), false);
    }

    private Address findNextInstructionAddressNotInFunction(TaskMonitor monitor, Program program, Address address, boolean isForward) throws CancelledException {
        Function function = program.getListing().getFunctionContaining(address);
        AddressSetView body = function.getBody();
        InstructionIterator it = program.getListing().getInstructions(address, isForward);
        while (it.hasNext()) {
            monitor.checkCanceled();
            Instruction instruction = it.next();
            Address instructionAddress = instruction.getMinAddress();
            if (body.contains(instructionAddress)) continue;
            function = program.getListing().getFunctionContaining(instructionAddress);
            if (function == null) {
                return instructionAddress;
            }
            body = function.getBody();
        }
        return null;
    }

    private Function getNextFunction(Program program, Address address, boolean forward) {
        FunctionIterator functionIterator = program.getListing().getFunctions(address, forward);
        if (!functionIterator.hasNext()) {
            return null;
        }
        return (Function)functionIterator.next();
    }

    @Override
    protected void gotoAddress(GoToService service, Navigatable navigatable, Address address) {
        service.goTo(navigatable, address);
    }
}

