/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.util.Msg;
import java.util.Objects;

public class StringAndScores {
    private String originalString = "";
    private String scoredString = "";
    private int[] asciiCodesForString;
    private volatile double ngramScore;
    private volatile double scoreThreshold;

    public StringAndScores(String str, boolean isLowerCaseModel) {
        this.originalString = Objects.requireNonNull(str);
        this.scoredString = isLowerCaseModel ? this.originalString.toLowerCase() : this.originalString;
        this.normalizeAndStoreAsciiCodes();
        this.ngramScore = -100.0;
        this.scoreThreshold = 10.0;
    }

    private void normalizeAndStoreAsciiCodes() {
        String intermediateString = this.scoredString.matches("^\\p{ASCII}*$") ? this.scoredString : this.replaceInvalidAscii(this.scoredString);
        this.scoredString = this.normalizeSpaces(intermediateString);
        this.translateToAsciiCodes();
    }

    private String replaceInvalidAscii(String string) {
        char[] stringChars = this.scoredString.toCharArray();
        char[] asciiStringChars = new char[stringChars.length];
        StringBuilder bad = new StringBuilder();
        for (int i = 0; i < stringChars.length; ++i) {
            char currentChar = stringChars[i];
            if (currentChar >= '\u0000' && currentChar <= '\u007f') {
                asciiStringChars[i] = stringChars[i];
                continue;
            }
            bad.append(Character.digit(stringChars[i], 10)).append(' ');
            asciiStringChars[i] = 32;
        }
        Msg.debug((Object)this, (Object)("Warning: found non-ASCII character(s) while analyzing '" + this.scoredString + "' --replacing with space characters during analysis.  Char values: " + bad));
        return new String(asciiStringChars);
    }

    private void translateToAsciiCodes() {
        char[] strChars = this.scoredString.toCharArray();
        this.asciiCodesForString = new int[strChars.length];
        for (int i = 0; i < strChars.length; ++i) {
            this.asciiCodesForString[i] = strChars[i];
        }
    }

    private String normalizeSpaces(String str) {
        String newStr = str;
        newStr = newStr.trim();
        newStr = newStr.replaceAll(" {2,}", " ");
        newStr = newStr.replaceAll("\t{2,}", "\t");
        return newStr;
    }

    public void setNgramScore(double ngSc) {
        this.ngramScore = ngSc;
    }

    public void setScoreThreshold(double thresh) {
        this.scoreThreshold = thresh;
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public String getScoredString() {
        return this.scoredString;
    }

    public double getNgramScore() {
        return this.ngramScore;
    }

    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    public int getScoredStringLength() {
        return this.asciiCodesForString.length;
    }

    public int[] getAsciiCodes() {
        return this.asciiCodesForString;
    }

    public boolean isScoreAboveThreshold() {
        return this.ngramScore > this.scoreThreshold;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringAndScores) {
            StringAndScores other = (StringAndScores)obj;
            return this.getOriginalString().equals(other.getOriginalString());
        }
        return false;
    }

    public int hashCode() {
        return this.originalString.hashCode();
    }

    public String toString() {
        String outStr = "OrigString =" + this.originalString + ",ScoredString =" + this.scoredString + ",ASCII =";
        for (int code : this.asciiCodesForString) {
            outStr = outStr + code + " ";
        }
        outStr = outStr + ",ngScore =" + this.ngramScore + ", threshold = " + this.scoreThreshold;
        return outStr;
    }

    public String summaryToString() {
        return this.ngramScore + "\t" + this.originalString;
    }
}

