/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.label.GDLabel;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.util.Msg;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.field.CodeUnitTableCellData;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CodeUnitTableCellRenderer
extends AbstractGColumnRenderer<CodeUnitTableCellData> {
    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JComponent component = (JComponent)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        if (value == null) {
            return component;
        }
        if (!(value instanceof CodeUnitTableCellData)) {
            Msg.error((Object)((Object)this), (Object)("Renderer is not being used on " + CodeUnitTableCellData.class.getSimpleName()));
            return component;
        }
        CodeUnitTableCellData cuData = (CodeUnitTableCellData)value;
        List<String> displayStrings = cuData.getDisplayStrings();
        String tooltipText = cuData.getHTMLDisplayString();
        component = displayStrings.size() > 1 ? this.getMultiLineRenderer(displayStrings) : this.getSingleLineRenderer(displayStrings.isEmpty() ? "" : displayStrings.get(0));
        component.setToolTipText(tooltipText);
        return component;
    }

    private JComponent getSingleLineRenderer(String displayText) {
        this.setText(displayText);
        this.setFont(this.getFixedWidthFont());
        return this;
    }

    private JComponent getMultiLineRenderer(List<String> displayStrings) {
        JPanel panel = new JPanel(new GridLayout(displayStrings.size(), 1));
        panel.setOpaque(true);
        panel.setBackground(this.getBackground());
        panel.setBorder(this.getBorder());
        for (String string : displayStrings) {
            GDLabel label = new GDLabel();
            label.setBackground(this.getBackground());
            label.setHorizontalAlignment(this.getHorizontalAlignment());
            label.setOpaque(this.isOpaque());
            label.setBorder(this.getNoFocusBorder());
            label.setFont(this.getFixedWidthFont());
            label.setText(string);
            panel.add((Component)label);
        }
        return panel;
    }

    public String getFilterString(CodeUnitTableCellData t, Settings settings) {
        if (t == null) {
            return "";
        }
        return t.getDisplayString();
    }
}

