/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import java.math.BigInteger;
import java.util.Arrays;

public class ContextCache {
    private int context_size = 0;
    private Register contextBaseRegister = null;
    private BigInteger lastContextValue;
    private int[] lastContextWords;

    public void registerVariable(Register register) {
        this.context_size = (register.getBaseRegister().getMinimumByteSize() + 3) / 4;
        this.contextBaseRegister = register.getBaseRegister();
    }

    public int getContextSize() {
        return this.context_size;
    }

    public void getContext(ProcessorContextView ctx, int[] buf) {
        if (this.contextBaseRegister == null) {
            return;
        }
        RegisterValue contextRegValue = ctx.getRegisterValue(this.contextBaseRegister);
        if (contextRegValue == null) {
            Arrays.fill(buf, 0);
            return;
        }
        BigInteger contextValue = contextRegValue.getUnsignedValueIgnoreMask();
        int[] words = this.getWords(contextValue);
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = words[i];
        }
    }

    private synchronized int[] getWords(BigInteger value) {
        if (value.equals(this.lastContextValue)) {
            return this.lastContextWords;
        }
        int[] words = new int[this.context_size];
        byte[] bytes = value.toByteArray();
        int byteIndexDiff = this.context_size * 4 - bytes.length;
        for (int i = 0; i < this.context_size; ++i) {
            int byteIndex = 4 * i - byteIndexDiff;
            int word = this.getByte(bytes, byteIndex);
            for (int j = 1; j < 4; ++j) {
                word = word << 8 | this.getByte(bytes, byteIndex + j);
            }
            words[i] = word;
        }
        this.lastContextValue = value;
        this.lastContextWords = words;
        return words;
    }

    private int getByte(byte[] bytes, int index) {
        if (index < 0 || index > bytes.length) {
            return 0;
        }
        return bytes[index] & 0xFF;
    }

    private void putInt(byte[] bytes, int index, int value) {
        for (int i = 3; i >= 0; --i) {
            bytes[index + i] = (byte)value;
            value >>= 8;
        }
    }

    public void setContext(ProcessorContext ctx, Address addr, int num, int mask, int value) {
        if (ctx instanceof DisassemblerContext) {
            DisassemblerContext context = (DisassemblerContext)ctx;
            int byteSize = this.context_size * 4;
            byte[] bytes = new byte[2 * byteSize];
            this.putInt(bytes, byteSize + num * 4, value);
            this.putInt(bytes, num * 4, mask);
            RegisterValue registerValue = new RegisterValue(this.contextBaseRegister, bytes);
            context.setFutureRegisterValue(addr, registerValue);
        }
    }
}

